/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.watchdog.listeners;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.sadun.util.watchdog.listeners.SendMailFailedException;
import org.sadun.util.watchdog.listeners.WaitAndRetryListener;

public class MailAlarmListener
extends WaitAndRetryListener {
    private String emailAddresses;
    private String hostname;
    private URL mailTemplateURL;
    private Session mailSession;

    public MailAlarmListener(String string, String string2, String string3) throws MalformedURLException {
        this(3, string, string2, string3);
    }

    public MailAlarmListener(String string, String string2) {
        this(3, string, string2);
    }

    public MailAlarmListener(int n, String string, String string2, String string3) throws MalformedURLException {
        super(n);
        this.init(string, string2);
        if (string3 != null) {
            this.mailTemplateURL = new URL(string3);
        }
    }

    public MailAlarmListener(int n, String string, String string2) {
        super(n);
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        this.emailAddresses = string;
        this.hostname = string2;
    }

    public MailAlarmListener() {
    }

    private void checkState() throws IllegalStateException {
        if (this.emailAddresses == null) {
            throw new IllegalStateException("No email addresses specified. Please set the EmailAddresses property");
        }
        if (this.hostname == null) {
            throw new IllegalStateException("No SMTP host name specified. Please set the HostName property");
        }
    }

    public void checkFailed(Object object, Throwable throwable) {
        this.checkState();
        StringTokenizer stringTokenizer = new StringTokenizer(this.emailAddresses, ",;");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                this.sendMail(stringTokenizer.nextToken(), object, throwable);
            }
            catch (SendMailFailedException sendMailFailedException) {
                Logger.getAnonymousLogger().warning(sendMailFailedException.getMessage());
            }
        }
    }

    private void sendMail(String string, Object object, Throwable throwable) throws SendMailFailedException {
        Object object2;
        if (this.mailSession == null) {
            object2 = new Properties();
            ((Properties)object2).put("mail.smtp.host", this.hostname);
            this.mailSession = Session.getDefaultInstance((Properties)object2, null);
        }
        object2 = "nobody@locahost";
        MimeMessage mimeMessage = new MimeMessage(this.mailSession);
        try {
            mimeMessage.setFrom((Address)new InternetAddress((String)object2));
            InternetAddress[] internetAddressArray = new InternetAddress[]{new InternetAddress(string)};
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
            mimeMessage.setSubject("Failure report");
            mimeMessage.setSentDate(new Date());
            mimeMessage.setText(this.createFailureMessage(throwable));
            Transport.send((Message)mimeMessage);
        }
        catch (AddressException addressException) {
            throw new SendMailFailedException(addressException);
        }
        catch (MessagingException messagingException) {
            throw new SendMailFailedException(messagingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createFailureMessage(Throwable throwable) {
        String string;
        if (this.mailTemplateURL == null) {
            return "Subject: Watchdog alarm\r\nFrom: watchdog@localhost\r\n\r\nAutomatic failure alarm\r\n\r\n" + throwable.getMessage();
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                int n;
                bufferedReader = new BufferedReader(new InputStreamReader(this.mailTemplateURL.openStream()));
                StringWriter stringWriter = new StringWriter();
                while ((n = bufferedReader.read()) != -1) {
                    stringWriter.write(n);
                }
                string = stringWriter.toString();
                Object var7_8 = null;
                if (bufferedReader == null) return string;
            }
            catch (IOException iOException) {
                String string2 = "Subject: Watchdog alarm\r\nFrom: watchdog@localhost\r\n\r\nAutomatic failure alarm\r\n\r\n" + throwable.getMessage() + "\r\n\r\nPlease note: (Mail template failed to load for " + iOException.getMessage() + ").";
                Object var7_9 = null;
                if (bufferedReader == null) return string2;
                try {
                    bufferedReader.close();
                    return string2;
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
                return string2;
            }
        }
        catch (Throwable throwable2) {
            Object var7_10 = null;
            if (bufferedReader == null) throw throwable2;
            try {}
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                throw throwable2;
            }
            bufferedReader.close();
            throw throwable2;
        }
        try {}
        catch (IOException iOException) {
            iOException.printStackTrace();
            return string;
        }
        bufferedReader.close();
        return string;
    }

    public String getMailTemplateURL() {
        return this.mailTemplateURL.toString();
    }

    public void setMailTemplateURL(String string) throws MalformedURLException {
        this.mailTemplateURL = new URL(string);
    }

    public String getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String string) {
        this.emailAddresses = string;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }
}

