/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.watchdog;

import com.deltax.util.TimeInterval;
import com.deltax.util.listener.IListenerSupport;
import com.deltax.util.listener.ListenerSupport;
import com.deltax.util.listener.Signal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sadun.util.Terminable;
import org.sadun.util.watchdog.WatchDogException;

public abstract class WatchDog
extends Thread
implements Terminable {
    private volatile boolean shutdown;
    private long checkPeriodTime;
    Set listeners = new HashSet();
    IListenerSupport ls = this.createListenerSupport();
    private boolean startBySleeping = false;
    private boolean firstCycle = false;
    public static final long DEFAULT_SLEEP_TIME = 300000L;
    private boolean synchronous;
    private boolean removeFailedListeners = true;
    static /* synthetic */ Class class$org$sadun$util$watchdog$WatchDog;

    protected WatchDog(String string, long l) {
        this(string, l, false);
    }

    protected WatchDog(String string, long l, boolean bl) {
        super(string);
        this.checkPeriodTime = l;
        this.synchronous = bl;
        this.setDaemon(true);
    }

    protected WatchDog(String string) {
        this(string, WatchDog.getDefaultSleepTime());
    }

    protected WatchDog() {
        this("");
        this.setName(this.getClass().getName());
    }

    private IListenerSupport createListenerSupport() {
        return new ListenerSupport();
    }

    private static long getDefaultSleepTime() {
        long l = 300000L;
        String string = System.getProperty("org.sadun.pool.connection.watchdog.sleeptime");
        if (string != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Warning: value of property org.sadun.pool.connection.watchdog.sleeptime must be a number, \"" + string + "\" ignored, using " + new TimeInterval(l));
            }
        }
        return l;
    }

    public void run() {
        this.shutdown = false;
        this.firstCycle = true;
        while (!this.shutdown) {
            try {
                if (this.firstCycle) {
                    if (this.startBySleeping) {
                        Thread.sleep(this.checkPeriodTime);
                    }
                    this.firstCycle = false;
                } else {
                    Thread.sleep(this.checkPeriodTime);
                }
                Object object = this.getObjectToCheck();
                try {
                    Throwable throwable = this.doCheck(object);
                    this.notify(object, throwable);
                }
                catch (WatchDogException watchDogException) {
                    this.notify(object, watchDogException);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected Object getObjectToCheck() {
        return null;
    }

    void notify(Object object, Throwable throwable) {
        if (this.synchronous) {
            this.notifySynchronous(object, throwable);
        } else {
            this.notifyAsynchronous(object, throwable);
        }
    }

    void notifySynchronous(Object object, Throwable throwable) {
        Listener listener;
        HashSet<Listener> hashSet = new HashSet<Listener>();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            listener = (Listener)iterator.next();
            try {
                if (throwable == null) {
                    listener.checkOk(object);
                    continue;
                }
                if (throwable instanceof WatchDogException) {
                    listener.checkImpossible(object, (WatchDogException)throwable);
                    continue;
                }
                listener.checkFailed(object, throwable);
            }
            catch (Throwable throwable2) {
                System.err.println("Warning: the listener " + listener.toString() + " has generated a " + throwable2 + (this.removeFailedListeners ? " and is removed from the listeners set" : ""));
                if (!this.removeFailedListeners) continue;
                hashSet.add(listener);
            }
        }
        if (hashSet.size() > 0 && this.removeFailedListeners) {
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                listener = (Listener)iterator.next();
                this.removeListener(listener);
            }
        }
    }

    void notifyAsynchronous(Object object, Throwable throwable) {
        if (throwable == null) {
            this.ls.notify(new WatchDogSignal(object, 0, throwable));
        } else if (throwable instanceof WatchDogException) {
            this.ls.notify(new WatchDogSignal(object, 2, throwable));
        } else {
            this.ls.notify(new WatchDogSignal(object, 1, throwable));
        }
    }

    protected abstract Throwable doCheck(Object var1) throws WatchDogException;

    public boolean isShuttingDown() {
        return this.shutdown;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        Object object = this.ls;
        synchronized (object) {
            this.ls.addListener(new ListenerWrapper(listener));
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        Object object = this.ls;
        synchronized (object) {
            this.ls.removeListener(new ListenerWrapper(listener));
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeaAllListeners() {
        Object object = this.ls;
        synchronized (object) {
            this.ls.removeAllListeners();
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    public long getCheckPeriodTime() {
        return this.checkPeriodTime;
    }

    public void setCheckPeriodTime(long l) {
        this.checkPeriodTime = l;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean bl) {
        if (this.isAlive()) {
            throw new IllegalStateException("The watchdog is already running");
        }
        this.synchronous = bl;
    }

    public boolean isStartBySleeping() {
        return this.startBySleeping;
    }

    public void setStartBySleeping(boolean bl) {
        if (this.isAlive()) {
            throw new IllegalStateException("The watchdog is already running");
        }
        this.startBySleeping = bl;
    }

    public boolean isRemoveFailedListeners() {
        return this.removeFailedListeners;
    }

    public void setRemoveFailedListeners(boolean bl) {
        this.removeFailedListeners = bl;
    }

    public void dispose() {
    }

    public void finalize() {
        this.dispose();
    }

    public static abstract class BaseListener
    implements Listener {
        public void checkOk(Object object) {
        }

        public abstract void checkFailed(Object var1, Throwable var2);

        public void checkImpossible(Object object, WatchDogException watchDogException) {
            this.checkFailed(object, watchDogException);
        }
    }

    private class ListenerWrapper
    implements com.deltax.util.listener.Listener {
        private Listener originalListener;
        static final /* synthetic */ boolean $assertionsDisabled;

        ListenerWrapper(Listener listener) {
            if (!$assertionsDisabled && listener == null) {
                throw new AssertionError();
            }
            this.originalListener = listener;
        }

        public void receive(Signal signal) {
            WatchDogSignal watchDogSignal = (WatchDogSignal)signal;
            watchDogSignal.dispatch(this.originalListener);
        }

        public boolean equals(Object object) {
            if (object instanceof ListenerWrapper) {
                return this.originalListener.equals(((ListenerWrapper)object).originalListener);
            }
            return false;
        }

        public int hashCode() {
            return this.originalListener.hashCode();
        }

        static {
            $assertionsDisabled = !(class$org$sadun$util$watchdog$WatchDog == null ? (class$org$sadun$util$watchdog$WatchDog = WatchDog.class$("org.sadun.util.watchdog.WatchDog")) : class$org$sadun$util$watchdog$WatchDog).desiredAssertionStatus();
        }
    }

    private class WatchDogSignal
    extends Signal {
        static final int SIGNAL_CHECK_OK = 0;
        static final int SIGNAL_CHECK_FAILED = 1;
        static final int SIGNAL_CHECK_IMPOSSIBLE = 2;
        Object param;
        private int type;
        private Throwable throwable;
        static final /* synthetic */ boolean $assertionsDisabled;

        WatchDogSignal(Object object, int n, Throwable throwable) {
            super(WatchDog.this);
            this.param = object;
            this.type = n;
            this.throwable = throwable;
        }

        boolean isOk() {
            return this.type == 0;
        }

        boolean isImpossible() {
            return this.type == 2;
        }

        boolean isFailed() {
            return this.type == 1;
        }

        public WatchDogException getImpossibilityCause() {
            if (!($assertionsDisabled || this.isImpossible() && this.throwable != null)) {
                throw new AssertionError();
            }
            return (WatchDogException)this.throwable;
        }

        public Throwable getFailureCause() {
            if (!($assertionsDisabled || this.isFailed() && this.throwable != null)) {
                throw new AssertionError();
            }
            return this.throwable;
        }

        public void dispatch(Listener listener) {
            if (this.isOk()) {
                listener.checkOk(this.param);
            } else if (this.isFailed()) {
                listener.checkFailed(this.param, this.getFailureCause());
            } else {
                listener.checkImpossible(this.param, this.getImpossibilityCause());
            }
        }

        static {
            $assertionsDisabled = !(class$org$sadun$util$watchdog$WatchDog == null ? (class$org$sadun$util$watchdog$WatchDog = WatchDog.class$("org.sadun.util.watchdog.WatchDog")) : class$org$sadun$util$watchdog$WatchDog).desiredAssertionStatus();
        }
    }

    public static interface Listener {
        public void checkOk(Object var1);

        public void checkFailed(Object var1, Throwable var2);

        public void checkImpossible(Object var1, WatchDogException var2);
    }
}

