/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.watchdog;

import com.deltax.util.TimeInterval;
import java.util.Random;
import org.sadun.util.watchdog.WatchDog;
import org.sadun.util.watchdog.WatchDogException;

public class Test {
    public static void main(String[] stringArray) {
        final Random random = new Random();
        WatchDog watchDog = new WatchDog("test", 1000L){

            public Throwable doCheck(Object object) throws WatchDogException {
                try {
                    long l = (1 + random.nextInt(100)) * 50;
                    System.out.println("Sleeping for " + new TimeInterval(l));
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    throw new WatchDogException("Interrupted");
                }
                switch (random.nextInt(3)) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return new Throwable("A simulated problem has occurred");
                    }
                }
                return new WatchDogException("A simulated check impossibility has occurred");
            }
        };
        WatchDog.Listener listener = new WatchDog.Listener(){

            public void checkFailed(Object object, Throwable throwable) {
                System.out.println("Check failed (param=" + object + ")");
                throwable.printStackTrace(System.out);
                if (random.nextBoolean()) {
                    long l = 10000 + random.nextInt(10) * 500;
                    System.out.println("LISTENER BLOCKED FOR " + new TimeInterval(l) + "!");
                    try {
                        Thread.sleep(l);
                        System.out.println("LISTENER UNBLOCKED");
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        System.out.println("LISTENER UNBLOCKED BY INTERRUPTION");
                    }
                }
            }

            public void checkOk(Object object) {
                System.out.println("Check ok (param=" + object + ")");
            }

            public void checkImpossible(Object object, WatchDogException watchDogException) {
                System.err.println("Check impossible (param=" + object + ")");
                watchDogException.printStackTrace(System.err);
            }
        };
        watchDog.addListener(listener);
        watchDog.setDaemon(false);
        watchDog.start();
    }
}

