/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.sadun.util.JustifierWriter;
import org.sadun.util.TieWriter;

public class JustifyWriterTestCase
extends TestCase {
    private StringWriter sw;
    private JustifierWriter writer;
    private PrintWriter printWriter;
    private int lineSepLength = System.getProperty("line.separator").length();
    private static final int TEST_LINE_LENGTH = 20;

    protected void setUp() throws Exception {
        this.sw = new StringWriter();
        this.writer = new JustifierWriter(new TieWriter(this.sw, new OutputStreamWriter(System.out)), 20);
        this.printWriter = new PrintWriter(this.writer);
        this.writer.setAutoFlush(true);
        System.out.println();
        for (int i = 0; i < 20; ++i) {
            System.out.print(i % 10);
        }
        System.out.println();
    }

    public void testWordLongerThanLine() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 21; ++i) {
            stringBuffer.append((char)(97 + i % 10));
        }
        String string = stringBuffer.toString();
        this.printWriter.println(string);
        this.printWriter.flush();
        JustifyWriterTestCase.assertEquals((int)(20 + 2 * this.lineSepLength + 1), (int)this.sw.toString().length());
    }

    public void testTwoWords() {
        this.writer.setJustifyOnNewLine(true);
        this.printWriter.println("Hello world!");
        this.printWriter.flush();
        JustifyWriterTestCase.assertEquals((int)(20 + this.lineSepLength), (int)this.sw.toString().length());
    }

    public void testParagraph() throws IOException {
        String string = "Hello darkness my old friend, I've come to talk to you again; because a vision softly creeping, left its seeds while I was sleeping";
        this.writer.setJustifyOnNewLine(true);
        this.writer.setPadOnNewLine(true);
        this.printWriter.println(string);
        this.printWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.sw.toString()));
        String string2 = null;
        do {
            if ((string2 = bufferedReader.readLine()) == null) continue;
            JustifyWriterTestCase.assertEquals((int)20, (int)string2.length());
        } while (string2 != null);
    }

    public void testJustification() {
        System.out.println();
        String string = "Hello world!";
        string = JustifierWriter.justify(string, 20, true).toString();
        System.out.println(string);
        JustifyWriterTestCase.assertEquals((int)20, (int)string.length());
    }

    public void testSingleWord() {
        String string = "Hello!";
        this.printWriter.println(string);
        this.printWriter.flush();
        JustifyWriterTestCase.assertEquals((int)(string.length() + this.lineSepLength), (int)this.sw.toString().length());
    }

    public void testPreserveSpace() {
        this.writer.setJustifyOnNewLine(true);
        this.writer.setPreserveInitialSpaces(true);
        this.printWriter.println("   Hello world!");
        this.printWriter.flush();
        JustifyWriterTestCase.assertTrue((boolean)this.sw.toString().startsWith("   "));
        JustifyWriterTestCase.assertEquals((int)(20 + this.lineSepLength), (int)this.sw.toString().length());
    }
}

