/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool2;

import com.deltax.util.SignatureAnalyzer;
import com.sun.tools.javac.Main;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.sadun.util.IndentedPrintWriter;
import org.sadun.util.codegen.VariableNameGenerator;
import org.sadun.util.pool2.BasePooledObject;
import org.sadun.util.pool2.PooledObject;

class StubGenerator {
    private static String lineSep = System.getProperty("line.separator");
    private File codeDir;
    private PrintStream logStream;
    private String classPath;
    private Class clsToExtend;
    static /* synthetic */ Class class$java$lang$Object;

    public StubGenerator(Class clazz) throws IOException {
        this(clazz, new File(File.separator + "temp"));
    }

    public StubGenerator(Class clazz, File file) throws IOException {
        this(clazz, file, System.getProperty("java.class.path"));
    }

    public StubGenerator(Class clazz, File file, String string) throws IOException {
        this.codeDir = file;
        this.classPath = string;
        this.clsToExtend = clazz;
        if (!PooledObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The given base class " + clazz.getName() + " does not implement the PooledObject interface");
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot create directory " + file);
        }
    }

    public String generateCode(Class clazz, StringWriter stringWriter) {
        Method[] methodArray;
        if (this.logStream != null) {
            this.logStream.println("Generating code..");
        }
        HashSet hashSet = new HashSet();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            hashSet.add(classArray[i]);
        }
        StringWriter stringWriter2 = new StringWriter();
        IndentedPrintWriter indentedPrintWriter = new IndentedPrintWriter(stringWriter2);
        indentedPrintWriter.print("package ");
        indentedPrintWriter.print(clazz.getPackage().getName());
        indentedPrintWriter.println(";");
        indentedPrintWriter.println();
        indentedPrintWriter.println("import org.sadun.util.pool2.ActivationException;");
        indentedPrintWriter.println();
        indentedPrintWriter.print("public class ");
        stringWriter.write("Pooled");
        stringWriter.write(this.getUnqualifedName(clazz));
        indentedPrintWriter.print(stringWriter.toString());
        indentedPrintWriter.print(" extends " + BasePooledObject.class.getName());
        if (hashSet.size() != 0) {
            indentedPrintWriter.print(" implements ");
            methodArray = hashSet.iterator();
            while (methodArray.hasNext()) {
                Class clazz2 = (Class)methodArray.next();
                indentedPrintWriter.print(clazz2.getName());
                if (!methodArray.hasNext()) continue;
                indentedPrintWriter.print(", ");
            }
        }
        indentedPrintWriter.println(" {");
        indentedPrintWriter.println();
        indentedPrintWriter.incIndentation(3);
        indentedPrintWriter.print("public ");
        indentedPrintWriter.print(stringWriter.toString());
        indentedPrintWriter.print("(org.sadun.util.pool2.ObjectPool objectPool, ");
        indentedPrintWriter.print(clazz.getName());
        indentedPrintWriter.println(" obj) {");
        indentedPrintWriter.println("   super(objectPool, obj);");
        indentedPrintWriter.println("}");
        indentedPrintWriter.println();
        methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? StubGenerator.class$("java.lang.Object") : class$java$lang$Object)) continue;
            int n = method.getModifiers();
            if (Modifier.isPublic(n)) {
                indentedPrintWriter.print("public ");
            } else if (Modifier.isPrivate(n)) {
                indentedPrintWriter.print("private ");
            } else if (Modifier.isProtected(n)) {
                indentedPrintWriter.print("protected ");
            }
            if (Modifier.isStatic(n)) {
                indentedPrintWriter.print("static ");
            }
            if (Modifier.isFinal(n)) {
                indentedPrintWriter.print("final ");
            }
            if (Modifier.isStrict(n)) {
                indentedPrintWriter.print("strictfp ");
            }
            indentedPrintWriter.print(SignatureAnalyzer.getJavaTypeName(method.getReturnType()));
            indentedPrintWriter.print(" ");
            indentedPrintWriter.print(method.getName());
            indentedPrintWriter.print("(");
            Class<?>[] classArray2 = method.getParameterTypes();
            VariableNameGenerator variableNameGenerator = new VariableNameGenerator();
            String[][] stringArray = new String[classArray2.length][2];
            for (int j = 0; j < classArray2.length; ++j) {
                String string = SignatureAnalyzer.getJavaTypeName(classArray2[j]);
                stringArray[j][0] = string;
                indentedPrintWriter.print(string);
                indentedPrintWriter.print(" ");
                String string2 = variableNameGenerator.generateNext(method.getName(), classArray2[j]);
                stringArray[j][1] = string2;
                indentedPrintWriter.print(string2);
                if (j >= classArray2.length - 1) continue;
                indentedPrintWriter.print(", ");
            }
            indentedPrintWriter.print(") ");
            Class<?>[] classArray3 = method.getExceptionTypes();
            if (classArray3.length > 0) {
                indentedPrintWriter.print("throws ");
                for (int j = 0; j < classArray3.length; ++j) {
                    indentedPrintWriter.print(classArray3[j].getName());
                    if (j >= classArray3.length - 1) continue;
                    indentedPrintWriter.print(", ");
                }
                indentedPrintWriter.print(" ");
            }
            indentedPrintWriter.println("{");
            this.addMethodBody(indentedPrintWriter, stringArray, clazz, method);
            indentedPrintWriter.println("}");
            indentedPrintWriter.println();
        }
        indentedPrintWriter.decIndentation(3);
        indentedPrintWriter.print("}");
        return stringWriter2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateStub(Class clazz) throws IOException {
        Object object;
        int n;
        StringWriter stringWriter = new StringWriter();
        StringReader stringReader = new StringReader(this.generateCode(clazz, stringWriter));
        File file = this.getFileForClassSource(clazz.getPackage(), stringWriter.toString());
        if (this.logStream != null) {
            this.logStream.println("Writing " + file.getAbsolutePath() + "..");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        while ((n = stringReader.read()) != -1) {
            bufferedWriter.write(n);
        }
        bufferedWriter.close();
        File file2 = this.getFileForCompiledClass(clazz.getPackage(), stringWriter.toString());
        if (file2.exists()) {
            if (this.logStream != null) {
                this.logStream.println("Deleting existing " + file2.getAbsolutePath() + "..");
            }
            if (!file2.delete()) {
                throw new IOException("Cannot delete existing class file " + file2);
            }
        }
        String[] stringArray = new String[5];
        stringArray[0] = "-classpath";
        stringArray[1] = this.codeDir.getCanonicalPath();
        if (this.classPath != null) {
            stringArray[1] = stringArray[1] + ";" + this.classPath;
        }
        stringArray[2] = "-d";
        stringArray[3] = this.codeDir.getCanonicalPath();
        stringArray[4] = file.getAbsolutePath();
        if (this.logStream != null) {
            object = this.logStream;
            synchronized (object) {
                this.logStream.print("Invoking javac ");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.logStream.print(stringArray[i]);
                    if (i >= stringArray.length - 1) continue;
                    this.logStream.print(" ");
                }
                this.logStream.println();
            }
        }
        object = new Main();
        Main.compile(stringArray);
        if (this.logStream != null) {
            this.logStream.println("Reading " + file2.getAbsolutePath());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        while ((n = bufferedInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        bufferedInputStream.close();
        if (this.logStream != null) {
            this.logStream.println("Class bytecode for " + stringWriter.toString() + " generated");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private File getFileForClassSource(Package package_, String string) throws IOException {
        return this.getFileForClass0(package_, string, "java");
    }

    private File getFileForCompiledClass(Package package_, String string) throws IOException {
        return this.getFileForClass0(package_, string, "class");
    }

    private File getFileForClass0(Package package_, String string, String string2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        StringTokenizer stringTokenizer = new StringTokenizer(package_.getName(), ".");
        while (stringTokenizer.hasMoreTokens()) {
            stringWriter.write(stringTokenizer.nextToken());
            stringWriter.write(File.separator);
        }
        File file = new File(this.codeDir, stringWriter.toString());
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot create directory " + file.getAbsolutePath());
        }
        stringWriter.write(string);
        File file2 = new File(this.codeDir, stringWriter.toString() + "." + string2);
        return file2;
    }

    private void addMethodBody(IndentedPrintWriter indentedPrintWriter, String[][] stringArray, Class clazz, Method method) {
        indentedPrintWriter.incIndentation(3);
        if (!Modifier.isStatic(method.getModifiers())) {
            indentedPrintWriter.println("_getOriginal();");
            if (method.getReturnType() != Void.TYPE) {
                this.printResultVariable(method.getReturnType(), indentedPrintWriter);
            }
            indentedPrintWriter.print("((");
            indentedPrintWriter.print(clazz.getName());
            indentedPrintWriter.print(")");
            indentedPrintWriter.print("getOriginal()).");
        } else {
            if (method.getReturnType() != Void.TYPE) {
                this.printResultVariable(method.getReturnType(), indentedPrintWriter);
            }
            indentedPrintWriter.print(clazz.getName());
            indentedPrintWriter.print(".");
        }
        indentedPrintWriter.print(method.getName());
        indentedPrintWriter.print("(");
        for (int i = 0; i < stringArray.length; ++i) {
            indentedPrintWriter.print(stringArray[i][1]);
            if (i >= stringArray.length - 1) continue;
            indentedPrintWriter.print(",");
        }
        indentedPrintWriter.println(");");
        if (!Modifier.isStatic(method.getModifiers())) {
            indentedPrintWriter.println("_releaseOriginal();");
        }
        if (method.getReturnType() != Void.TYPE) {
            indentedPrintWriter.println("return res;");
        }
        indentedPrintWriter.decIndentation(3);
    }

    private void printResultVariable(Class clazz, IndentedPrintWriter indentedPrintWriter) {
        indentedPrintWriter.print(SignatureAnalyzer.getJavaTypeName(clazz));
        indentedPrintWriter.print(" res = ");
    }

    private String getUnqualifedName(Class clazz) {
        int n = clazz.getName().lastIndexOf(".");
        if (n == -1) {
            return clazz.getName();
        }
        return clazz.getName().substring(n + 1);
    }

    public PrintStream getLogStream() {
        return this.logStream;
    }

    public void setLogStream(PrintStream printStream) {
        this.logStream = printStream;
    }
}

