/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool2;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.sadun.util.pool2.BasePooledObject;
import org.sadun.util.pool2.StubGenerator;

class StubClassLoader
extends ClassLoader {
    private Map stubsMap = new HashMap();
    private StubGenerator sg;
    private PrintStream logStream;
    public boolean generateIfNotFound;

    public StubClassLoader(Class clazz) throws IOException {
        this(clazz, System.getProperty("org.sadun.util.pool2.StubClassLoader.generate") != null);
    }

    public StubClassLoader(Class clazz, boolean bl) throws IOException {
        this.sg = new StubGenerator(clazz);
        this.generateIfNotFound = bl;
    }

    public static String getPooledClassName(Class clazz) {
        return StubClassLoader.getPooledClassName(clazz.getName());
    }

    public static String getPooledClassName(String string) {
        int n = string.lastIndexOf(".");
        String string2 = n == -1 ? string : string.substring(0, n) + ".Pooled" + string.substring(n + 1);
        return string2;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        int n;
        String string2;
        if (!this.generateIfNotFound) {
            throw new ClassNotFoundException(string + " is not in class path. Please define the property \"org.sadun.util.pool2.StubClassLoader.generate\" if you want to auto-generate stub classes at runtime");
        }
        String string3 = StubClassLoader.getPooledClassName(string);
        Class<?> clazz = (Class<?>)this.stubsMap.get(string3);
        if (clazz != null) {
            if (this.logStream != null) {
                this.logStream.println("Bytecode for " + string3 + " already generated");
            }
            return clazz;
        }
        if (this.logStream != null) {
            this.logStream.println("Generating and loading bytecode for " + string3);
        }
        if (!(string2 = (n = string.lastIndexOf(".")) == -1 ? string : string.substring(n + 1)).startsWith("Pooled")) {
            throw new IllegalArgumentException("This ClassLoader can be only used to load pooled objects");
        }
        Object v = this.stubsMap.get(string2);
        if (v != null) {
            return (Class)v;
        }
        String string4 = string.substring(0, n) + "." + string2.substring(6);
        try {
            byte[] byArray = this.sg.generateStub(this.loadClass(string4));
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Could not generate stub", iOException);
        }
        this.stubsMap.put(string2, clazz);
        return clazz;
    }

    public static void main(String[] stringArray) throws Exception {
        new StubClassLoader(BasePooledObject.class).loadClass("org.sadun.util.pool2.PooledStubGenerator");
    }

    public PrintStream getLogStream() {
        return this.logStream;
    }

    public void setLogStream(PrintStream printStream) {
        this.logStream = printStream;
        this.sg.setLogStream(printStream);
    }
}

