/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool2;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.sadun.util.Setup;
import org.sadun.util.pool.ObjectPool;
import org.sadun.util.pool2.BasePassivationManager;
import org.sadun.util.pool2.BasePooledObject;
import org.sadun.util.pool2.Configuration;
import org.sadun.util.pool2.DefaultPassivationManager;
import org.sadun.util.pool2.PooledObject;
import org.sadun.util.pool2.StubClassLoader;
import org.sadun.util.pool2.test.ObjectWithID;
import org.sadun.util.pool2.test.PassivableObject;

public class ObjectPool
extends org.sadun.util.pool.ObjectPool {
    private String name;
    private PrintStream logStream;
    private static PrintStream defaultLogStream;
    private Configuration configuration;
    private BasePassivationManager passivationManager;
    static /* synthetic */ Class class$org$sadun$util$pool2$ObjectPool;
    static /* synthetic */ Class class$org$sadun$util$pool2$BasePooledObject;

    public ObjectPool(String string, Configuration configuration, Class clazz) throws ObjectPool.ObjectPoolException {
        this(string, configuration, clazz, (Setup)null);
    }

    public ObjectPool(String string, Configuration configuration, Class clazz, Setup setup) throws ObjectPool.ObjectPoolException {
        this(string, configuration, clazz, new Object[0], setup);
    }

    public ObjectPool(String string, Configuration configuration, Class clazz, Object[] objectArray) {
        this(string, configuration, clazz, objectArray, null);
    }

    public ObjectPool(String string, Configuration configuration, Class clazz, Object[] objectArray, Setup setup) throws ObjectPool.ObjectPoolException {
        this(string, configuration, new ObjectPool.ObjectFactory(clazz, objectArray, setup));
    }

    public ObjectPool(String string, int n, Class clazz, Object[] objectArray) {
        this(string, new Configuration(n), clazz, objectArray);
    }

    public ObjectPool(String string, int n, Class clazz) {
        this(string, new Configuration(n), clazz, new Object[0]);
    }

    public ObjectPool(String string, Configuration configuration, ObjectPool.Factory factory) throws ObjectPool.ObjectPoolException {
        super(configuration.getPoolSize(), new PooledObjectFactory(null, factory));
        this.setPool(this.createObjectsArray(), this);
        this.configuration = configuration;
        this.name = string;
        this.logStream = ObjectPool.getDefaultLogStream();
        this.passivationManager = configuration.getPassivationManagerFactory().createPassivationThread();
        this.passivationManager.setLogStream(this.logStream);
        this.passivationManager.addPool(this);
        if (this.logStream != null) {
            this.logStream.println("Pool of " + this.getSize() + " instances of " + factory.getProducedClass() + " created.");
        }
        this.passivationManager.start();
    }

    public static PrintStream getDefaultLogStream() {
        return defaultLogStream;
    }

    public static void setDefaultLogStream(PrintStream printStream) {
        defaultLogStream = printStream;
    }

    public PrintStream getLogStream() {
        return this.logStream;
    }

    public void setLogStream(PrintStream printStream) {
        this.logStream = printStream;
        PooledObjectFactory.scl.setLogStream(printStream);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    Object[] createObjectsArray() {
        Object[] objectArray = new Object[this.pool.length];
        for (int i = 0; i < this.pool.length; ++i) {
            objectArray[i] = this.pool[i].getObject();
        }
        return objectArray;
    }

    synchronized boolean isAcquired(PooledObject pooledObject) {
        return this.used.contains(pooledObject);
    }

    public PooledObject acquireInstance() {
        return (PooledObject)this.acquire();
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
        this.passivationManager.shutdown();
    }

    public BasePassivationManager getPassivationManager() {
        return this.passivationManager;
    }

    private void setPool(Object[] objectArray, ObjectPool objectPool) {
        for (int i = 0; i < objectArray.length; ++i) {
            ((BasePooledObject)objectArray[i]).setObjectPool(objectPool);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DefaultPassivationManager.setDefaultPassivationThreshold(1000L);
        ObjectPool objectPool = new ObjectPool("Test pool", new Configuration(new File(File.separator + "temp"), 10), PassivableObject.class);
        ObjectWithID objectWithID = (ObjectWithID)objectPool.acquire();
        System.out.println("Object ID: " + objectWithID.getId());
        objectPool.release(objectWithID);
        objectPool.dispose();
    }

    protected static class PooledObjectFactory
    implements ObjectPool.Factory {
        private Class pooledClass;
        private ObjectPool.Factory factory;
        private Constructor pooledClassConstructor;
        private ObjectPool pool;
        private static StubClassLoader scl;
        private static Object lock;

        protected PooledObjectFactory(ObjectPool objectPool, ObjectPool.Factory factory) throws ObjectPool.ObjectPoolException {
            this.factory = factory;
            this.pool = objectPool;
            PooledObjectFactory.createStubClassLoader();
            try {
                this.pooledClass = scl.loadClass(StubClassLoader.getPooledClassName(factory.getProducedClass()));
                try {
                    this.pooledClassConstructor = this.pooledClass.getConstructor(class$org$sadun$util$pool2$ObjectPool == null ? (class$org$sadun$util$pool2$ObjectPool = ObjectPool.class$("org.sadun.util.pool2.ObjectPool")) : class$org$sadun$util$pool2$ObjectPool, factory.getProducedClass());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException("Corrupted class " + this.pooledClass.getName(), noSuchMethodException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ObjectPool.ObjectPoolException("Could not generate/load the pooled class for " + factory.getProducedClass().getName(), classNotFoundException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void createStubClassLoader() throws ObjectPool.ObjectPoolException {
            if (scl == null) {
                Object object = lock;
                synchronized (object) {
                    Class clazz = class$org$sadun$util$pool2$BasePooledObject == null ? (class$org$sadun$util$pool2$BasePooledObject = ObjectPool.class$("org.sadun.util.pool2.BasePooledObject")) : class$org$sadun$util$pool2$BasePooledObject;
                    try {
                        scl = new StubClassLoader(clazz);
                        scl.setLogStream(ObjectPool.getDefaultLogStream());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        throw new IllegalStateException("Cannot create StubClassLoader using " + clazz.getName());
                    }
                }
            }
        }

        public Object create() throws ObjectPool.ObjectPoolException {
            try {
                BasePooledObject basePooledObject = (BasePooledObject)this.pooledClassConstructor.newInstance(null, this.factory.create());
                basePooledObject.setObjectPool(this.pool);
                return basePooledObject;
            }
            catch (InstantiationException instantiationException) {
                throw new ObjectPool.ObjectPoolException("Cannot instantiate pooled object for " + this.factory.getProducedClass().getName(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ObjectPool.ObjectPoolException("Cannot instantiate pooled object for " + this.factory.getProducedClass().getName(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ObjectPool.ObjectPoolException("Cannot instantiate pooled object for " + this.factory.getProducedClass().getName(), invocationTargetException);
            }
        }

        public Class getProducedClass() {
            return this.pooledClass;
        }

        public void destroy(Object object) throws ObjectPool.ObjectPoolException {
        }

        static {
            lock = new Object();
        }
    }

    public static final class DefaultPassivationManagerFactory
    extends PassivationManagerFactory {
        protected BasePassivationManager createPassivationThread() {
            return DefaultPassivationManager.getInstance();
        }
    }

    protected static abstract class PassivationManagerFactory {
        protected PassivationManagerFactory() {
        }

        protected abstract BasePassivationManager createPassivationThread();
    }
}

