/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool2;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sadun.util.Terminable;
import org.sadun.util.pool2.BasePooledObject;
import org.sadun.util.pool2.ObjectPool;
import org.sadun.util.pool2.PooledObject;

public abstract class BasePassivationManager
extends Thread
implements Terminable {
    private volatile boolean shutdown = false;
    private Iterator currentPool;
    protected PrintStream logStream;
    protected Set monitoredPools = new HashSet();
    protected int sleepTime;
    protected boolean rotatePools = false;
    protected int rotationRate = 1;

    protected BasePassivationManager(ObjectPool objectPool, String string, int n) {
        super(string);
        this.sleepTime = n;
        this.addPool(objectPool);
    }

    protected BasePassivationManager(String string, int n) {
        super(string);
        this.sleepTime = n;
    }

    protected BasePassivationManager(String string) {
        this(string, 3600);
    }

    public synchronized void addPool(ObjectPool objectPool) {
        this.monitoredPools.add(objectPool);
        Object[] objectArray = objectPool.createObjectsArray();
        if (objectArray.length > 0 && !this.canPassivate(((PooledObject)objectArray[0])._getOriginal().getClass()) && this.logStream != null) {
            this.logStream.println("Warning: class \"" + objectArray.getClass().getComponentType() + "\" is not passivable.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            PooledObject pooledObject = (PooledObject)objectArray[i];
            this.createState(objectPool, pooledObject);
        }
        if (this.logStream != null) {
            this.logStream.println("Pool \"" + objectPool.getName() + "\" managed by " + this.getName());
        }
    }

    public boolean canPassivate(Class clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    protected abstract void createState(ObjectPool var1, PooledObject var2);

    protected abstract void removeState(ObjectPool var1, PooledObject var2);

    public void removePool(ObjectPool objectPool) {
        this.monitoredPools.remove(objectPool);
    }

    public int countPools() {
        return this.monitoredPools.size();
    }

    public final void run() {
        if (this.logStream != null) {
            this.logStream.println(this.getName() + " started");
        }
        while (!this.shutdown) {
            this.doPassivationCheck();
            try {
                BasePassivationManager.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.logStream != null) {
            this.logStream.println(this.getName() + " terminated");
        }
    }

    private void doPassivationCheck() {
        if (this.rotatePools) {
            for (int i = 0; i < this.rotationRate; ++i) {
                if (this.currentPool == null) {
                    this.currentPool = this.monitoredPools.iterator();
                } else if (!this.currentPool.hasNext()) {
                    this.currentPool = this.monitoredPools.iterator();
                }
                ObjectPool objectPool = (ObjectPool)this.currentPool.next();
                this.doPassivationCheck(objectPool);
            }
        } else {
            this.currentPool = this.monitoredPools.iterator();
            while (this.currentPool.hasNext()) {
                ObjectPool objectPool = (ObjectPool)this.currentPool.next();
                this.doPassivationCheck(objectPool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPassivationCheck(ObjectPool objectPool) {
        if (this.logStream != null) {
            this.logStream.println(this.getName() + " checking \"" + objectPool.getName() + "\"");
        }
        ObjectPool objectPool2 = objectPool;
        synchronized (objectPool2) {
            Object object = this.prepareForPassivationCheck(objectPool);
            Object[] objectArray = objectPool.createObjectsArray();
            for (int i = 0; i < objectArray.length; ++i) {
                BasePooledObject basePooledObject = (BasePooledObject)objectArray[i];
                if (!basePooledObject._isPassivableNow() || !this.isToPassivate(objectPool, basePooledObject, object)) continue;
                basePooledObject._passivate();
            }
        }
    }

    protected abstract Object prepareForPassivationCheck(ObjectPool var1);

    protected abstract boolean isToPassivate(ObjectPool var1, PooledObject var2, Object var3);

    void invoked(ObjectPool objectPool, PooledObject pooledObject) {
        this.handleInvoked(objectPool, pooledObject);
    }

    void acquired(ObjectPool objectPool, PooledObject pooledObject) {
        this.handleAcquired(objectPool, pooledObject);
    }

    void released(ObjectPool objectPool, PooledObject pooledObject) {
        this.handleReleased(objectPool, pooledObject);
    }

    protected abstract void handleInvoked(ObjectPool var1, PooledObject var2);

    protected abstract void handleAcquired(ObjectPool var1, PooledObject var2);

    protected abstract void handleReleased(ObjectPool var1, PooledObject var2);

    public boolean isShuttingDown() {
        return this.shutdown;
    }

    public void shutdown() {
        if (this.logStream != null) {
            this.logStream.println("shutting down " + this.getName());
        }
        this.shutdown = true;
        this.interrupt();
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int n) {
        this.sleepTime = n;
    }

    public boolean isRotatePools() {
        return this.rotatePools;
    }

    public void setRotatePools(boolean bl) {
        this.rotatePools = bl;
    }

    public int getRotationRate() {
        return this.rotationRate;
    }

    public void setRotationRate(int n) {
        this.rotationRate = n;
    }

    public void setLogStream(PrintStream printStream) {
        this.logStream = printStream;
    }
}

