/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool.test;

import java.util.Random;
import org.sadun.util.pool.ObjectPool;

public class ObjectPoolTest {
    ObjectPool pool;
    Random random = new Random();
    Thread[] threads = new Thread[2];

    public ObjectPoolTest() throws Exception {
        this.pool = ObjectPool.newPool(1, "java.lang.Object", new Object[0]);
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new TestThread(i);
        }
    }

    public void run() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ObjectPoolTest objectPoolTest = new ObjectPoolTest();
        objectPoolTest.run();
    }

    class TestThread
    extends Thread {
        private int tn;

        TestThread(int n) {
            super("" + n);
            this.tn = n;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        System.out.println(this + " acquiring object");
                        System.out.flush();
                        Object object = ObjectPoolTest.this.pool.acquire();
                        System.out.println(this + " - object " + object + " acquired");
                        int n = ObjectPoolTest.this.random.nextInt(100);
                        System.out.println(this + " sleeping for " + n + "ms");
                        Thread.sleep(n);
                        if (ObjectPoolTest.this.random.nextBoolean()) {
                            System.out.println(this + " renewing object " + object);
                            object = ObjectPoolTest.this.pool.renew(object);
                        }
                        System.out.println(this + " releasing object " + object);
                        ObjectPoolTest.this.pool.release(object);
                        System.out.println(this + " - object " + object + " released");
                        System.out.println(ObjectPoolTest.this.pool);
                        n = ObjectPoolTest.this.random.nextInt(100);
                        System.out.println(this + " sleeping for " + n + "ms");
                        Thread.sleep(n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

