/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool.connection;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import org.sadun.util.ObjectLister;
import org.sadun.util.pool.ObjectPool;
import org.sadun.util.pool.connection.ConfigurableDataSource;
import org.sadun.util.pool.connection.ConnectionPool;
import org.sadun.util.watchdog.WatchDog;

public class Test
extends Thread {
    private volatile boolean shutdown;
    private ConnectionPool pool;

    public static void main(String[] stringArray) throws ClassNotFoundException, SQLException, FileNotFoundException {
        int n;
        System.out.println("STARTING");
        Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><java version=\"1.4.1_03\" class=\"java.beans.XMLDecoder\"> <object class=\"org.sadun.util.pool.connection.ConfigurableDataSource\">  <void property=\"connectionProperties\">    <object class=\"java.util.Properties\"/>   </void>   <void property=\"jdbcUrl\">   <string>jdbc:microsoft:sqlserver://localhost:1433;User=sa;Password=;DatabaseName=ipm</string>  </void>  </object> </java>";
        System.out.println("CREATING CONNECTION POOL");
        ConnectionPool connectionPool = new ConnectionPool(10, new ConfigurableDataSource(new ByteArrayInputStream(string.getBytes())));
        connectionPool.addListener(new WatchDog.BaseListener(){

            public void checkFailed(Object object, Throwable throwable) {
                System.err.println("Connection pool failure detected: " + throwable.getMessage());
            }
        });
        connectionPool.setWatchDogCheckPeriodTime(10L);
        connectionPool.setWatchDogEnabled(true);
        Test[] testArray = new Test[10];
        System.out.println("CREATING TEST THREADS");
        for (n = 0; n < testArray.length; ++n) {
            testArray[n] = new Test(connectionPool);
        }
        System.out.println("STARTING TEST THREADS");
        for (n = 0; n < testArray.length; ++n) {
            testArray[n].start();
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        System.out.println("TERMINATING TEST THREADS");
        for (int i = 0; i < testArray.length; ++i) {
            testArray[i].shutdown();
        }
        System.out.println("DESTROYING POOL");
        connectionPool.destroy(true);
    }

    public Test(ConnectionPool connectionPool) {
        this.pool = connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.shutdown = false;
        Random random = new Random();
        do {
            long l = 100 * random.nextInt(10) + 1;
            try {
                Test.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                if (this.shutdown) break;
                interruptedException.printStackTrace();
            }
            Connection connection = null;
            try {
                connection = this.pool.getConnection();
            }
            catch (ObjectPool.ObjectPoolException objectPoolException) {
                if (this.shutdown) {
                    System.out.println(objectPoolException.getMessage());
                    break;
                }
                objectPoolException.printStackTrace();
            }
            String string = "select id, role from roles";
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(2));
                }
                String string2 = this.getName() + ": " + ObjectLister.getInstance().list(arrayList);
                System.out.println(string2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(System.err);
            }
            finally {
                this.pool.releaseConnection(connection);
            }
        } while (!this.shutdown);
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }
}

