/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool.connection;

import java.sql.Connection;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.sadun.util.ObjectLister;
import org.sadun.util.pool.ObjectPool;
import org.sadun.util.pool.connection.ConnectionPool;
import org.sadun.util.pool.connection.ManagedConnectionPoolMBean;
import org.sadun.util.watchdog.WatchDog;
import org.sadun.util.watchdog.WatchDogException;

public class ManagedConnectionPool
implements ManagedConnectionPoolMBean,
WatchDog.Listener {
    private ConnectionPool pool;
    private int size = 1;
    private String jdbcURL = "";
    private String connectionProperties = "";
    private String jdbcDrivers = "";
    private String currentState = "Watchdog not enabled";
    private ObjectName objectName;
    private static final boolean debug = true;

    private static ObjectPool.Factory createFactory(String string) throws MBeanException {
        System.out.println("[ManagedConnectionPool] Creating factory " + string);
        try {
            Object obj = Class.forName(string).newInstance();
            if (!(obj instanceof ObjectPool.Factory)) {
                throw new MBeanException(new IllegalArgumentException("FactoryClassName must be the name of a class implementing the ObjectPool.Factory interface"));
            }
            return (ObjectPool.Factory)obj;
        }
        catch (InstantiationException instantiationException) {
            throw new MBeanException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MBeanException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MBeanException(classNotFoundException);
        }
    }

    public void setSize(int n) throws MBeanException {
        System.out.println("[ManagedConnectionPool] Setting size to " + n);
        if (n == this.getSize()) {
            return;
        }
        this.checkPoolStateForReset();
        int n2 = this.size;
        this.size = n;
        this.pool = this.createPool(this.jdbcURL, this.connectionProperties, n2);
    }

    public void setJdbcURL(String string) throws MBeanException {
        System.out.println("[ManagedConnectionPool] Setting JDBC url to " + string);
        this.checkPoolStateForReset();
        String string2 = this.jdbcURL;
        this.jdbcURL = string;
        this.pool = this.createPool(string2, this.connectionProperties, this.size);
    }

    public void setConnectionProperties(String string) throws MBeanException {
        System.out.println("[ManagedConnectionPool] Setting connection properties to " + string);
        this.checkPoolStateForReset();
        String string2 = string;
        this.connectionProperties = string;
        this.pool = this.createPool(this.jdbcURL, string2, this.size);
    }

    public void setJdbcDrivers(String string) throws MBeanException {
        System.out.println("[ManagedConnectionPool] Loading drivers " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":,; ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MBeanException(classNotFoundException, "Could not find JDBC driver class " + string2);
            }
        }
        this.jdbcDrivers = string;
        this.pool = this.createPool(this.jdbcURL, this.connectionProperties, this.size);
    }

    private void checkPoolStateForReset() throws MBeanException {
        if (this.pool != null && this.pool.getFreeCount() != this.pool.getSize()) {
            throw new MBeanException(new IllegalStateException("Cannot reset the pool when there are " + this.getUsedCount() + " used objects"));
        }
    }

    public int getFreeCount() {
        if (this.pool == null) {
            this.pool = this.createPool(this.jdbcURL, this.connectionProperties, this.size);
        }
        return this.pool.getFreeCount();
    }

    public Class getObjectType() {
        return Connection.class;
    }

    public int getSize() {
        return this.size;
    }

    public int getUsedCount() {
        if (this.pool == null) {
            this.pool = this.createPool(this.jdbcURL, this.connectionProperties, this.size);
        }
        return this.pool.getUsedCount();
    }

    private ConnectionPool createPool(String string, String string2, int n) {
        System.out.println("[ManagedConnectionPool] Creating pool of " + this.size + " connections to " + this.jdbcURL + " with properties " + ObjectLister.getInstance().list(ManagedConnectionPool.makeProperties(this.connectionProperties)));
        try {
            return new ConnectionPool(this.size, this.jdbcURL, ManagedConnectionPool.makeProperties(this.connectionProperties));
        }
        catch (RuntimeException runtimeException) {
            this.jdbcURL = string;
            this.connectionProperties = string2;
            this.size = n;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties makeProperties(String string) {
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        Properties properties = new Properties();
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c != '\u0000') {
                    if (c2 == '\\') {
                        if (i >= string.length() - 1) throw new RuntimeException("Illegal trailing \\ in properties specification");
                        char c3 = string.charAt(i + 1);
                        if (c3 == '\"' || c3 == '\'') {
                            stringBuffer.append(c3);
                            ++i;
                            continue;
                        }
                    } else if (c2 == c) {
                        c = '\u0000';
                        continue;
                    }
                    stringBuffer.append(c2);
                    continue;
                }
                if (c2 == '\"' || c2 == '\'') {
                    c = c2;
                    continue;
                }
                if (string2 == null) {
                    if (c2 == '=' || i == string.length() - 1) {
                        string2 = stringBuffer.toString().trim();
                        stringBuffer.delete(0, stringBuffer.length());
                        continue;
                    }
                    stringBuffer.append(c2);
                    continue;
                }
                if (c2 == ',' || i == string.length() - 1) {
                    String string3 = stringBuffer.toString().trim();
                    stringBuffer.delete(0, stringBuffer.length());
                    properties.setProperty(string2, string3);
                    string2 = null;
                    continue;
                }
                stringBuffer.append(c2);
            }
            if (string2 == null) return properties;
            String string4 = stringBuffer.toString().trim();
            properties.setProperty(string2, string4);
            return properties;
        }
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getJdbcDrivers() {
        return this.jdbcDrivers;
    }

    public synchronized void enableWatchDog() {
        if (this.pool == null) {
            this.createPool(this.jdbcURL, this.connectionProperties, this.size);
        }
        if (!this.pool.isWatchDogEnabled()) {
            this.pool.addListener(this);
            this.pool.setWatchDogEnabled(true);
        }
    }

    public synchronized void disableWatchDog() {
        if (this.pool == null) {
            this.createPool(this.jdbcURL, this.connectionProperties, this.size);
        }
        if (this.pool.isWatchDogEnabled()) {
            this.currentState = "Watchdog not enabled";
            this.pool.removeListener(this);
            this.pool.setWatchDogEnabled(false);
        }
    }

    public void checkFailed(Object object, Throwable throwable) {
        this.currentState = "Connection check failed (" + throwable.getClass().getName() + ": " + throwable.getMessage() + ")";
    }

    public void checkImpossible(Object object, WatchDogException watchDogException) {
        this.currentState = "Connection check impossible " + watchDogException.getMessage();
    }

    public void checkOk(Object object) {
        this.currentState = "Connection check successful";
    }
}

