/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool.connection;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.sadun.util.pool.ObjectPool;
import org.sadun.util.pool.connection.ConnectionPoolWatchDog;
import org.sadun.util.watchdog.WatchDog;

public class ConnectionPool {
    private String jdbcUrl;
    private Properties connectionProperties;
    private DataSource dataSource;
    private ObjectPool pool;
    private boolean testBeforeAcquiring;
    private int maxGetRetry;
    private ConnectionPoolWatchDog watchDog = null;
    private long watchDogCheckPeriodTime = 300000L;
    private Set listeners = new HashSet();
    static /* synthetic */ Class class$java$sql$Connection;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConnectionPool(int n, String string, Properties properties) {
        this.init(n, string, properties, null);
    }

    public ConnectionPool(int n, String string) {
        this(n, string, new Properties());
    }

    public ConnectionPool(int n, DataSource dataSource) {
        this.init(n, null, null, dataSource);
    }

    private void init(int n, String string, Properties properties, DataSource dataSource) {
        this.jdbcUrl = string;
        this.connectionProperties = properties;
        this.dataSource = dataSource;
        this.pool = new ObjectPool(n, new ConnectionFactory());
        this.maxGetRetry = Math.min(3, this.maxGetRetry);
    }

    public Connection getConnection() throws ObjectPool.ObjectPoolException {
        int n = 0;
        Connection connection = (Connection)this.pool.acquire();
        if (connection == null) {
            throw new ObjectPool.ObjectPoolException("The thread " + Thread.currentThread().getName() + " accessing the connection pool " + this.toString() + " has been interrupted while was waiting for a connection to free");
        }
        do {
            if (this.testBeforeAcquiring) {
                try {
                    ConnectionPool.doTest(connection);
                    return connection;
                }
                catch (SQLException sQLException) {
                    connection = (Connection)this.pool.renew(connection);
                }
            } else {
                return connection;
            }
        } while (++n < this.maxGetRetry);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doTest(Connection connection) throws SQLException {
        ResultSet resultSet = null;
        try {
            if (!$assertionsDisabled && connection == null) {
                throw new AssertionError();
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getCatalogs();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection connection) {
        ObjectPool objectPool = this.pool;
        synchronized (objectPool) {
            this.pool.release(connection);
            try {
                if (connection.isClosed()) {
                    this.pool.renew(connection);
                }
            }
            catch (SQLException sQLException) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                sQLException.printStackTrace(printWriter);
                DriverManager.println(stringWriter.toString());
                System.err.println("Warning: org.sadun.util.ConnectionPool.releaseConnection() could not check wether a" + File.separator + "pooled connection had been closed or not (set the JDBC DriverManager" + File.separator + "logstream to see the causing SQLException)");
            }
        }
    }

    public boolean isTestBeforeAcquiring() {
        return this.testBeforeAcquiring;
    }

    public void setTestBeforeAcquiring(boolean bl) {
        this.testBeforeAcquiring = bl;
    }

    public int getMaxGetRetry() {
        return this.maxGetRetry;
    }

    public void setMaxGetRetry(int n) {
        if (n <= 1) {
            throw new IllegalArgumentException("maxGetRetry cannot be set to values less than 2");
        }
        this.maxGetRetry = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(WatchDog.Listener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(WatchDog.Listener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void setWatchDogEnabled(boolean bl) {
        if (bl) {
            if (this.watchDog != null) {
                return;
            }
            this.watchDog = new ConnectionPoolWatchDog(this, this.watchDogCheckPeriodTime);
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                this.watchDog.addListener((WatchDog.Listener)iterator.next());
            }
            this.watchDog.start();
        } else {
            if (this.watchDog == null) {
                return;
            }
            this.watchDog.shutdown();
            this.watchDog = null;
        }
    }

    public boolean isWatchDogEnabled() {
        return this.watchDog != null;
    }

    public long getWatchDogCheckPeriodTime() {
        return this.watchDogCheckPeriodTime;
    }

    public void setWatchDogCheckPeriodTime(long l) {
        this.watchDogCheckPeriodTime = l;
        if (this.watchDog != null) {
            this.watchDog.setCheckPeriodTime(l);
        }
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void destroy(boolean bl) {
        this.setWatchDogEnabled(false);
        this.pool.destroy(bl);
    }

    public int getFreeCount() {
        return this.pool.getFreeCount();
    }

    public int getUsedCount() {
        return this.pool.getUsedCount();
    }

    public synchronized int getSize() {
        return this.pool.getSize();
    }

    static {
        $assertionsDisabled = !ConnectionPool.class.desiredAssertionStatus();
    }

    private final class ConnectionFactory
    implements ObjectPool.Factory {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ConnectionFactory() {
        }

        public Object create() throws ObjectPool.ObjectPoolException {
            try {
                if (!$assertionsDisabled && ConnectionPool.this.jdbcUrl == null && ConnectionPool.this.dataSource == null) {
                    throw new AssertionError();
                }
                if (ConnectionPool.this.jdbcUrl != null) {
                    return DriverManager.getConnection(ConnectionPool.this.jdbcUrl, ConnectionPool.this.connectionProperties);
                }
                return ConnectionPool.this.dataSource.getConnection();
            }
            catch (SQLException sQLException) {
                throw new ObjectPool.ObjectPoolException(sQLException);
            }
        }

        public Class getProducedClass() {
            return class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectionPool.class$("java.sql.Connection")) : class$java$sql$Connection;
        }

        public void destroy(Object object) throws ObjectPool.ObjectPoolException {
            if (object instanceof Connection) {
                try {
                    ((Connection)object).close();
                }
                catch (SQLException sQLException) {
                    throw new ObjectPool.ObjectPoolException(sQLException);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$sadun$util$pool$connection$ConnectionPool == null ? (class$org$sadun$util$pool$connection$ConnectionPool = ConnectionPool.class$("org.sadun.util.pool.connection.ConnectionPool")) : class$org$sadun$util$pool$connection$ConnectionPool).desiredAssertionStatus();
        }
    }
}

