/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool.connection;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.sadun.util.IndentedPrintWriter;

public class ConfigurableDataSource
implements DataSource,
Serializable {
    private String jdbcUrl;
    private Properties connectionProperties;
    private PrintWriter logWriter;

    public ConfigurableDataSource() {
        this.connectionProperties = new Properties();
    }

    public ConfigurableDataSource(String string) {
        this(string, new Properties());
    }

    public ConfigurableDataSource(String string, Properties properties) {
        this.jdbcUrl = string;
        this.connectionProperties = properties;
    }

    public ConfigurableDataSource(InputStream inputStream) {
        this(ConfigurableDataSource.fromXMLStream(inputStream));
    }

    public ConfigurableDataSource(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurableDataSource fromXMLStream(InputStream inputStream) {
        try {
            XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(inputStream));
            ConfigurableDataSource configurableDataSource = (ConfigurableDataSource)xMLDecoder.readObject();
            return configurableDataSource;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                DriverManager.println("[ConfigurableDataSource] Could not close XML configuration stream");
            }
        }
    }

    private ConfigurableDataSource(ConfigurableDataSource configurableDataSource) {
        this.jdbcUrl = configurableDataSource.jdbcUrl;
        this.connectionProperties = configurableDataSource.connectionProperties;
    }

    public Connection getConnection() throws SQLException {
        if (this.jdbcUrl == null) {
            throw new SQLException("Please set the data source JDBC url via setJdbcUrl()");
        }
        return DriverManager.getConnection(this.jdbcUrl, this.connectionProperties);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.jdbcUrl == null) {
            throw new SQLException("Please set the data source JDBC url via setJdbcUrl()");
        }
        Properties properties = new Properties();
        properties.put("user", string);
        properties.put("password", string2);
        return DriverManager.getConnection(this.jdbcUrl, properties);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setConnectionProperties(Properties properties) {
        this.connectionProperties = properties;
    }

    public void setJdbcUrl(String string) {
        this.jdbcUrl = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        IndentedPrintWriter indentedPrintWriter = new IndentedPrintWriter(stringWriter);
        indentedPrintWriter.println(this.jdbcUrl);
        if (this.connectionProperties.size() > 0) {
            indentedPrintWriter.setIndentation(5);
            this.connectionProperties.list(indentedPrintWriter);
        }
        indentedPrintWriter.close();
        return stringWriter.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ConfigurableDataSource) {
            ConfigurableDataSource configurableDataSource = (ConfigurableDataSource)object;
            return configurableDataSource.jdbcUrl.equals(this.jdbcUrl) && configurableDataSource.connectionProperties.equals(this.connectionProperties);
        }
        return false;
    }

    public int hashCode() {
        return this.jdbcUrl.hashCode();
    }

    public static void main(String[] stringArray) throws Exception {
        XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream("/temp/dsTest.xml")));
        String string = "jdbc:microsoft:sqlserver://localhost:1433;User=sa;Password=;DatabaseName=ipm";
        Properties properties = new Properties();
        properties.put("fooProperty", "fooValue");
        ConfigurableDataSource configurableDataSource = new ConfigurableDataSource(string, properties);
        xMLEncoder.writeObject(configurableDataSource);
        xMLEncoder.close();
        ConfigurableDataSource configurableDataSource2 = new ConfigurableDataSource(new File("/temp/dsTest.xml"));
        System.out.println(configurableDataSource2);
    }
}

