/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sadun.util.ObjectLister;
import org.sadun.util.Setup;

public class ObjectPool
implements Serializable {
    protected Set free;
    protected Set used;
    protected PooledObjectWrapper[] pool;
    private Factory factory;
    private boolean verbose;

    private static Class findClass(String string) throws ObjectPoolException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ObjectPoolException(classNotFoundException);
        }
    }

    public ObjectPool(int n, Factory factory) {
        boolean bl = this.verbose = System.getProperty("org.sadun.verbose") != null;
        if (n == 0) {
            throw new IllegalArgumentException("Can't build a pool of 0 objects");
        }
        this.used = new HashSet();
        this.free = new HashSet();
        this.pool = new PooledObjectWrapper[n];
        this.factory = factory;
        Class clazz = factory.getProducedClass();
        if (this.verbose) {
            System.out.println("Creating " + n + " objects of type " + clazz.getName());
        }
        for (int i = 0; i < n; ++i) {
            this.pool[i] = new PooledObjectWrapper(factory.create());
            if (!clazz.isAssignableFrom(this.pool[i].object.getClass())) {
                throw new ObjectPoolException("The provided factory " + factory + " must create only objects of type " + clazz.getName() + ". The produced object has type " + this.pool[i].object.getClass().getName() + " instead");
            }
            if (this.free.contains(this.pool[i].object)) {
                throw new ObjectPoolException("Attempting to add the same object (\"" + this.pool[i].object.toString() + "\") twice to the pool");
            }
            this.free.add(this.pool[i].object);
        }
        if (this.verbose) {
            System.out.println("Object pool created");
        }
    }

    public ObjectPool(int n, String string, Object[] objectArray, Setup setup) throws ClassNotFoundException {
        this(n, new ObjectFactory(Class.forName(string), objectArray, setup));
    }

    public ObjectPool(int n, String string, Object[] objectArray) throws ClassNotFoundException {
        this(n, Class.forName(string), objectArray, null);
    }

    public ObjectPool(int n, String string) throws ClassNotFoundException {
        this(n, Class.forName(string), null);
    }

    public ObjectPool(int n, Class clazz, Object[] objectArray, Setup setup) {
        this(n, new ObjectFactory(clazz, objectArray, setup));
    }

    public ObjectPool(int n, Class clazz, Object[] objectArray) {
        this(n, clazz, objectArray, null);
    }

    public ObjectPool(int n, Class clazz) {
        this(n, clazz, null);
    }

    public synchronized int getFreeCount() {
        return this.free.size();
    }

    public synchronized int getUsedCount() {
        return this.used.size();
    }

    public synchronized int getSize() {
        return this.free.size() + this.used.size();
    }

    public synchronized Object acquire(boolean bl) {
        if (this.free.isEmpty()) {
            if (bl) {
                try {
                    this.wait(0L);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (this.free.isEmpty()) {
            return this.acquire(bl);
        }
        Object e = this.free.iterator().next();
        this.acquire0(e);
        return e;
    }

    private void acquire0(Object object) {
        this.free.remove(object);
        this.used.add(object);
    }

    public Object acquire() {
        return this.acquire(true);
    }

    public synchronized Object acquire(int n) {
        PooledObjectWrapper pooledObjectWrapper = this.pool[n];
        if (this.used.contains(pooledObjectWrapper.object)) {
            try {
                pooledObjectWrapper.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return null;
            }
        }
        this.acquire0(pooledObjectWrapper.object);
        return pooledObjectWrapper.object;
    }

    public synchronized void release(int n) {
        PooledObjectWrapper pooledObjectWrapper = this.pool[n];
        this.release0(pooledObjectWrapper.object);
        pooledObjectWrapper.notify();
    }

    public synchronized void release(Object object, boolean bl) {
        if (!this.used.contains(object)) {
            throw new IllegalArgumentException("The object " + object + " is not a pooled object or has been renewed");
        }
        this.release0(object);
        if (bl) {
            this.notify();
        }
    }

    private void release0(Object object) {
        this.used.remove(object);
        this.free.add(object);
    }

    public void release(Object object) {
        this.release(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object renew(Object object) {
        Object object2 = this.factory.create();
        int n = -1;
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i].object != object) continue;
            n = i;
            break;
        }
        if (n == -1) {
            if (this.verbose) {
                System.out.println(this);
            }
            throw new IllegalArgumentException("The object <" + object + "> is not a pooled object");
        }
        if (this.used.contains(object)) {
            Object object3 = object;
            synchronized (object3) {
                this.release(object);
                this.free.remove(object);
                this.used.add(object2);
                if (this.verbose) {
                    System.out.println("Used object " + object + " renewed by " + object2);
                }
            }
        }
        if (this.free.contains(object)) {
            Object object4 = object;
            synchronized (object4) {
                this.free.remove(object);
                this.free.add(object2);
                if (this.verbose) {
                    System.out.println("Free object " + object + " renewed by " + object2);
                }
            }
        }
        this.pool[n] = new PooledObjectWrapper(object2);
        return object2;
    }

    public synchronized String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Pool of " + this.pool.length + " objects of type " + this.factory.getProducedClass().getName());
        Iterator iterator = this.used.iterator();
        while (iterator.hasNext()) {
            printWriter.println("[Used] \"" + iterator.next() + "\"");
        }
        iterator = this.free.iterator();
        while (iterator.hasNext()) {
            printWriter.println("[Free] \"" + iterator.next() + "\"");
        }
        return stringWriter.toString();
    }

    public static ObjectPool newPool(int n, String string) throws ObjectPoolException {
        return new ObjectPool(n, new ObjectFactory(string, null, null));
    }

    public static ObjectPool newPool(int n, String string, Object[] objectArray) throws ObjectPoolException {
        return new ObjectPool(n, new ObjectFactory(string, objectArray, null));
    }

    public Class getObjectType() {
        return this.factory.getProducedClass();
    }

    protected Factory getFactory() {
        return this.factory;
    }

    protected void setFactory(Factory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(boolean bl) {
        int n = 0;
        if (this.verbose) {
            System.out.println("Destroying object pool, " + (bl ? "" : "not ") + "waiting for objects in use to be released");
        }
        do {
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] == null) continue;
                PooledObjectWrapper pooledObjectWrapper = this.pool[i];
                synchronized (pooledObjectWrapper) {
                    boolean bl2 = true;
                    if (bl && this.used.contains(this.pool[i].object)) {
                        bl2 = false;
                        if (this.verbose) {
                            System.out.println("(Waiting for " + this.pool[i].object + " to be freed)");
                        }
                    }
                    if (bl2) {
                        this.factory.destroy(this.pool[i].object);
                        this.free.remove(this.pool[i].object);
                        this.used.remove(this.pool[i].object);
                        this.pool[i] = null;
                        ++n;
                    }
                    continue;
                }
            }
        } while (bl && n < this.pool.length);
        if (this.verbose) {
            System.out.println("Object pool destroyed");
        }
    }

    public static class ObjectFactory
    extends BaseFactory {
        public ObjectFactory(Class clazz, Object[] objectArray, Setup setup) {
            super(clazz, objectArray, setup);
        }

        public ObjectFactory(String string, Object[] objectArray, Setup setup) {
            super(string, objectArray, setup);
        }

        public Object create() {
            try {
                Constructor constructor = this.cls.getConstructor(this.paramCls);
                Object t = constructor.newInstance(this.params);
                if (this.ps != null) {
                    this.ps.setup(t);
                }
                return t;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ObjectPoolException("The class " + this.cls.getName() + " does not have a constructor matching the passed parameter objects (" + ObjectLister.getInstance().list(this.params));
            }
            catch (InstantiationException instantiationException) {
                throw new ObjectPoolException("Could not instantiate " + this.cls.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ObjectPoolException("Could not access proper constructor in " + this.cls.getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ObjectPoolException("Object construction failed with exception " + invocationTargetException.getTargetException());
            }
        }

        public void destroy(Object object) {
        }
    }

    public static abstract class BaseFactory
    implements Factory {
        protected Class cls;
        protected Object[] params;
        protected Setup ps;
        protected Class[] paramCls;

        public BaseFactory(Class clazz, Object[] objectArray, Setup setup) {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            this.cls = clazz;
            this.params = objectArray;
            this.ps = setup;
            this.paramCls = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.paramCls[i] = objectArray[i].getClass();
            }
        }

        public BaseFactory(String string, Object[] objectArray, Setup setup) {
            this(ObjectPool.findClass(string), objectArray, setup);
        }

        public abstract Object create();

        public void destroy(Object object) {
        }

        public Class getProducedClass() {
            return this.cls;
        }
    }

    public static interface Factory
    extends Serializable {
        public Object create() throws ObjectPoolException;

        public void destroy(Object var1) throws ObjectPoolException;

        public Class getProducedClass();
    }

    protected static final class PooledObjectWrapper
    implements Serializable {
        private Object object;

        PooledObjectWrapper(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static final class ObjectPoolException
    extends RuntimeException {
        private Throwable e;

        public ObjectPoolException(String string) {
            super(string);
        }

        public ObjectPoolException(Throwable throwable) {
            this("", throwable);
        }

        public ObjectPoolException(String string, Throwable throwable) {
            super(string + "(caused by " + throwable.getClass().getName() + ": " + throwable.getMessage() + ")");
            this.e = throwable;
        }

        public Throwable getRootException() {
            return this.e;
        }
    }
}

