/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool;

import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.sadun.util.pool.ManagedObjectPoolMBean;
import org.sadun.util.pool.ObjectPool;

public class ManagedObjectPool
implements ManagedObjectPoolMBean,
MBeanRegistration {
    private ObjectPool pool;
    private String factoryClassName = NullFactory.class.getName();
    private int size = 1;
    private String className = "";
    private boolean registered = false;
    private ObjectName objectName;
    static /* synthetic */ Class class$java$lang$Object;

    public ManagedObjectPool() {
    }

    protected ManagedObjectPool(int n, String string) {
        this.size = n;
        this.factoryClassName = string;
        this.className = null;
    }

    private static ObjectPool.Factory createFactory(String string) throws MBeanException {
        try {
            Object obj = Class.forName(string).newInstance();
            if (!(obj instanceof ObjectPool.Factory)) {
                throw new MBeanException(new IllegalArgumentException("FactoryClassName must be the name of a class implementing the ObjectPool.Factory interface"));
            }
            return (ObjectPool.Factory)obj;
        }
        catch (InstantiationException instantiationException) {
            throw new MBeanException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MBeanException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MBeanException(classNotFoundException);
        }
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public void setFactoryClassName(String string) throws MBeanException {
        this.checkPoolStateForReset();
        String string2 = this.factoryClassName;
        String string3 = this.className;
        int n = this.size;
        this.factoryClassName = string;
        this.className = this.pool.getFactory().getProducedClass().getName();
        if (this.registered) {
            this.pool = this.createPool(string2, string3, n);
        }
    }

    public void setSize(int n) throws MBeanException {
        if (n == this.getSize()) {
            return;
        }
        this.checkPoolStateForReset();
        String string = this.factoryClassName;
        String string2 = this.className;
        int n2 = this.size;
        this.size = n;
        if (this.registered) {
            this.pool = this.createPool(string, string2, n2);
        }
    }

    public void setClassName(String string) throws MBeanException {
        this.checkPoolStateForReset();
        String string2 = this.factoryClassName;
        String string3 = this.className;
        int n = this.size;
        this.factoryClassName = "";
        this.className = string;
        if (this.registered) {
            this.pool = this.createPool(string2, string3, n);
        }
    }

    private void checkPoolStateForReset() throws MBeanException {
        if (this.pool != null && this.pool.getFreeCount() != this.pool.getSize()) {
            throw new MBeanException(new IllegalStateException("Cannot reset the pool when there are " + this.getUsedCount() + " used objects"));
        }
    }

    public int getFreeCount() {
        return this.pool.getFreeCount();
    }

    public Class getObjectType() {
        return this.pool.getObjectType();
    }

    public int getSize() {
        return this.pool.getSize();
    }

    public int getUsedCount() {
        return this.pool.getUsedCount();
    }

    public String getClassName() {
        return this.className;
    }

    public void postDeregister() {
        this.registered = false;
    }

    public void postRegister(Boolean bl) {
        if (bl.booleanValue()) {
            this.registered = true;
            this.pool = this.createPool(this.factoryClassName, this.className, this.size);
        }
    }

    private ObjectPool createPool(String string, String string2, int n) {
        try {
            if (this.factoryClassName.length() > 0) {
                try {
                    System.out.println("[ObjectPool] Creating pool of " + this.size + " objects using the factory class " + this.factoryClassName);
                    return new ObjectPool(this.size, ManagedObjectPool.createFactory(this.factoryClassName));
                }
                catch (MBeanException mBeanException) {
                    throw new RuntimeException(mBeanException.getTargetException());
                }
            }
            if (this.className.length() > 0) {
                try {
                    System.out.println("[ObjectPool] Creating pool of " + this.size + " objects of class " + this.className);
                    return new ObjectPool(this.size, this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
            }
            throw new RuntimeException("Either FactoryClassName or ClassName attributes must be declared");
        }
        catch (RuntimeException runtimeException) {
            this.factoryClassName = string;
            this.className = string2;
            this.size = n;
            throw runtimeException;
        }
    }

    public void preDeregister() throws Exception {
        if (this.pool != null) {
            this.pool.destroy(true);
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        return this.objectName;
    }

    private static class NullFactory
    implements ObjectPool.Factory {
        private NullFactory() {
        }

        public Object create() throws ObjectPool.ObjectPoolException {
            return new Object();
        }

        public void destroy(Object object) throws ObjectPool.ObjectPoolException {
        }

        public Class getProducedClass() {
            return class$java$lang$Object == null ? (class$java$lang$Object = ManagedObjectPool.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }
}

