/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sadun.util.IndentedPrintWriter;
import org.sadun.util.ListMapIterator;
import org.sadun.util.Setup;
import org.sadun.util.pool.ObjectPool;

public class ExtendedObjectPool {
    private ObjectPool pool;
    private Map allocationTable = new HashMap();

    public ExtendedObjectPool(int n, ObjectPool.Factory factory) {
        this.pool = new ObjectPool(n, factory);
    }

    public ExtendedObjectPool(int n, String string, Object[] objectArray, Setup setup) throws ClassNotFoundException {
        this.pool = new ObjectPool(n, string, objectArray, setup);
    }

    public ExtendedObjectPool(int n, String string, Object[] objectArray) throws ClassNotFoundException {
        this.pool = new ObjectPool(n, string, objectArray);
    }

    public ExtendedObjectPool(int n, String string) throws ClassNotFoundException {
        this.pool = new ObjectPool(n, string);
    }

    public ExtendedObjectPool(int n, Class clazz, Object[] objectArray, Setup setup) {
        this.pool = new ObjectPool(n, clazz, objectArray, setup);
    }

    public ExtendedObjectPool(int n, Class clazz, Object[] objectArray) {
        this.pool = new ObjectPool(n, clazz, objectArray);
    }

    public ExtendedObjectPool(int n, Class clazz) {
        this.pool = new ObjectPool(n, clazz);
    }

    public int getFreeCount() {
        return this.pool.getFreeCount();
    }

    public int getUsedCount() {
        return this.pool.getUsedCount();
    }

    public int getSize() {
        return this.pool.getSize();
    }

    public synchronized Object acquire(Object object, boolean bl) {
        Object object2 = this.pool.acquire(bl);
        if (object2 != null) {
            this.allocate(object, object2);
        }
        return object2;
    }

    public Object acquire(Object object) {
        return this.acquire(object, true);
    }

    public Object acquire(Object object, int n) {
        Object object2 = this.pool.acquire(n);
        if (object2 != null) {
            this.allocate(object, object2);
        }
        return object2;
    }

    private void allocate(Object object, Object object2) {
        ArrayList<Object> arrayList = (ArrayList<Object>)this.allocationTable.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            this.allocationTable.put(object, arrayList);
        }
        arrayList.add(object2);
    }

    public synchronized void release(Object object, boolean bl) {
        this.deallocate(object);
        this.pool.release(object, bl);
    }

    public void release(Object object) {
        this.release(object, true);
    }

    private void deallocate(Object object) {
        ListMapIterator listMapIterator = new ListMapIterator(this.allocationTable);
        while (listMapIterator.hasNext()) {
            Object object2 = listMapIterator.next();
            if (object2 != object) continue;
            List list = (List)this.allocationTable.get(listMapIterator.getCurrentKey());
            list.remove(object);
            if (list.size() != 0) break;
            this.allocationTable.remove(listMapIterator.getCurrentKey());
            break;
        }
    }

    public synchronized Object renew(Object object, Object object2) {
        Object object3 = this.pool.renew(object2);
        this.deallocate(object2);
        this.allocate(object, object3);
        return object3;
    }

    public synchronized String toString() {
        StringWriter stringWriter = new StringWriter();
        IndentedPrintWriter indentedPrintWriter = new IndentedPrintWriter(stringWriter);
        indentedPrintWriter.println(this.pool.toString());
        indentedPrintWriter.println("[Allocation table]");
        indentedPrintWriter.println();
        indentedPrintWriter.incIndentation(3);
        ListMapIterator listMapIterator = new ListMapIterator(this.allocationTable);
        while (listMapIterator.hasNext()) {
            Object object = listMapIterator.next();
            Object object2 = listMapIterator.getCurrentKey();
            indentedPrintWriter.println(object.getClass().getName() + " (\"" + object.toString() + "\"): \t" + object2.getClass().getName() + " (\"" + object2.toString() + "\")");
        }
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        ExtendedObjectPool extendedObjectPool = new ExtendedObjectPool(2, Thread.class);
        Object object = new Object();
        Thread thread = (Thread)extendedObjectPool.acquire(object);
        System.out.println(extendedObjectPool);
        extendedObjectPool.release(thread);
    }
}

