/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.codegen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VariableNameGenerator {
    public static final int JDK1_3 = 0;
    public static final int JDK1_4 = 1;
    private Map prefixMap;
    private String currentMethodName = null;
    private int jdkRelease;
    private static Set reservedNames;
    private static Set jdk14reservedNames;

    public VariableNameGenerator(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("jdk release parameter incorrect - use the constants defined by this class");
        }
        this.jdkRelease = n;
        this.prefixMap = new HashMap();
    }

    public VariableNameGenerator() {
        this(1);
    }

    public void reset() {
        this.prefixMap = new HashMap();
    }

    public String generateNext(String string, Class clazz) {
        if (!string.equals(this.currentMethodName)) {
            this.currentMethodName = string;
            this.reset();
        }
        if (clazz.isPrimitive()) {
            return this.generateForPrimitiveType(string, clazz);
        }
        if (clazz.isArray()) {
            String string2 = this.generateNext(string, clazz.getComponentType());
            if (!string2.endsWith("Array")) {
                string2 = string2 + "Array";
            }
            return string2;
        }
        return this.generateForObjectType(string, clazz);
    }

    private String generateForObjectType(String string, Class clazz) {
        int n = clazz.getName().lastIndexOf(".");
        if (n == -1) {
            return this.pickNext(this.getCanonicalName(clazz.getName()));
        }
        return this.pickNext(this.getCanonicalName(clazz.getName().substring(n + 1)));
    }

    private String getCanonicalName(String string) {
        if (string.length() == 1) {
            return string.toLowerCase();
        }
        if (Character.isUpperCase(string.charAt(0))) {
            string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        if (this.isReservedIdentifier(string)) {
            return "_" + string;
        }
        string = string.replaceAll("\\$", "_");
        return string;
    }

    private boolean isReservedIdentifier(String string) {
        if (this.jdkRelease == 1 && jdk14reservedNames.contains(string)) {
            return true;
        }
        return reservedNames.contains(string);
    }

    private String generateForPrimitiveType(String string, Class clazz) {
        return this.pickNext(clazz.getName().substring(0, 1));
    }

    private String pickNext(String string) {
        Integer n = (Integer)this.prefixMap.get(string);
        if (n == null) {
            n = new Integer(0);
        }
        int n2 = n;
        this.prefixMap.put(string, new Integer(n2 + 1));
        return string + n2;
    }

    static {
        String[] stringArray = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "delegate", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "multicast", "native", "new", "null", "object", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
        reservedNames = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            reservedNames.add(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"assert"};
        jdk14reservedNames = new HashSet();
        for (int i = 0; i < stringArray2.length; ++i) {
            jdk14reservedNames.add(stringArray2[i]);
        }
    }
}

