/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.ant;

import com.deltax.util.JDK12ClassFileFinder;
import com.sun.tools.javac.v8.JavaCompiler;
import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Options;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.sadun.util.IndentedPrintWriter;
import org.sadun.util.VersionImpl;
import org.sadun.util.ant.BaseVersion;

public class Version
extends BaseVersion {
    private int major = -1;
    private int minor = -1;
    private int micro = -1;
    private String level = null;
    private boolean deleteGeneratedCode = false;
    private boolean copyStdClasses = true;
    private String propertyName;
    private boolean override;
    private long lastBuildNumber = -1L;
    private boolean verbose = false;
    private String taskClassPath;
    static /* synthetic */ Class class$org$sadun$util$ant$Version;
    static /* synthetic */ Class class$org$sadun$util$VersionImpl;
    static /* synthetic */ Class class$org$apache$tools$ant$AntClassLoader;
    static /* synthetic */ Class class$org$sadun$util$Version;

    public void execute() throws BuildException {
        super.execute();
        this.lastBuildNumber = this.computeLastBuildNumber();
        this.log("Build number will be " + (this.lastBuildNumber + 1L));
        long l = System.currentTimeMillis();
        VersionImpl versionImpl = new VersionImpl(this.major, this.minor, this.micro, this.level, this.lastBuildNumber, l);
        if (!versionImpl.hasInfoEnough()) {
            throw new BuildException("Not enough version information provided. At least give major number, or build number, or level");
        }
        this.log("Setting properties...");
        if (this.propertyName == null) {
            this.propertyName = "version";
        }
        String string = (this.major == -1 ? versionImpl.getMajorNumber() : this.major) + "." + (this.minor == -1 ? versionImpl.getMajorNumber() : this.minor) + "." + (this.micro == -1 ? versionImpl.getMicroNumber() : this.micro);
        this.safeSet(this.propertyName, string);
        this.safeSet(this.propertyName + ".major", "" + versionImpl.getMajorNumber());
        this.safeSet(this.propertyName + ".minor", "" + versionImpl.getMinorNumber());
        this.safeSet(this.propertyName + ".micro", "" + versionImpl.getMicroNumber());
        this.safeSet(this.propertyName + ".build", "" + versionImpl.getBuildNumber());
        this.log("Generating version object source in " + this.versionObjectSourcePath.getAbsolutePath());
        File file = this.generateVersionClassCode(l);
        this.log("Compiling " + file.getAbsolutePath() + " in " + this.versionObjectBinaryPath.getAbsolutePath());
        this.compileVersionCode(file);
        if (this.copyStdClasses) {
            this.copyStdClasses(this.versionObjectBinaryPath);
        }
        if (!this.useExistingVersionClass) {
            this.log("Updating " + this.versionInfoPath.getAbsolutePath());
            this.mkVersionInfoFile(this.versionInfoPath, this.lastBuildNumber + 1L);
        }
        if (this.deleteGeneratedCode) {
            this.log("Deleting " + file.getAbsolutePath());
            if (!file.delete()) {
                throw new BuildException("Cannot delete " + file);
            }
        }
        this.log("Version class generation done");
    }

    private void safeSet(String string, String string2) {
        if (this.getProject().getProperty(string) != null && !this.override) {
            throw new BuildException("The property '" + string + "' already exists. User override='yes' to allow override");
        }
        this.getProject().setProperty(string, string2);
        this.log("Property " + string + " set to " + this.getProject().getProperty(string));
    }

    private void copyStdClasses(File file) throws BuildException {
        this.log("Copying standard library classes to " + file.getAbsolutePath());
        JDK12ClassFileFinder jDK12ClassFileFinder = new JDK12ClassFileFinder(this.getTaskClassPath());
        try {
            this.writeClassFile((class$org$sadun$util$ant$Version == null ? (class$org$sadun$util$ant$Version = Version.class$("org.sadun.util.ant.Version")) : class$org$sadun$util$ant$Version).getName(), file, jDK12ClassFileFinder.getBytes((class$org$sadun$util$ant$Version == null ? (class$org$sadun$util$ant$Version = Version.class$("org.sadun.util.ant.Version")) : class$org$sadun$util$ant$Version).getName()));
        }
        catch (IOException iOException) {
            throw new BuildException("I/O error attempting to locate " + (class$org$sadun$util$ant$Version == null ? (class$org$sadun$util$ant$Version = Version.class$("org.sadun.util.ant.Version")) : class$org$sadun$util$ant$Version).getName() + " in " + this.getTaskClassPath(), (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Could not locate " + (class$org$sadun$util$ant$Version == null ? (class$org$sadun$util$ant$Version = Version.class$("org.sadun.util.ant.Version")) : class$org$sadun$util$ant$Version).getName() + " in " + this.getTaskClassPath());
        }
        try {
            this.writeClassFile((class$org$sadun$util$VersionImpl == null ? (class$org$sadun$util$VersionImpl = Version.class$("org.sadun.util.VersionImpl")) : class$org$sadun$util$VersionImpl).getName(), file, jDK12ClassFileFinder.getBytes((class$org$sadun$util$VersionImpl == null ? (class$org$sadun$util$VersionImpl = Version.class$("org.sadun.util.VersionImpl")) : class$org$sadun$util$VersionImpl).getName()));
        }
        catch (IOException iOException) {
            throw new BuildException("I/O error attempting to locate " + (class$org$sadun$util$VersionImpl == null ? (class$org$sadun$util$VersionImpl = Version.class$("org.sadun.util.VersionImpl")) : class$org$sadun$util$VersionImpl).getName() + " in " + this.getTaskClassPath(), (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Could not locate " + (class$org$sadun$util$VersionImpl == null ? (class$org$sadun$util$VersionImpl = Version.class$("org.sadun.util.VersionImpl")) : class$org$sadun$util$VersionImpl).getName() + " in " + this.getTaskClassPath());
        }
    }

    private void writeClassFile(String string, File file, byte[] byArray) throws BuildException {
        File file2 = this.mkFilePath(file, this.frontName(string), this.baseName(string), "class");
        try {
            int n;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            while ((n = byteArrayInputStream.read()) != -1) {
                ((OutputStream)bufferedOutputStream).write(n);
            }
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException("Could not write " + file2.getAbsolutePath() + ". Use copyStdClasses=no to disable library class creation.");
        }
        catch (IOException iOException) {
            throw new BuildException("Error writing " + file2.getAbsolutePath() + ". Use copyStdClasses=no to disable library class creation.");
        }
    }

    private String getTaskClassPath() {
        if (this.taskClassPath == null) {
            String string;
            if (((Object)((Object)this)).getClass().getClassLoader() instanceof AntClassLoader) {
                AntClassLoader antClassLoader = (AntClassLoader)((Object)((Object)this)).getClass().getClassLoader();
                string = antClassLoader.getClasspath();
            } else {
                this.log("Version task ClassLoader is not the expected " + (class$org$apache$tools$ant$AntClassLoader == null ? (class$org$apache$tools$ant$AntClassLoader = Version.class$("org.apache.tools.ant.AntClassLoader")) : class$org$apache$tools$ant$AntClassLoader).getName() + " but " + ((Object)((Object)this)).getClass().getClassLoader().getClass().getName() + " instead. Setting classpath by using java.class.path property - required interfaces might not be found", 1);
                string = System.getProperty("java.class.path");
            }
            this.log("Class path is " + string);
            this.taskClassPath = string;
        }
        return this.taskClassPath;
    }

    private void compileVersionCode(File file) {
        Hashtable hashtable = new Hashtable();
        hashtable.put((Object)"-classpath", (Object)System.getProperty("java.class.path"));
        List list = List.make((Object)file.getAbsolutePath());
        Context context = new Context();
        Options options = Options.instance((Context)context);
        options.put((Object)"-classpath", (Object)this.getTaskClassPath());
        JavaCompiler javaCompiler = new JavaCompiler(context);
        try {
            javaCompiler.verbose = this.verbose;
            javaCompiler.classOutput = true;
            List list2 = javaCompiler.compile(list);
            javaCompiler.close();
        }
        catch (Throwable throwable) {
            throw new BuildException("Code compilation has failed", throwable);
        }
        if (javaCompiler.errorCount() != 0) {
            throw new BuildException("Code compilation has failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File generateVersionClassCode(long l) {
        File file;
        StringWriter stringWriter = new StringWriter();
        IndentedPrintWriter indentedPrintWriter = new IndentedPrintWriter(stringWriter);
        indentedPrintWriter.println("// GENERATED CODE - MODIFICATIONS WILL BE LOST");
        indentedPrintWriter.println("// Version class generated by Version ant task - (C) Copyright 2002 dr. Cristiano Sadun; licensed under GPL");
        if (this.versionClsPackageName.length() > 0) {
            indentedPrintWriter.println("package " + this.versionClsPackageName + ";");
            indentedPrintWriter.println();
        }
        indentedPrintWriter.println("/**");
        indentedPrintWriter.println(" * This class is automatically generated by the " + (class$org$sadun$util$ant$Version == null ? (class$org$sadun$util$ant$Version = Version.class$("org.sadun.util.ant.Version")) : class$org$sadun$util$ant$Version).getName() + " ANT task");
        indentedPrintWriter.println(" * to encapsulate version information. ");
        indentedPrintWriter.println(" */");
        indentedPrintWriter.println("public final class " + this.versionSimpleClsName + " extends " + (class$org$sadun$util$VersionImpl == null ? (class$org$sadun$util$VersionImpl = Version.class$("org.sadun.util.VersionImpl")) : class$org$sadun$util$VersionImpl).getName() + " {");
        indentedPrintWriter.incIndentation(3);
        indentedPrintWriter.println("public " + this.versionSimpleClsName + "() {");
        indentedPrintWriter.println("  super(" + this.getRepr(this.major) + "," + this.getRepr(this.minor) + "," + this.getRepr(this.micro) + "," + this.getRepr(this.level) + "," + this.getRepr(this.lastBuildNumber + 1L) + "L," + this.getRepr(l) + "L);");
        indentedPrintWriter.println("}");
        indentedPrintWriter.println();
        indentedPrintWriter.println("public " + this.versionSimpleClsName + "(int major, int minor, int micro) {");
        indentedPrintWriter.println("  super(major, minor, micro," + this.getRepr(this.level) + "," + this.getRepr(this.lastBuildNumber + 1L) + "L," + this.getRepr(l) + "L);");
        indentedPrintWriter.println("}");
        indentedPrintWriter.println();
        indentedPrintWriter.println("public static void main(String args[]) { ");
        indentedPrintWriter.println(" System.out.println(new " + this.versionSimpleClsName + "().getFullDescription());");
        indentedPrintWriter.println("}");
        indentedPrintWriter.decIndentation(3);
        indentedPrintWriter.println("}");
        File file2 = this.mkFilePath(this.versionObjectSourcePath, this.versionClsPackageName, this.versionSimpleClsName, "java");
        BufferedWriter bufferedWriter = null;
        try {
            try {
                int n;
                bufferedWriter = new BufferedWriter(new FileWriter(file2));
                StringReader stringReader = new StringReader(stringWriter.toString());
                while ((n = stringReader.read()) != -1) {
                    bufferedWriter.write(n);
                }
                file = file2;
                Object var11_10 = null;
                if (bufferedWriter == null) return file;
            }
            catch (IOException iOException) {
                throw new BuildException("Could not write version soruce code in " + file2);
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (bufferedWriter == null) throw throwable;
            try {
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException iOException2) {
                this.log("Could not close output stream for " + file2, 1);
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            this.log("Could not close output stream for " + file2, 1);
            return file;
        }
        bufferedWriter.close();
        return file;
    }

    private File mkFilePath(File file, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '.') {
                stringBuffer.append(File.separator);
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        String string4 = stringBuffer.toString();
        File file2 = new File(file, string4);
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new BuildException("The path " + file2 + " is not a directory");
            }
        } else if (!file2.mkdirs()) {
            throw new BuildException("Could not create directory branch for " + file2);
        }
        return new File(file2, string2 + "." + string3);
    }

    private String getRepr(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private String getRepr(long l) {
        if (l == -1L) {
            return (class$org$sadun$util$Version == null ? (class$org$sadun$util$Version = Version.class$("org.sadun.util.Version")) : class$org$sadun$util$Version).getName() + ".NOT_VALUED";
        }
        return String.valueOf(l);
    }

    private void mkVersionInfoFile(File file, long l) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.versionInfoPath)));
            printWriter.println("last.build.number=" + l + "L");
        }
        catch (IOException iOException) {
            throw new BuildException("Could not write " + this.versionInfoPath.getAbsolutePath(), (Throwable)iOException);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public int getMicro() {
        return this.micro;
    }

    public void setMicro(int n) {
        this.micro = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public boolean isUseExistingVersionClass() {
        return this.useExistingVersionClass;
    }

    public void setUseExistingVersionClass(boolean bl) {
        this.useExistingVersionClass = bl;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String string) {
        this.level = string;
    }

    public boolean isDeleteGeneratedCode() {
        return this.deleteGeneratedCode;
    }

    public void setDeleteGeneratedCode(boolean bl) {
        this.deleteGeneratedCode = bl;
    }

    public static void main(String[] stringArray) {
        Project project = new Project();
        project.addBuildListener((BuildListener)new /* Unavailable Anonymous Inner Class!! */);
        Version version = new Version();
        version.setProject(project);
        version.setPackageName("org.sadun.util");
        version.setVersionObjectSourcePath(new File("./source"));
        version.setVersionObjectBinaryPath(new File("./classes"));
        version.execute();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean bl) {
        this.override = bl;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

