/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.ant;

import com.deltax.util.CPoolReader;
import com.deltax.util.DynamicClassFileFinder;
import com.deltax.util.DynamicJDK12ClassFileFinder;
import com.deltax.util.DynamicResourceFileFinder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.sadun.util.SimpleClassPackageExplorer;
import org.sadun.util.ant.ClassSpec;
import org.sadun.util.ant.Resource;

public class Pack
extends Task {
    private String classes;
    private String packages;
    private String targetJar;
    private boolean resolveFiltered = false;
    private String excludePkg;
    private String includePkg;
    private String classpath;
    private Path cPath;
    private String manifestClassPath;
    private String manifestMainClass;
    private boolean cacheClassFiles = true;
    private boolean detectrmi = false;
    private HashMap clsMap;
    private DynamicClassFileFinder cff;
    private DynamicResourceFileFinder rff;
    private CPoolReader cpoolreader = new CPoolReader(this.cff);
    private ClassFilter filter;
    private HashSet refusedNames;
    private Set additionalFiles = new HashSet();
    private Set additionalClasses = new HashSet();
    private Set resources = new HashSet();
    private Set ignorableClasses = new HashSet();

    public void execute() throws BuildException {
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        Iterator<Object> iterator;
        String string = null;
        String string2 = this.getProject().getProperty("build.sysclasspath");
        if (string2 == null) {
            string2 = "first";
        } else {
            this.log("build.systemclasspath is '" + string2 + "'", 3);
        }
        if ("ignore".equals(string2)) {
            string = this.classpath;
        } else if ("only".equals(string2)) {
            string = System.getProperty("java.class.path");
        } else if ("last".equals(string2)) {
            string = this.classpath + File.pathSeparator + System.getProperty("java.class.path");
        } else if ("first".equals(string2)) {
            string = System.getProperty("java.class.path") + File.pathSeparator + this.classpath;
        } else {
            throw new BuildException("Invalid value for build.sysclasspath (must be one of 'ignore','only','last','first'");
        }
        this.classpath = string;
        this.cff = new DynamicJDK12ClassFileFinder(null);
        this.rff = (DynamicJDK12ClassFileFinder)this.cff;
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = this.ignorableClasses.iterator();
        while (stringArray.hasNext()) {
            hashSet.add(((ClassSpec)stringArray.next()).name);
        }
        this.ignorableClasses = hashSet;
        if (this.cacheClassFiles) {
            ((DynamicJDK12ClassFileFinder)this.cff).setClassCacheOn(true);
        }
        if (this.targetJar == null) {
            throw new BuildException("Missing mandatory \"targetJar\" attribute");
        }
        if (this.classes == null && this.packages == null) {
            throw new BuildException("Missing mandatory \"classes\" or \"packages\" attribute");
        }
        if (this.classes != null && this.packages != null) {
            throw new BuildException("Only one of \"classes\" or \"packages\" can be specified");
        }
        if (this.classpath != null) {
            this.cff.addClassPathEntry(this.classpath);
        }
        if (this.cPath != null) {
            this.cff.addClassPathEntry(this.cPath.toString());
        }
        if (this.classes != null) {
            stringArray = Pack.getStringArray(this.classes);
        } else {
            String[] stringArray2 = Pack.getStringArray(this.packages);
            iterator = this.classpath;
            object3 = new SimpleClassPackageExplorer((String)((Object)iterator));
            object2 = new HashSet<String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                this.log("Looking for classes in package " + stringArray2[i] + " using " + (String)((Object)iterator));
                objectArray = object3.listPackage(stringArray2[i]);
                for (int j = 0; j < objectArray.length; ++j) {
                    object2.add(objectArray[j]);
                }
            }
            stringArray = new String[object2.size()];
            object2.toArray(stringArray);
            this.log("Classes to pack computed from given packages list");
        }
        this.clsMap = new HashMap();
        this.refusedNames = new HashSet();
        if (this.includePkg == null) {
            if (this.excludePkg == null) {
                this.excludePkg = "java,javax,sun";
            }
            this.filter = new PackagePrefixClassFilter(Pack.getStringArray(this.excludePkg), false);
        } else {
            this.filter = new PackagePrefixClassFilter(Pack.getStringArray(this.includePkg), true);
        }
        if (this.excludePkg != null) {
            this.log("Excluding packages prefixed with " + this.excludePkg);
        }
        if (this.includePkg != null) {
            this.log("Including only packages prefixed with " + this.includePkg);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.log("Calculating dependencies for " + stringArray[i]);
                this.log("Classpath is " + this.cff.getClassPath(), 3);
                this.findDependencies(stringArray[i], this.clsMap);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log("The current class path is " + this.cff.getClassPath(), 0);
                throw new BuildException((Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new BuildException((Throwable)iOException);
            }
        }
        try {
            object = this.additionalClasses.iterator();
            while (object.hasNext()) {
                iterator = (ClassSpec)object.next();
                this.log("Finding dependencies for additional class " + ((ClassSpec)((Object)iterator)).name, 3);
                this.findDependencies(((ClassSpec)((Object)iterator)).name, this.clsMap, true);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("The current class path is " + this.cff.getClassPath(), 0);
            throw new BuildException((Throwable)classNotFoundException);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        try {
            object = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.targetJar)));
            if (this.manifestClassPath != null | this.manifestMainClass != null) {
                this.log("Creating manifest");
                iterator = new Manifest();
                ((Manifest)((Object)iterator)).getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                if (this.manifestClassPath != null) {
                    ((Manifest)((Object)iterator)).getMainAttributes().put(Attributes.Name.CLASS_PATH, this.manifestClassPath);
                }
                if (this.manifestMainClass != null) {
                    ((Manifest)((Object)iterator)).getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.manifestMainClass);
                }
                object3 = new JarEntry("META-INF/MANIFEST.MF");
                ((JarOutputStream)object).putNextEntry((ZipEntry)object3);
                ((Manifest)((Object)iterator)).write((OutputStream)object);
            }
            this.log("Packing " + this.targetJar);
            iterator = this.clsMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n;
                object3 = (String)iterator.next();
                object2 = ((String)object3).replace('.', '/') + ".class";
                JarEntry jarEntry = new JarEntry((String)object2);
                ((JarOutputStream)object).putNextEntry(jarEntry);
                objectArray = (byte[])this.clsMap.get(object3);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])objectArray);
                while ((n = byteArrayInputStream.read()) != -1) {
                    ((DeflaterOutputStream)object).write(n);
                }
            }
            if (this.additionalFiles.size() > 0) {
                iterator = this.additionalFiles.iterator();
                while (iterator.hasNext()) {
                    object3 = (FileSet)iterator.next();
                    object2 = object3.getDirectoryScanner(this.getProject());
                    object2.scan();
                    String[] stringArray3 = object2.getIncludedFiles();
                    for (int i = 0; i < stringArray3.length; ++i) {
                        int n;
                        File file = new File(object2.getBasedir() + File.separator + stringArray3[i]);
                        this.log("Adding file " + stringArray3[i], 3);
                        String string3 = Pack.replaceAll(stringArray3[i], File.separator, "/");
                        JarEntry jarEntry = new JarEntry(string3);
                        ((JarOutputStream)object).putNextEntry(jarEntry);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                            ((DeflaterOutputStream)object).write(n);
                        }
                    }
                }
            }
            iterator = this.resources.iterator();
            while (iterator.hasNext()) {
                int n;
                object3 = (Resource)iterator.next();
                this.log("Adding resource " + object3, 3);
                object2 = this.rff.openResource(((Resource)object3).name);
                if (object2 == null) {
                    throw new BuildException("resource " + ((Resource)object3).name + " not found. ClassPath is " + this.rff.getClassPath());
                }
                JarEntry jarEntry = new JarEntry(((Resource)object3).name);
                ((JarOutputStream)object).putNextEntry(jarEntry);
                while ((n = ((InputStream)object2).read()) != -1) {
                    ((DeflaterOutputStream)object).write(n);
                }
            }
            ((ZipOutputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new BuildException((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            int n;
            int n2 = 0;
            do {
                n = n2;
                if ((n2 = string.indexOf(string2, n2)) == -1) continue;
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string3);
                n2 += string2.length();
            } while (n2 != -1);
            stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }
    }

    private void findDependencies(String string, Map map) throws IOException, ClassNotFoundException {
        this.findDependencies(string, map, false);
    }

    private void findDependencies(String string, Map map, boolean bl) throws IOException, ClassNotFoundException {
        if (this.ignorableClasses.contains(string)) {
            this.log(string + " ignored as configured", 3);
            return;
        }
        if (map.keySet().contains(string)) {
            return;
        }
        if (this.refusedNames.contains(string)) {
            return;
        }
        if (string.startsWith("[L")) {
            String string2 = string.substring(2, string.length() - 1);
            this.findDependencies(string2, map);
            return;
        }
        if (string.startsWith("[")) {
            String string3 = string.substring(1);
            if ("B".equals(string3)) {
                return;
            }
            if ("C".equals(string3)) {
                return;
            }
            if ("D".equals(string3)) {
                return;
            }
            if ("F".equals(string3)) {
                return;
            }
            if ("I".equals(string3)) {
                return;
            }
            if ("J".equals(string3)) {
                return;
            }
            if ("S".equals(string3)) {
                return;
            }
            if ("Z".equals(string3)) {
                return;
            }
            if ("V".equals(string3)) {
                return;
            }
            this.findDependencies(string3, map);
            return;
        }
        byte[] byArray = this.cff.getClassBytes(string);
        CPoolReader.classfile classfile2 = this.cpoolreader.readClassData(byArray);
        String[] stringArray = Pack.splitClassName(string);
        boolean bl2 = this.filter.accept(stringArray[0], stringArray[1], classfile2);
        if (bl && !bl2) {
            throw new BuildException("The class " + stringArray[0] + "." + stringArray[1] + " is not acceptable with the current includePkg/excludePkg settings (" + this.filter + ")");
        }
        if (bl2) {
            map.put(string, byArray);
            this.log(string + " accepted.", 3);
        } else {
            this.refusedNames.add(string);
            this.log(string + " refused.", 3);
        }
        if (bl2 || this.resolveFiltered) {
            Object object;
            Object object2;
            if (this.detectrmi && classfile2.isInterface() && ((String)(object2 = classfile2.getSuperClass())).equals("java.rmi.Remote")) {
                String string4 = string + "_Stub";
                object = this.cff.getClassBytes(string4);
                map.put(string4, object);
            }
            object2 = classfile2.getUsedClasses();
            for (int i = 0; i < ((String[])object2).length; ++i) {
                object = ((String)object2[i]).replace('/', '.');
                this.findDependencies((String)object, map);
            }
        }
    }

    private static String[] splitClassName(String string) {
        int n = string.lastIndexOf(46);
        String[] stringArray = new String[2];
        if (n == -1) {
            stringArray[0] = "";
            stringArray[1] = string;
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        }
        return stringArray;
    }

    private static String[] getStringArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";, ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public String getClasses() {
        return this.classes;
    }

    public void setClasses(String string) {
        this.classes = string;
    }

    public String getTargetJar() {
        return this.targetJar;
    }

    public void setTargetJar(String string) {
        this.targetJar = string;
    }

    public boolean getResolveFiltered() {
        return this.resolveFiltered;
    }

    public void setResolveFiltered(boolean bl) {
        this.resolveFiltered = bl;
    }

    public String getExcludePkg() {
        return this.excludePkg;
    }

    public void setExcludePkg(String string) {
        this.excludePkg = string;
    }

    public Path createClassPath() {
        if (this.cPath == null) {
            this.cPath = new Path(this.getProject());
        }
        return this.cPath;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public String getManifestClassPath() {
        return this.manifestClassPath;
    }

    public String getManifestMainClass() {
        return this.manifestMainClass;
    }

    public void setManifestClassPath(String string) {
        this.manifestClassPath = string;
    }

    public void setManifestMainClass(String string) {
        this.manifestMainClass = string;
    }

    public String getIncludePkg() {
        return this.includePkg;
    }

    public void setIncludePkg(String string) {
        this.includePkg = string;
    }

    public void addAdditionalFileSet(FileSet fileSet) {
        this.additionalFiles.add(fileSet);
    }

    public ClassSpec createAdditionalClass() {
        ClassSpec classSpec = new ClassSpec();
        this.additionalClasses.add(classSpec);
        return classSpec;
    }

    public ClassSpec createIgnoreClass() {
        ClassSpec classSpec = new ClassSpec();
        this.ignorableClasses.add(classSpec);
        return classSpec;
    }

    public Resource createResource() {
        Resource resource = new Resource();
        this.resources.add(resource);
        return resource;
    }

    public boolean isCacheClassFiles() {
        return this.cacheClassFiles;
    }

    public void setCacheClassFiles(boolean bl) {
        this.cacheClassFiles = bl;
    }

    public String getPackages() {
        return this.packages;
    }

    public void setPackages(String string) {
        this.packages = string;
    }

    static class PackagePrefixClassFilter
    implements ClassFilter {
        private String[] prefixes;
        private boolean accept;

        public PackagePrefixClassFilter(String[] stringArray, boolean bl) {
            this.prefixes = stringArray;
            this.accept = bl;
        }

        public boolean accept(String string, String string2, CPoolReader.classfile classfile2) {
            for (int i = 0; i < this.prefixes.length; ++i) {
                if (!string.startsWith(this.prefixes[i])) continue;
                return this.accept;
            }
            return !this.accept;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Filter ");
            stringBuffer.append(this.accept ? "includes" : "excludes");
            stringBuffer.append(" classes in packages whose name is prefixed with one of { ");
            for (int i = 0; i < this.prefixes.length; ++i) {
                stringBuffer.append(this.prefixes[i]);
                if (i >= this.prefixes.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    static interface ClassFilter {
        public boolean accept(String var1, String var2, CPoolReader.classfile var3);
    }
}

