/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.ant;

import com.deltax.util.JDK12ClassFileFinder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.sadun.util.Version;

public class BaseVersion
extends Task {
    protected String packageName = null;
    protected String versionClsPackageName;
    protected String versionFQClsName;
    protected File versionInfoPath = null;
    protected String versionSimpleClsName;
    protected static final String BUILD_NUMBER_PROPERTY_NAME = "last.build.number";
    protected boolean useExistingVersionClass = false;
    protected File versionObjectBinaryPath = new File(".");
    protected File versionObjectSourcePath = new File(".");

    public void execute() throws BuildException {
        if (this.packageName == null) {
            throw new BuildException("PackageName attribute missing");
        }
        if (this.versionInfoPath == null) {
            this.versionInfoPath = new File("." + this.packageName + ".versionInfo");
        }
        this.versionFQClsName = this.mkVersionClsName(this.packageName);
        this.versionClsPackageName = this.frontName(this.versionFQClsName);
        this.versionSimpleClsName = this.baseName(this.versionFQClsName);
        this.log("Version info path is " + this.versionInfoPath.getAbsolutePath());
    }

    protected String baseName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected String frontName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    protected String mkVersionClsName(String string) {
        return string + ".version.Version";
    }

    protected long computeLastBuildNumber() throws BuildException {
        Properties properties = this.getExistingBuildNumber();
        String string = properties.getProperty(BUILD_NUMBER_PROPERTY_NAME);
        if (string == null) {
            throw new BuildException("Missing last.build.number property in " + this.versionInfoPath.getAbsolutePath());
        }
        if (string.endsWith("L") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException(string + " is not a valid value for the " + BUILD_NUMBER_PROPERTY_NAME + " property in " + this.versionInfoPath);
        }
    }

    protected Version getExistingVersionObject() throws ClassNotFoundException {
        this.log("Attempting to load " + this.versionFQClsName);
        try {
            VClassLoader vClassLoader = new VClassLoader();
            Version version = (Version)vClassLoader.loadClass(this.versionFQClsName).newInstance();
            this.log("Existing version is [" + version.getFullDescription() + "]");
            return version;
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException("Could not instantiate existing " + this.versionFQClsName, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException("Could not access existing " + this.versionFQClsName, (Throwable)illegalAccessException);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties getExistingBuildNumber() {
        Properties properties = new Properties();
        if (this.useExistingVersionClass) {
            try {
                Version version = this.getExistingVersionObject();
                properties.put(BUILD_NUMBER_PROPERTY_NAME, "" + version.getBuildNumber());
                return properties;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log(this.versionFQClsName + " not found, using 0 as last build number");
                properties.put(BUILD_NUMBER_PROPERTY_NAME, "0");
            }
            return properties;
        }
        if (this.versionInfoPath.exists()) {
            this.log("Reading " + this.versionInfoPath.getAbsolutePath());
            InputStream inputStream = null;
            inputStream = new BufferedInputStream(new FileInputStream(this.versionInfoPath));
            properties.load(inputStream);
            Object var5_5 = null;
            if (inputStream == null) return properties;
            try {
                inputStream.close();
                return properties;
            }
            catch (IOException iOException) {
                this.log("Could not close input stream for " + this.versionInfoPath.getAbsolutePath(), 1);
            }
            return properties;
            {
                catch (IOException iOException) {
                    throw new BuildException("Cannot read " + this.versionInfoPath.getAbsolutePath(), (Throwable)iOException);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    this.log("Could not close input stream for " + this.versionInfoPath.getAbsolutePath(), 1);
                }
                throw throwable;
            }
        }
        this.log(this.versionInfoPath.getAbsolutePath() + " not found, using 0 as last build number");
        properties.put(BUILD_NUMBER_PROPERTY_NAME, "0");
        return properties;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public File getVersionInfoPath() {
        return this.versionInfoPath;
    }

    public File getVersionObjectBinaryPath() {
        return this.versionObjectBinaryPath;
    }

    public File getVersionObjectSourcePath() {
        return this.versionObjectSourcePath;
    }

    public void setVersionInfoPath(File file) {
        this.versionInfoPath = file;
    }

    public void setVersionObjectBinaryPath(File file) {
        this.versionObjectBinaryPath = file;
    }

    public void setVersionObjectSourcePath(File file) {
        this.versionObjectSourcePath = file;
    }

    protected class VClassLoader
    extends ClassLoader {
        private String classPath;

        VClassLoader(String string) {
            this.classPath = string;
        }

        VClassLoader() {
            this(System.getProperty("java.class.path"));
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            byte[] byArray;
            if (!string.equals(BaseVersion.this.versionFQClsName)) {
                return super.loadClass(string);
            }
            BaseVersion.this.log("Looking for " + string + " with class path " + this.classPath);
            JDK12ClassFileFinder jDK12ClassFileFinder = new JDK12ClassFileFinder(this.classPath);
            try {
                byArray = jDK12ClassFileFinder.getBytes(string);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("Could not load " + string, iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            return this.defineClass(string, byArray, 0, byArray.length);
        }
    }
}

