/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import com.deltax.util.SignatureAnalyzer;
import java.lang.reflect.Array;

public class TypeWrapper {
    public static Object wrap(byte by) {
        return new Byte(by);
    }

    public static Object wrap(short s) {
        return new Short(s);
    }

    public static Object wrap(int n) {
        return new Integer(n);
    }

    public static Object wrap(long l) {
        return new Long(l);
    }

    public static Object wrap(float f) {
        return new Float(f);
    }

    public static Object wrap(double d) {
        return new Double(d);
    }

    public static Object wrap(char c) {
        return new Character(c);
    }

    public static Object wrap(boolean bl) {
        return new Boolean(bl);
    }

    public static Object wrap(Object object) {
        Class<?> clazz;
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("wrap(Object) can be invoked only on arrays of primitive types");
        }
        Object[] objectArray = (Object[])object;
        Class<?> clazz2 = clazz = object.getClass().getComponentType();
        int n = 1;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            ++n;
        }
        if (!clazz2.isPrimitive()) {
            throw new IllegalArgumentException("wrap(Object) can be invoked only on arrays of primitive types");
        }
        return TypeWrapper.wrap0(objectArray, clazz, clazz2, n);
    }

    private static Object wrap0(Object[] objectArray, Class clazz, Class clazz2, int n) {
        Object[] objectArray2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            if (clazz.isArray()) {
                if (objectArray[i] == null) {
                    objectArray2[i] = null;
                    continue;
                }
                Object[] objectArray3 = (Object[])objectArray[i];
                objectArray2[i] = TypeWrapper.wrap0(objectArray3, clazz.getComponentType(), clazz2, n - 1);
                continue;
            }
            objectArray2 = (Object[])Array.newInstance(TypeWrapper.getWrapperClass(clazz2), 1);
            for (int j = 0; j < objectArray2.length; ++j) {
            }
        }
        return objectArray2;
    }

    private static int getArrayLength(Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Byte.TYPE) {
            return ((byte[])object).length;
        }
        if (clazz == Short.TYPE) {
            return ((short[])object).length;
        }
        if (clazz == Integer.TYPE) {
            return ((int[])object).length;
        }
        if (clazz == Long.TYPE) {
            return ((long[])object).length;
        }
        if (clazz == Float.TYPE) {
            return ((float[])object).length;
        }
        if (clazz == Double.TYPE) {
            return ((double[])object).length;
        }
        if (clazz == Character.TYPE) {
            return ((char[])object).length;
        }
        if (clazz == Boolean.TYPE) {
            return ((boolean[])object).length;
        }
        throw new IllegalArgumentException("getArrayLength() called over an array of nonprimitive types");
    }

    private static Object[] createWrapperArray(Class clazz, int n) {
        if (clazz == Byte.TYPE) {
            return new Byte[n];
        }
        if (clazz == Short.TYPE) {
            return new Short[n];
        }
        if (clazz == Integer.TYPE) {
            return new Integer[n];
        }
        if (clazz == Long.TYPE) {
            return new Long[n];
        }
        if (clazz == Float.TYPE) {
            return new Float[n];
        }
        if (clazz == Double.TYPE) {
            return new Double[n];
        }
        if (clazz == Character.TYPE) {
            return new Character[n];
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean[n];
        }
        throw new IllegalArgumentException("createWrapperArray() called over a nonprimitive type");
    }

    public static Class getWrapperClass(Class clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new IllegalArgumentException("getWrapper() called over a nonprimitive type");
    }

    public static Object wrapFromString(Class clazz, String string) {
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return new Byte(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return new Short(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return new Integer(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return new Long(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return new Float(string);
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return new Double(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                if (string.length() < 1) {
                    return null;
                }
                return new Character(string.charAt(0));
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return new Boolean(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' is not a correct representation for the type " + SignatureAnalyzer.getJavaTypeName(clazz));
        }
        throw new IllegalArgumentException("getWrapper() called over a nonprimitive type");
    }

    public static Class getUnwrappedPrimitiveType(Class clazz) {
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        throw new IllegalArgumentException(clazz + " is not a wrapper type");
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        try {
            TypeWrapper.getUnwrappedPrimitiveType(clazz);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isPrimitiveOrWrapper(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return TypeWrapper.isPrimitiveWrapper(clazz);
    }

    public static void main(String[] stringArray) {
        Integer[][] integerArray = (Integer[][])TypeWrapper.wrap(new int[][]{{2, 5}, {3, 6}});
    }

    public static boolean isConvertible(Class clazz, Class clazz2) {
        if (TypeWrapper.isPrimitiveWrapper(clazz)) {
            clazz = TypeWrapper.getUnwrappedPrimitiveType(clazz);
        }
        if (TypeWrapper.isPrimitiveWrapper(clazz2)) {
            clazz2 = TypeWrapper.getUnwrappedPrimitiveType(clazz2);
        }
        if (clazz == clazz2) {
            return true;
        }
        if (clazz2 == Short.TYPE) {
            if (clazz == Character.TYPE) {
                return true;
            }
            return clazz == Byte.TYPE;
        }
        if (clazz2 == Integer.TYPE) {
            return TypeWrapper.isConvertible(clazz, Short.TYPE);
        }
        if (clazz2 == Long.TYPE) {
            return TypeWrapper.isConvertible(clazz, Integer.TYPE);
        }
        if (clazz2 == Float.TYPE) {
            return TypeWrapper.isConvertible(clazz, Integer.TYPE);
        }
        if (clazz2 == Double.TYPE) {
            if (TypeWrapper.isConvertible(clazz, Long.TYPE)) {
                return true;
            }
            return TypeWrapper.isConvertible(clazz, Float.TYPE);
        }
        return false;
    }

    public static Object convertValue(Object object, Class clazz) {
        if (object == null) {
            return null;
        }
        if (object.getClass() == clazz) {
            return object;
        }
        if (object instanceof String) {
            return TypeWrapper.wrapFromString(clazz, (String)object);
        }
        if (clazz.isPrimitive() ? TypeWrapper.isConvertible(object.getClass(), TypeWrapper.getWrapperClass(clazz)) : TypeWrapper.isPrimitiveWrapper(clazz) && TypeWrapper.isConvertible(object.getClass(), TypeWrapper.getUnwrappedPrimitiveType(clazz))) {
            return object;
        }
        throw new IllegalArgumentException("Don't know how to convert " + object + " (" + object.getClass().getName() + " to type " + clazz.getName());
    }
}

