/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class TieOutputStream
extends OutputStream {
    private OutputStream os1;
    private OutputStream os2;

    public TieOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        this.os1 = outputStream;
        this.os2 = outputStream2;
    }

    public void write(int n) throws IOException {
        this.os1.write(n);
        this.doCheckError(this.os1);
        this.os2.write(n);
        this.doCheckError(this.os2);
    }

    public void close() throws IOException {
        this.os1.close();
        this.doCheckError(this.os1);
        this.os2.close();
        this.doCheckError(this.os2);
    }

    public void flush() throws IOException {
        this.os1.flush();
        this.doCheckError(this.os1);
        this.os2.flush();
        this.doCheckError(this.os2);
    }

    public OutputStream getFirstWriter() {
        return this.os1;
    }

    public OutputStream getSecondWriter() {
        return this.os2;
    }

    private void doCheckError(OutputStream outputStream) throws IOException {
        if (outputStream instanceof PrintStream && ((PrintStream)outputStream).checkError()) {
            throw new IOException("Operation on printwriter failed");
        }
    }
}

