/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

public class TextProgressBar {
    public static final String ANSI = "ansi";
    private String terminalType;
    private int total;
    private int incPercentage = 10;
    private int progress;
    private int curPos;
    private int maxPos = 20;

    public TextProgressBar(String string) {
        this(string, 0);
    }

    public TextProgressBar(String string, int n) {
        if (!ANSI.equals(string)) {
            throw new UnsupportedOperationException("Terminal type " + string + " not supported");
        }
        this.terminalType = string;
        this.total = n;
    }

    public synchronized void inc(int n) {
        if (this.total == 0) {
            this.printPoints(n);
        } else {
            int n2 = (this.progress + n) / this.total % this.incPercentage;
            this.printPoints(n2);
        }
        this.progress += n;
    }

    public void inc() {
        this.inc(1);
    }

    private void printPoints(int n) {
        for (int i = 0; i < n; ++i) {
            if (this.curPos >= this.maxPos) {
                this.cursorBack(this.curPos);
                this.curPos = 0;
            }
            ++this.curPos;
            System.out.print(".");
        }
    }

    private void cursorBack(int n) {
        if (ANSI.equals(this.terminalType)) {
            this.escape(String.valueOf(n) + "D");
        }
    }

    private void escape(char[] cArray) {
        char[] cArray2 = new char[cArray.length + 2];
        System.arraycopy(cArray, 0, cArray2, 2, cArray.length);
        cArray2[0] = 27;
        cArray2[1] = 91;
        System.out.print(cArray2);
    }

    private void escape(String string) {
        this.escape(string.toCharArray());
    }

    public static void main(String[] stringArray) throws InterruptedException {
        TextProgressBar textProgressBar = new TextProgressBar(ANSI);
        for (int i = 0; i < 50; ++i) {
            textProgressBar.inc();
            Thread.sleep(100L);
        }
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int n) {
        this.total = n;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int n) {
        this.progress = n;
    }
}

