/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sadun.util.PrintStringWriter;

public class SymbolTable {
    protected Map symbolTable;
    protected BitSet options = new BitSet();
    protected char symbolMarker = (char)36;
    protected char[] bracketPair = new char[]{'(', ')'};
    private String symbolDefSequence = this.symbolMarker + String.valueOf(this.bracketPair[0]);
    private String symbolEndSequence = String.valueOf(this.bracketPair[1]);
    private static final int NORMAL = 0;
    private static final int MARKERFOUND = 1;
    private static final int SEARCHMATCHINGBRACE = 2;
    private Set undefinedSymbols = new HashSet();
    public static final int FAIL_ON_UNDEFINED_SYMBOL = 0;
    public static final int RETURN_BLANK_ON_UNDEFINED_SYMBOL = 1;
    public static final int RETURN_SYMBOL_ON_UNDEFINED_SYMBOL = 2;
    public static final int EVALUATE_SYMBOL_VALUES = 4;

    public SymbolTable(Map map, int n) {
        this.symbolTable = map;
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Internal error: failureBehaviour must be an integer comprised between 0 and 2");
        }
        this.options.clear(0);
        this.options.clear(1);
        this.options.clear(2);
        this.options.set(4);
        this.options.set(n);
    }

    public SymbolTable(Map map) {
        this(map, 0);
    }

    public SymbolTable() {
        this(new HashMap());
    }

    public synchronized void defineSymbol(String string, Object object) {
        if (string.startsWith(this.symbolDefSequence) && string.endsWith(this.symbolEndSequence)) {
            string = string.substring(2, string.length() - 1);
        }
        this.symbolTable.put(string, object);
    }

    public synchronized Object getValue(String string) {
        return this.symbolTable.get(string);
    }

    public synchronized String getStringValue(String string) {
        Object v = this.symbolTable.get(string);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public boolean isDefined(String string) {
        if (string.startsWith(this.symbolDefSequence) && string.endsWith(this.symbolEndSequence)) {
            string = string.substring(2, string.length() - 1);
        }
        return this.symbolTable.containsKey(string);
    }

    public synchronized String evaluate(String string) {
        this.undefinedSymbols.clear();
        return this.evaluate0(string, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String evaluate0(String string, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            block8: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (n) {
                    case 0: {
                        if (c == this.symbolMarker) {
                            n = 1;
                            continue block8;
                        }
                        stringBuffer.append(c);
                        continue block8;
                    }
                    case 1: {
                        if (c == this.symbolMarker) {
                            stringBuffer.append(this.symbolMarker);
                            n = 0;
                            continue block8;
                        }
                        if (c == this.bracketPair[0]) {
                            n2 = i;
                            n4 = 1;
                            n = 2;
                            continue block8;
                        }
                        throw new IllegalArgumentException("'" + this.symbolMarker + "' can be followed only by '" + this.symbolMarker + "' or '" + this.bracketPair[0] + "' : " + string.substring(i - 1));
                    }
                    case 2: {
                        if (string.charAt(i) == this.bracketPair[0]) {
                            ++n4;
                            continue block8;
                        }
                        if (string.charAt(i) != this.bracketPair[1] || --n4 != 0) continue block8;
                        n3 = i;
                        String string2 = string.substring(n2 + 1, n3);
                        if (list.contains(string2)) {
                            throw new RuntimeException("Recursive definition: symbol " + string2 + " is defined in terms of itself");
                        }
                        list.add(string2);
                        String string3 = this.getStringValue(string2);
                        if (string3 == null) {
                            if (this.options.get(0)) {
                                throw new UndefinedSymbolException(string2, "Symbol " + this.symbolDefSequence + string2 + this.symbolEndSequence + " is not defined");
                            }
                            if (this.options.get(2)) {
                                string3 = this.symbolDefSequence + string2 + this.symbolEndSequence;
                                this.undefinedSymbols.add(string2);
                            } else if (this.options.get(1)) {
                                string3 = "";
                            }
                            stringBuffer.append(string3);
                        } else if (this.options.get(4)) {
                            stringBuffer.append(this.evaluate0(string3, list));
                        } else {
                            stringBuffer.append(string3);
                        }
                        if (list.size() > 0) {
                            list.remove(list.size() - 1);
                        }
                        i = n3;
                        n = 0;
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public synchronized void setBehaviourOnUndefinedSymbol(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Internal error: failureBehaviour must be an integer comprised between 0 and 2");
        }
        this.options.clear(0);
        this.options.clear(1);
        this.options.clear(2);
        this.options.set(n);
    }

    public int setBehaviourOnUndefinedSymbol() {
        int n = -1;
        if (this.options.get(0)) {
            n = 0;
        } else if (this.options.get(1)) {
            n = 1;
        } else if (this.options.get(2)) {
            n = 2;
        }
        return n;
    }

    public char getSymbolMarker() {
        return this.symbolMarker;
    }

    public void setSymbolMarker(char c) {
        this.symbolMarker = c;
    }

    public synchronized char[] getBracketPair() {
        return new char[]{this.bracketPair[0], this.bracketPair[1]};
    }

    public synchronized void setBracketPair(char[] cArray) {
        if (cArray.length != 2) {
            throw new IllegalArgumentException("bracket pair must be a char[2] array");
        }
        if (cArray[0] == cArray[1]) {
            throw new IllegalArgumentException("bracket pair array must contain 2 different characters");
        }
        this.bracketPair = cArray;
        this.symbolDefSequence = this.symbolMarker + String.valueOf(cArray[0]);
        this.symbolEndSequence = String.valueOf(cArray[1]);
    }

    public boolean isEvaluateSymbolValues() {
        return this.options.get(4);
    }

    public void setEvaluateSymbolValues(boolean bl) {
        if (bl) {
            this.options.set(4);
        } else {
            this.options.clear(4);
        }
    }

    public Set getUndefinedSymbolsForLastEvaluation() {
        if (!this.options.get(2)) {
            return null;
        }
        return this.undefinedSymbols;
    }

    public Iterator definedSymbols() {
        return this.symbolTable.keySet().iterator();
    }

    public String toString() {
        PrintStringWriter printStringWriter = new PrintStringWriter();
        Iterator iterator = this.definedSymbols();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.symbolTable.get(string);
            printStringWriter.print(string);
            printStringWriter.print(": ");
            printStringWriter.print(string2);
            if (!iterator.hasNext()) continue;
            printStringWriter.print(", ");
        }
        return printStringWriter.toString();
    }

    public class UndefinedSymbolException
    extends IllegalArgumentException {
        private String symbolName;

        UndefinedSymbolException(String string, String string2) {
            super(string2);
            this.symbolName = string;
        }

        public String getSymbolName() {
            return this.symbolName;
        }
    }
}

