/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import com.deltax.util.CPoolReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.sadun.util.ClassPackageExplorer;
import org.sadun.util.ClassPathIterator;
import org.sadun.util.DirectoryFileFilter;
import org.sadun.util.ExtensionFileFilter;
import org.sadun.util.ObjectLister;
import org.sadun.util.sis.StateInfoSupport;

public class SimpleClassPackageExplorer
implements ClassPackageExplorer {
    private String classPath;
    private Pattern[] dirPatterns;
    private StateInfoSupport sis;
    private CPoolReader cpr;
    private boolean errorOccurred;
    private Set listeners = new HashSet();
    private Map filesPerPackage;
    private Map packageStatus;
    private Map classesPerPackage;
    private Map filesPerClass;
    private static FileFilter classFileFilter = new ExtensionFileFilter("class");
    private static FileFilter dirFileFilter = new DirectoryFileFilter();

    public SimpleClassPackageExplorer() {
        this(System.getProperty("java.class.path"));
    }

    public SimpleClassPackageExplorer(String string) {
        this(string, new String[]{".*"});
        this.cpr = new CPoolReader(string);
    }

    public SimpleClassPackageExplorer(String string, String[] stringArray) {
        this.classPath = string;
        this.dirPatterns = new Pattern[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.dirPatterns[i] = Pattern.compile(stringArray[i]);
        }
    }

    public String[] listPackage(String string) {
        return this.listPackage(string, 3);
    }

    public String[] listPackageNames() {
        return this.listPackageNames(false);
    }

    private void buildInfo() {
        this.sis = new StateInfoSupport();
        this.filesPerPackage = new HashMap();
        this.packageStatus = new HashMap();
        this.classesPerPackage = new HashMap();
        this.errorOccurred = false;
        ClassPathIterator classPathIterator = new ClassPathIterator(this.classPath);
        while (classPathIterator.hasNext()) {
            File file = classPathIterator.nextEntryFile();
            if (classPathIterator.isJar()) {
                this.scanJarFile(file);
                continue;
            }
            this.scanDirectory(file);
        }
    }

    private void scanDirectory(File file) {
        boolean bl = false;
        for (int i = 0; i < this.dirPatterns.length; ++i) {
            if (!this.dirPatterns[i].matcher(file.getName()).matches()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        File[] fileArray = file.listFiles(classFileFilter);
        if (fileArray == null) {
            return;
        }
        this.notifyScanStart(file, false);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                this.processFile(file, false, new BufferedInputStream(new FileInputStream(fileArray[i])));
                continue;
            }
            catch (IOException iOException) {
                this.sis.addEntry("Could not open/process class file " + fileArray[i].getAbsolutePath());
                this.errorOccurred = true;
            }
        }
        File[] fileArray2 = file.listFiles(dirFileFilter);
        for (int i = 0; i < fileArray2.length; ++i) {
            this.scanDirectory(fileArray2[i]);
        }
        this.notifyScanEnd(file, false);
    }

    private void scanJarFile(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            this.notifyScanStart(file, true);
            while (enumeration.hasMoreElements()) {
                String string;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !(string = jarEntry.getName()).endsWith(".class")) continue;
                this.processFile(file, true, new BufferedInputStream(jarFile.getInputStream(jarEntry)));
            }
            this.notifyScanEnd(file, true);
        }
        catch (IOException iOException) {
            this.sis.addEntry("Scanning Jar file", "Could not open/process jar file \"" + file + "\"", iOException);
            this.errorOccurred = true;
        }
    }

    private void processFile(File file, boolean bl, InputStream inputStream) throws IOException {
        CPoolReader.classfile classfile2 = this.cpr.readClassData(inputStream);
        String string = classfile2.getCPClassName(true);
        String string2 = this.getPkgName(string);
        ArrayList<File> arrayList = (ArrayList<File>)this.filesPerPackage.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList<File>();
            this.filesPerPackage.put(string2, arrayList);
        }
        arrayList.add(file);
        Integer n = (Integer)this.packageStatus.get(string2);
        if (n == null) {
            n = new Integer(0);
            this.packageStatus.put(string2, n);
        }
        Integer n2 = new Integer(n | (bl ? 1 : 0));
        this.packageStatus.put(string2, n);
        ArrayList<String> arrayList2 = (ArrayList<String>)this.classesPerPackage.get(string2);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList<String>();
            this.classesPerPackage.put(string2, arrayList2);
        }
        arrayList2.add(string);
        this.notifyFileProcessing(file, string);
    }

    private String getPkgName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getClassPath() {
        return this.classPath;
    }

    public synchronized File[] getPackageFiles(String string) {
        List list = (List)this.filesPerPackage.get(string);
        if (list == null) {
            return new File[0];
        }
        File[] fileArray = new File[list.size()];
        list.toArray(fileArray);
        return fileArray;
    }

    public synchronized int getStatus(String string) {
        Integer n = (Integer)this.packageStatus.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public synchronized String[] listPackage(String string, int n) {
        List list;
        if (n != 3) {
            throw new UnsupportedOperationException("Disaggregation by status not supported yet");
        }
        if (this.classesPerPackage == null) {
            this.buildInfo();
        }
        if ((list = (List)this.classesPerPackage.get(string)) == null) {
            return new String[0];
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    public synchronized String[] listPackageNames(boolean bl) {
        if (bl || this.classesPerPackage == null) {
            this.buildInfo();
        }
        String[] stringArray = new String[this.classesPerPackage.keySet().size()];
        this.classesPerPackage.keySet().toArray(stringArray);
        return stringArray;
    }

    public synchronized void setClassPath(String string) {
        this.classPath = string;
        this.buildInfo();
    }

    public synchronized String getErrorLog() {
        if (this.sis == null) {
            this.buildInfo();
        }
        return this.sis.getStateDescription(null);
    }

    public synchronized boolean hasErrorOccurred() {
        if (this.sis == null) {
            this.buildInfo();
        }
        return this.errorOccurred;
    }

    public void addExplorationListener(PackageExplorationListener packageExplorationListener) {
        this.listeners.add(packageExplorationListener);
    }

    public void removeExplorationListener(PackageExplorationListener packageExplorationListener) {
        this.listeners.remove(packageExplorationListener);
    }

    private void notifyScanStart(File file, boolean bl) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PackageExplorationListener packageExplorationListener = (PackageExplorationListener)iterator.next();
            packageExplorationListener.scanStart(file, bl);
        }
    }

    private void notifyScanEnd(File file, boolean bl) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PackageExplorationListener packageExplorationListener = (PackageExplorationListener)iterator.next();
            packageExplorationListener.scanEnd(file, bl);
        }
    }

    private void notifyFileProcessing(File file, String string) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PackageExplorationListener packageExplorationListener = (PackageExplorationListener)iterator.next();
            packageExplorationListener.processingFile(file, string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleClassPackageExplorer simpleClassPackageExplorer = new SimpleClassPackageExplorer("c:\\projects\\jutil\\org.sadun.util.jar");
        Object[] objectArray = simpleClassPackageExplorer.listPackageNames();
        System.out.println(ObjectLister.getInstance().list(objectArray));
        if (objectArray.length > 0) {
            System.out.println(ObjectLister.getInstance().list(simpleClassPackageExplorer.listPackage((String)objectArray[0])));
        }
        System.out.println(simpleClassPackageExplorer.sis.getStateDescription(null));
    }

    public static class PackageExplorationAdapter
    implements PackageExplorationListener {
        public void processingFile(File file, String string) {
        }

        public void scanEnd(File file, boolean bl) {
        }

        public void scanStart(File file, boolean bl) {
        }
    }

    public static interface PackageExplorationListener {
        public void scanStart(File var1, boolean var2);

        public void scanEnd(File var1, boolean var2);

        public void processingFile(File var1, String var2);
    }
}

