/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sadun.util.Broadcaster;
import org.sadun.util.NullIterator;

public class SequentialUniqueIdGenerator {
    private static Map instances = new HashMap();
    private IdStorage idStorage;
    private Iterator currentBlock = new NullIterator();
    private Broadcaster failureBroadcaster;

    public SequentialUniqueIdGenerator(IdStorage idStorage) {
        this.idStorage = idStorage;
    }

    protected SequentialUniqueIdGenerator() {
    }

    /*
     * Loose catch block
     */
    public synchronized String getNextId() throws IdStorage.IdStorageException {
        block12: {
            if (this.idStorage == null) {
                throw new IllegalStateException("No " + IdStorage.class.getName() + " setup. Please invoke setIdStorage().");
            }
            if (!this.currentBlock.hasNext()) {
                this.idStorage.lock();
                this.currentBlock = this.idStorage.getNextIdBlock();
                Object var3_1 = null;
                try {
                    this.idStorage.unlock();
                }
                catch (IdStorage.IdStorageException idStorageException) {
                    if (this.failureBroadcaster == null) break block12;
                    try {
                        this.failureBroadcaster.broadCast(new CannotUnlockStorageException((Throwable)idStorageException));
                        break block12;
                    }
                    catch (Broadcaster.BroadcastingException broadcastingException) {
                        System.err.println("Warining! Could not broadcast an unlocking problem with the IdStorage. Deadlocks might occur in other processes.");
                    }
                }
                break block12;
                {
                    catch (IdStorage.IdStorageException idStorageException) {
                        this.currentBlock = new NullIterator();
                        throw idStorageException;
                    }
                }
                catch (Throwable throwable) {
                    block13: {
                        Object var3_2 = null;
                        try {
                            this.idStorage.unlock();
                        }
                        catch (IdStorage.IdStorageException idStorageException) {
                            if (this.failureBroadcaster == null) break block13;
                            try {
                                this.failureBroadcaster.broadCast(new CannotUnlockStorageException((Throwable)idStorageException));
                            }
                            catch (Broadcaster.BroadcastingException broadcastingException) {
                                System.err.println("Warining! Could not broadcast an unlocking problem with the IdStorage. Deadlocks might occur in other processes.");
                            }
                        }
                    }
                    throw throwable;
                }
            }
        }
        return this.currentBlock.next().toString();
    }

    protected void setIdStorage(IdStorage idStorage) {
        if (idStorage != null) {
            throw new IllegalStateException("The id storage can be initialized only once.");
        }
        this.idStorage = idStorage;
    }

    public Broadcaster getFailureBroadcaster() {
        return this.failureBroadcaster;
    }

    public void setFailureBroadcaster(Broadcaster broadcaster) {
        if (broadcaster == null && this.failureBroadcaster != null) {
            try {
                this.failureBroadcaster.dispose();
            }
            catch (Broadcaster.BroadcastingException broadcastingException) {
                System.err.println("Warning: the current broadcaster object " + broadcaster + " could not be disposed");
            }
        }
        this.failureBroadcaster = broadcaster;
    }

    public static interface IdStorage {
        public void lock() throws IdStorageException;

        public Iterator getNextIdBlock() throws IdStorageException, IllegalStateException;

        public void unlock() throws IdStorageException;

        public static class IdStorageException
        extends Exception {
            public IdStorageException(Throwable throwable) {
                super(throwable);
            }
        }
    }

    private class CannotUnlockStorageException
    extends IdStorage.IdStorageException {
        public CannotUnlockStorageException(Throwable throwable) {
            super(throwable);
        }
    }
}

