/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.util.logging.Logger;

public class RotationalCharBuffer {
    private char[] buffer;
    private int pos = 0;
    private boolean modified = true;
    private String lastImage = null;

    public RotationalCharBuffer(int n) {
        this.buffer = new char[n];
    }

    public void addToRight(char c) {
        this.buffer[this.pos++] = c;
        if (this.pos == this.buffer.length) {
            this.pos = 0;
        }
        this.modified = true;
    }

    public void addToRight(String string) {
        if (string.length() == 1) {
            Logger.getAnonymousLogger().fine("addToRight(String) invoked with 1-length string, use addToRight(char) for better performance");
        }
        for (int i = 0; i < string.length(); ++i) {
            this.addToRight(string.charAt(i));
        }
    }

    public void addToLeft(char c) {
        --this.pos;
        if (this.pos == -1) {
            this.pos = this.buffer.length - 1;
        }
        this.buffer[this.pos] = c;
        this.modified = true;
    }

    public void addToLeft(String string) {
        if (string.length() == 1) {
            Logger.getAnonymousLogger().fine("addToRight(String) invoked with 1-length string, use addToRight(char) for better performance");
        }
        for (int i = 0; i < string.length(); ++i) {
            this.addToLeft(string.charAt(i));
        }
    }

    private void printBuffer() {
        System.out.print("BUFFER: ");
        for (int i = 0; i < this.buffer.length; ++i) {
            if (i == this.pos) {
                System.out.print("*");
            }
            if (this.buffer[i] == '\u0000') {
                System.out.print("#");
            } else {
                System.out.print(this.buffer[i]);
            }
            System.out.print(" ");
        }
        System.out.println();
    }

    public int size() {
        return this.buffer.length;
    }

    public String toString() {
        int n;
        if (!this.modified) {
            return this.lastImage;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = this.pos; n < this.buffer.length; ++n) {
            if (this.buffer[n] == '\u0000') continue;
            stringBuffer.append(this.buffer[n]);
        }
        for (n = 0; n < this.pos; ++n) {
            if (this.buffer[n] == '\u0000') continue;
            stringBuffer.append(this.buffer[n]);
        }
        this.lastImage = stringBuffer.toString();
        this.modified = true;
        return this.lastImage;
    }

    public boolean equals(Object object) {
        if (object instanceof RotationalCharBuffer) {
            RotationalCharBuffer rotationalCharBuffer = (RotationalCharBuffer)object;
            return rotationalCharBuffer.toString().equals(this.toString()) && rotationalCharBuffer.pos == this.pos;
        }
        if (object instanceof char[]) {
            return new String((char[])object).equals(this.toString());
        }
        if (object instanceof CharSequence) {
            return ((Object)((CharSequence)object)).toString().equals(this.toString());
        }
        return false;
    }
}

