/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import junit.framework.TestCase;
import org.sadun.util.QuoteAwareStringTokenizer;

public class QuoteAwareStringTokenizerTest
extends TestCase {
    private QuoteAwareStringTokenizer createTokenizer(boolean bl) {
        String string = "'q0\\''  t (q1)";
        QuoteAwareStringTokenizer quoteAwareStringTokenizer = new QuoteAwareStringTokenizer(string, " ", "''()", bl);
        return quoteAwareStringTokenizer;
    }

    private QuoteAwareStringTokenizer createTokenizer() {
        return this.createTokenizer(false);
    }

    public void testCountTokens() {
        QuoteAwareStringTokenizer quoteAwareStringTokenizer = this.createTokenizer();
        QuoteAwareStringTokenizerTest.assertEquals((int)3, (int)quoteAwareStringTokenizer.countTokens());
    }

    public void testUseNoDelim() {
        QuoteAwareStringTokenizer quoteAwareStringTokenizer = this.createTokenizer();
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("q0'"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("t"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("q1"));
    }

    public void testUseDelim() {
        QuoteAwareStringTokenizer quoteAwareStringTokenizer = this.createTokenizer(true);
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("q0'"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals(" "));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals(" "));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("t"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals(" "));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("q1"));
    }

    public void testNoQuotes1() {
        String string = "'q0\\''  t (q1)";
        QuoteAwareStringTokenizer quoteAwareStringTokenizer = new QuoteAwareStringTokenizer(string, " ", "");
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("'q0\\''"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("t"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("(q1)"));
    }

    public void testNoQuotes2() {
        String string = "a,b,c";
        QuoteAwareStringTokenizer quoteAwareStringTokenizer = new QuoteAwareStringTokenizer(string, ",", "");
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("a"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("b"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("c"));
    }

    public void testNoQuotes3() {
        String string = "a,b,c,";
        QuoteAwareStringTokenizer quoteAwareStringTokenizer = new QuoteAwareStringTokenizer(string, ",", "");
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("a"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("b"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextToken().equals("c"));
    }

    public void testEnumeration() {
        String string = "a,b,c";
        QuoteAwareStringTokenizer quoteAwareStringTokenizer = new QuoteAwareStringTokenizer(string, ",", "");
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextElement().equals("a"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextElement().equals("b"));
        QuoteAwareStringTokenizerTest.assertTrue((boolean)quoteAwareStringTokenizer.nextElement().equals("c"));
    }

    public void testNextToken() {
        String string = "a,b 'c'";
        QuoteAwareStringTokenizer quoteAwareStringTokenizer = new QuoteAwareStringTokenizer(string, ",");
        QuoteAwareStringTokenizerTest.assertEquals((String)"a", (String)quoteAwareStringTokenizer.nextToken());
        QuoteAwareStringTokenizerTest.assertEquals((String)"b", (String)quoteAwareStringTokenizer.nextToken(" "));
    }
}

