/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.sadun.util.IndentedPrintWriter;
import org.sadun.util.TypeWrapper;

public class ObjectPropertyManager
implements Serializable {
    private transient Map pDescByName;
    private Object targetObject;
    private boolean shortForm = true;
    private boolean showType = false;

    public ObjectPropertyManager(Object object) {
        this.targetObject = object;
    }

    public void setProperties(Properties properties) throws IntrospectionException, NoSuchPropertyException {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            this.setProperty(string, string2);
        }
    }

    public void setProperty(String string, byte by) throws IntrospectionException, NoSuchPropertyException {
        this.setProperty(string, new Byte(by));
    }

    public void setProperty(String string, short s) throws IntrospectionException, NoSuchPropertyException {
        this.setProperty(string, new Short(s));
    }

    public void setProperty(String string, int n) throws IntrospectionException, NoSuchPropertyException {
        this.setProperty(string, new Integer(n));
    }

    public void setProperty(String string, long l) throws IntrospectionException, NoSuchPropertyException {
        this.setProperty(string, new Long(l));
    }

    public void setProperty(String string, char c) throws IntrospectionException, NoSuchPropertyException {
        this.setProperty(string, new Character(c));
    }

    public void setProperty(String string, float f) throws IntrospectionException, NoSuchPropertyException {
        this.setProperty(string, new Float(f));
    }

    public void setProperty(String string, double d) throws IntrospectionException, NoSuchPropertyException {
        this.setProperty(string, new Double(d));
    }

    public void setProperty(String string, boolean bl) throws IntrospectionException, NoSuchPropertyException {
        this.setProperty(string, new Boolean(bl));
    }

    public void setProperty(String string, Object object) throws IntrospectionException, NoSuchPropertyException {
        try {
            Method method = this.getWriteMethod(string);
            Object object2 = TypeWrapper.convertValue(object, method.getParameterTypes()[0]);
            method.invoke(this.targetObject, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchPropertyException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchPropertyException(invocationTargetException);
        }
    }

    public Object getProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Method method = this.getReadMethod(string);
        try {
            return method.invoke(this.targetObject, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IntrospectionException("(reading " + string + ") " + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IntrospectionException("(reading " + string + ") " + invocationTargetException.getMessage());
        }
    }

    private Method getWriteMethod(String string) throws IntrospectionException, NoSuchPropertyException {
        this.initPDMap();
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.pDescByName.get(string);
        if (propertyDescriptor == null) {
            throw new NoSuchPropertyException("There is no writable property '" + string + "' in this targetObject");
        }
        return propertyDescriptor.getWriteMethod();
    }

    private Method getReadMethod(String string) throws IntrospectionException, NoSuchPropertyException {
        this.initPDMap();
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.pDescByName.get(string);
        if (propertyDescriptor == null) {
            throw new NoSuchPropertyException("There is no readable property '" + string + "' in this targetObject");
        }
        return propertyDescriptor.getReadMethod();
    }

    public String[] getPropertyNames(boolean bl, boolean bl2) throws IntrospectionException {
        this.initPDMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.pDescByName.keySet().iterator();
        while (stringArray.hasNext()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.pDescByName.get(stringArray.next());
            if (bl && propertyDescriptor.getWriteMethod() == null || bl2 && propertyDescriptor.getReadMethod() == null) continue;
            arrayList.add(propertyDescriptor.getName());
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getPropertyNames() throws IntrospectionException {
        return this.getPropertyNames(true, true);
    }

    private void initPDMap() throws IntrospectionException {
        if (this.pDescByName == null) {
            this.pDescByName = new HashMap();
        }
        if (this.pDescByName.size() > 0) {
            return;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(this.targetObject.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            this.pDescByName.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
        }
    }

    public boolean getBooleanProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Object object = this.getProperty(string);
        if (!TypeWrapper.isConvertible(object.getClass(), Boolean.TYPE)) {
            throw new NoSuchPropertyException("There is no boolean property '" + string + "' (but a property with type '" + object.getClass().getName() + "' does exist)");
        }
        if (TypeWrapper.isPrimitiveWrapper(object.getClass())) {
            return (Boolean)object;
        }
        return Boolean.getBoolean(object.toString());
    }

    public byte getByteProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Object object = this.getProperty(string);
        if (!TypeWrapper.isConvertible(object.getClass(), Byte.TYPE)) {
            throw new NoSuchPropertyException("There is no byte property '" + string + "' (but a property with type '" + object.getClass().getName() + "' does exist)");
        }
        if (TypeWrapper.isPrimitiveWrapper(object.getClass())) {
            return ((Number)object).byteValue();
        }
        return Byte.decode(object.toString());
    }

    public short getShortProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Object object = this.getProperty(string);
        if (!TypeWrapper.isConvertible(object.getClass(), Short.TYPE)) {
            throw new NoSuchPropertyException("There is no short property '" + string + "' (but a property with type '" + object.getClass().getName() + "' does exist)");
        }
        if (TypeWrapper.isPrimitiveWrapper(object.getClass())) {
            return ((Number)object).shortValue();
        }
        return Short.decode(object.toString());
    }

    public int getIntProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Object object = this.getProperty(string);
        if (!TypeWrapper.isConvertible(object.getClass(), Integer.TYPE)) {
            throw new NoSuchPropertyException("There is no int property '" + string + "' (but a property with type '" + object.getClass().getName() + "' does exist)");
        }
        if (TypeWrapper.isPrimitiveWrapper(object.getClass())) {
            return ((Number)object).intValue();
        }
        return Integer.decode(object.toString());
    }

    public long getLongProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Object object = this.getProperty(string);
        if (!TypeWrapper.isConvertible(object.getClass(), Long.TYPE)) {
            throw new NoSuchPropertyException("There is no long property '" + string + "' (but a property with type '" + object.getClass().getName() + "' does exist)");
        }
        if (TypeWrapper.isPrimitiveWrapper(object.getClass())) {
            return ((Number)object).longValue();
        }
        return Long.decode(object.toString());
    }

    public float getFloatProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Object object = this.getProperty(string);
        if (!TypeWrapper.isConvertible(object.getClass(), Float.TYPE)) {
            throw new NoSuchPropertyException("There is no float property '" + string + "' (but a property with type '" + object.getClass().getName() + "' does exist)");
        }
        if (TypeWrapper.isPrimitiveWrapper(object.getClass())) {
            return ((Number)object).floatValue();
        }
        return Float.valueOf(object.toString()).floatValue();
    }

    public double getDoubleProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Object object = this.getProperty(string);
        if (!TypeWrapper.isConvertible(object.getClass(), Double.TYPE)) {
            throw new NoSuchPropertyException("There is no double property '" + string + "' (but a property with type '" + object.getClass().getName() + "' does exist)");
        }
        if (TypeWrapper.isPrimitiveWrapper(object.getClass())) {
            return ((Number)object).doubleValue();
        }
        return Double.valueOf(object.toString());
    }

    public String getStringProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Object object = this.getProperty(string);
        if (!(object instanceof String)) {
            throw new NoSuchPropertyException("There is no String property '" + string + "' (but a property with type '" + object.getClass().getName() + "' does exist)");
        }
        return (String)object;
    }

    public char getCharProperty(String string) throws IntrospectionException, NoSuchPropertyException {
        Object object = this.getProperty(string);
        if (!(object instanceof Character)) {
            throw new NoSuchPropertyException("There is no char property '" + string + "' (but a property with type '" + object.getClass().getName() + "' does exist)");
        }
        return ((Character)object).charValue();
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public String describe() throws IntrospectionException {
        return this.describe(0, false);
    }

    public String describe(boolean bl) throws IntrospectionException {
        return this.describe(0, bl);
    }

    public String describe(int n) throws IntrospectionException {
        return this.describe(n, false);
    }

    public String describe(int n, boolean bl) throws IntrospectionException {
        String[] stringArray = this.getPropertyNames();
        StringWriter stringWriter = new StringWriter();
        IndentedPrintWriter indentedPrintWriter = new IndentedPrintWriter(stringWriter);
        indentedPrintWriter.setIndentation(n);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string;
                Object object;
                if (bl) {
                    object = this.getProperty(stringArray[i]);
                    string = object == null ? ((PropertyDescriptor)this.pDescByName.get(stringArray[i])).getPropertyType().getName() : object.getClass().getName();
                    if (this.shortForm && string.lastIndexOf(46) != -1) {
                        string = string.substring(string.lastIndexOf(46) + 1);
                    }
                    indentedPrintWriter.print((this.showType ? string + " " : "") + stringArray[i] + ": ");
                    indentedPrintWriter.incIndentation(3);
                    if (object != null) {
                        if (!TypeWrapper.isPrimitiveOrWrapper(object.getClass())) {
                            if (object instanceof String) {
                                indentedPrintWriter.print(this.describeString((String)object));
                            } else {
                                indentedPrintWriter.println();
                                indentedPrintWriter.incIndentation(1);
                                indentedPrintWriter.print(new ObjectPropertyManager(object).describe(bl));
                                indentedPrintWriter.decIndentation(1);
                            }
                        } else {
                            indentedPrintWriter.print(object);
                        }
                    } else {
                        indentedPrintWriter.print("null");
                    }
                    indentedPrintWriter.decIndentation(3);
                } else {
                    object = this.getProperty(stringArray[i]);
                    string = object == null ? ((PropertyDescriptor)this.pDescByName.get(stringArray[i])).getPropertyType().getName() : object.getClass().getName();
                    if (this.shortForm && string.lastIndexOf(46) != -1) {
                        string = string.substring(string.lastIndexOf(46) + 1);
                    }
                    indentedPrintWriter.print((this.showType ? string + " " : "") + stringArray[i] + ": " + object);
                }
                if (i >= stringArray.length - 1) continue;
                indentedPrintWriter.println();
                continue;
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                noSuchPropertyException.printStackTrace();
            }
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String describeString(String string) {
        StringBuffer stringBuffer = new StringBuffer("\"");
        int n = string.length();
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) == '\"') {
                    stringBuffer.append("\\\"");
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
    }

    public boolean isShortForm() {
        return this.shortForm;
    }

    public void setShortForm(boolean bl) {
        this.shortForm = bl;
    }

    public boolean isShowType() {
        return this.showType;
    }

    public void setShowType(boolean bl) {
        this.showType = bl;
    }

    public static String getDescription(Object object, int n, boolean bl, boolean bl2, boolean bl3) throws IntrospectionException {
        ObjectPropertyManager objectPropertyManager = new ObjectPropertyManager(object);
        objectPropertyManager.setShortForm(bl2);
        objectPropertyManager.setShowType(bl3);
        return objectPropertyManager.describe(n, bl);
    }

    public static final class NoSuchPropertyException
    extends Exception {
        private NoSuchPropertyException(String string) {
            super(string);
        }

        private NoSuchPropertyException(Throwable throwable) {
            super(throwable);
        }
    }
}

