/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.sadun.util.Cache;

public class ObjectLister {
    private static ObjectLister defaultInstance = new ObjectLister();
    private static ObjectLister defaultHTMLInstance = new ObjectLister("<br>", '\u0000');
    private String separator;
    private boolean useToStringIfNotFound;
    private boolean failOnUnaccessible = false;
    private boolean setAccessible = true;
    private char quoteChar = (char)34;
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final String DEFAULT_SEPARATOR = ", ";
    private Cache clsToMethodsCache = new Cache(3);

    public ObjectLister(String string, char c, boolean bl, boolean bl2) {
        this.separator = string;
        this.quoteChar = c;
        this.useToStringIfNotFound = bl;
        this.failOnUnaccessible = bl2;
    }

    public ObjectLister(String string, boolean bl, boolean bl2) {
        this(string, '\"', bl, bl2);
    }

    public ObjectLister(String string, boolean bl) {
        this(string, bl, false);
    }

    public ObjectLister(String string, char c, boolean bl) {
        this(string, c, bl, false);
    }

    public ObjectLister(boolean bl) {
        this(DEFAULT_SEPARATOR, bl);
    }

    public ObjectLister(String string) {
        this(string, true);
    }

    public ObjectLister(String string, char c) {
        this(string, c, true);
    }

    public ObjectLister() {
        this(DEFAULT_SEPARATOR);
    }

    public ObjectLister(char c) {
        this(DEFAULT_SEPARATOR, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String list(Object[] objectArray, String string) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            Object[] objectArray2 = new Object[]{};
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                try {
                    Method method = this.findMethod(objectArray[i], string);
                    if (this.setAccessible) {
                        method.setAccessible(true);
                    }
                    String string2 = (String)method.invoke(objectArray[i], objectArray2);
                    if (this.quoteChar != '\u0000') {
                        stringBuffer.append(this.quoteChar);
                    }
                    stringBuffer.append(string2);
                    if (this.quoteChar != '\u0000') {
                        stringBuffer.append(this.quoteChar);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (this.useToStringIfNotFound) {
                        stringBuffer.append(objectArray[i].toString());
                    }
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (this.useToStringIfNotFound) {
                        stringBuffer.append(objectArray[i].toString());
                    }
                    throw new RuntimeException(invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (this.failOnUnaccessible) {
                        throw new RuntimeException("\"" + string + "()\" exists in " + objectArray[i].getClass().getName() + ", but can't be accessed", illegalAccessException);
                    }
                    stringBuffer.append("(unaccessible " + string + " in " + objectArray[i].getClass().getName());
                }
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(this.separator);
            }
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method findMethod(Object object, String string) throws NoSuchMethodException {
        Class<?> clazz = object.getClass();
        ObjectLister objectLister = this;
        synchronized (objectLister) {
            Method method;
            Cache cache = (Cache)this.clsToMethodsCache.get(clazz);
            if (cache == null) {
                cache = new Cache(3);
                this.clsToMethodsCache.put(clazz, cache);
            }
            if ((method = (Method)cache.get(string)) == null) {
                method = clazz.getMethod(string, new Class[0]);
                if (method.getReturnType() != String.class) {
                    throw new NoSuchMethodException("\"" + string + "()\" exists, but has not String return type");
                }
                cache.put(string, method);
            }
            return method;
        }
    }

    public String list(Object[] objectArray) {
        return this.list(objectArray, "toString");
    }

    public String list(Collection collection, String string) {
        Object[] objectArray = new Object[collection.size()];
        collection.toArray(objectArray);
        return this.list(objectArray, string);
    }

    public String list(Collection collection) {
        return this.list(collection, "toString");
    }

    public String list(Iterator iterator, String string) {
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        Object[] objectArray = new Object[linkedList.size()];
        linkedList.toArray(objectArray);
        return this.list(objectArray, string);
    }

    public String list(Iterator iterator) {
        return this.list(iterator, "toString");
    }

    public String list(Enumeration enumeration, String string) {
        Object[] objectArray = ObjectLister.enumerate(enumeration);
        return this.list(objectArray, string);
    }

    public String list(Enumeration enumeration) {
        return this.list(enumeration, "toString");
    }

    public void println(Object[] objectArray, String string) {
        System.out.println(this.list(objectArray, string));
    }

    public void println(Object[] objectArray) {
        System.out.println(this.list(objectArray));
    }

    public void println(Collection collection, String string) {
        System.out.println(this.list(collection, string));
    }

    public void println(Collection collection) {
        System.out.println(this.list(collection));
    }

    public void println(Enumeration enumeration, String string) {
        System.out.println(this.list(enumeration, string));
    }

    public void println(Enumeration enumeration) {
        System.out.println(this.list(enumeration));
    }

    public void println(Map map, String string) {
        System.out.println(this.list(map, string));
    }

    public void println(Map map) {
        System.out.println(this.list(map));
    }

    public String list(Map map, String string) {
        Object[] objectArray = new Entry[map.keySet().size()];
        int n = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            objectArray[n++] = new Entry(k, v, string);
        }
        return this.list(objectArray, string);
    }

    public String list(Map map) {
        return this.list(map, "toString");
    }

    public boolean isUseToStringIfNotFound() {
        return this.useToStringIfNotFound;
    }

    public void setUseToStringIfNotFound(boolean bl) {
        this.useToStringIfNotFound = bl;
    }

    public static ObjectLister getInstance() {
        return defaultInstance;
    }

    private static Object[] enumerate(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray();
    }

    public static void main(String[] stringArray) throws NoSuchMethodException, InvocationTargetException {
        Object[] objectArray = new Object[]{"Hello world", new Thread("Test Thread 2"), new Object[0]};
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Key 1", objectArray[0]);
        hashMap.put("Key 2", objectArray[1]);
        hashMap.put("Key 3", objectArray[2]);
        hashMap.put("bingo", null);
        System.out.println(new ObjectLister().list(hashMap));
    }

    public boolean isSetAccessible() {
        return this.setAccessible;
    }

    public void setSetAccessible(boolean bl) {
        this.setAccessible = bl;
    }

    public boolean isFailOnUnaccessible() {
        return this.failOnUnaccessible;
    }

    public void setFailOnUnaccessible(boolean bl) {
        this.failOnUnaccessible = bl;
    }

    public static ObjectLister getDefaultHTMLInstance() {
        return defaultHTMLInstance;
    }

    private class Entry {
        Object key;
        Object value;
        String methodToUse;

        public Entry(Object object, Object object2, String string) {
            this.key = object;
            this.value = object2;
            this.methodToUse = string;
        }

        public String toString() {
            return (this.key == null ? "<null>" : this.key.toString()) + " = " + ObjectLister.this.list(new Object[]{this.value}, this.methodToUse);
        }
    }
}

