/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import com.deltax.util.FIFOQueue;
import com.deltax.util.QueueEmptyException;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.sadun.util.PushbackReader;

public class HTMLAnchorIterator
implements Iterator {
    private Reader reader;
    private boolean eof;
    private FIFOQueue anchors = new FIFOQueue();
    private static final int LOOKING_FOR_MANDATORY_SPACES = 0;
    private static final int LOOKING_FOR_SPACES = 1;
    private static final int LOOKING_FOR_HREF = 2;
    private static final int LOOKING_FOR_A = 3;
    private static final int LOOKING_FOR_EQUAL = 4;
    private static final int LOOKING_FOR_OPENING_QUOTE = 5;
    private static final int IN_HREF = 6;
    private static final int URL_FOUND = 7;
    private static final int CHECK_FOR_EOF = 8;
    private String[] stateDescr = new String[]{"LOOKING_FOR_MANDATORY_SPACES", "LOOKING_FOR_SPACES", "LOOKING_FOR_HREF", "LOOKING_FOR_A", "LOOKING_FOR_EQUAL", "LOOKING_FOR_OPENING_QUOTE", "IN_HREF", "URL_FOUND", "CHECK_FOR_EOF"};
    private URLsCollection urlsCollection = null;

    public HTMLAnchorIterator(Reader reader) {
        this.reader = reader;
        this.eof = false;
    }

    public boolean hasNext() {
        if (this.anchors.size() == 0) {
            try {
                this.findNextAnchors();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
            if (this.anchors.size() == 0) {
                return false;
            }
        }
        return true;
    }

    private synchronized void findNextAnchors() throws IOException {
        if (!this.reader.ready()) {
            return;
        }
        PushbackReader pushbackReader = new PushbackReader(this.reader);
        int n = 3;
        int n2 = -1;
        int n3 = 0;
        this.eof = false;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            switch (n) {
                case 8: {
                    int n4 = pushbackReader.read();
                    if (n4 == -1) {
                        this.eof = true;
                        break;
                    }
                    n = n2;
                    break;
                }
                case 3: {
                    if (pushbackReader.nextEqualsIgnoreCase("<a", false)) {
                        n = 0;
                        n2 = 2;
                        break;
                    }
                    n = 8;
                    n2 = 3;
                    break;
                }
                case 0: {
                    if (this.jumpSpaces(pushbackReader, 1)) {
                        n = n2;
                        break;
                    }
                    n = 8;
                    n2 = 3;
                    break;
                }
                case 1: {
                    if (this.jumpSpaces(pushbackReader, 0)) {
                        n = n2;
                        break;
                    }
                    n = 8;
                    n2 = 3;
                    break;
                }
                case 2: {
                    if (pushbackReader.nextEqualsIgnoreCase("href", false)) {
                        n = 1;
                        n2 = 4;
                        break;
                    }
                    n = 8;
                    n2 = 3;
                    break;
                }
                case 4: {
                    int n4 = pushbackReader.read();
                    if (n4 == -1) {
                        this.eof = true;
                        break;
                    }
                    if (n4 == 61) {
                        n = 1;
                        n2 = 5;
                        break;
                    }
                    n = 8;
                    n2 = 3;
                    break;
                }
                case 5: {
                    int n4 = pushbackReader.read();
                    if (n4 == -1) {
                        this.eof = true;
                        break;
                    }
                    if (n4 == 34 || n4 == 39) {
                        n = 6;
                        n3 = (char)n4;
                        break;
                    }
                    n = 8;
                    n2 = 3;
                    break;
                }
                case 6: {
                    int n4 = pushbackReader.read();
                    if (n4 == -1) {
                        this.eof = true;
                        break;
                    }
                    if (n4 == n3) {
                        n = 7;
                        break;
                    }
                    stringBuffer.append((char)n4);
                }
            }
        } while (!this.eof && n != 7);
        this.anchors.put(stringBuffer.toString());
    }

    private boolean jumpSpaces(PushbackReader pushbackReader, int n) throws IOException {
        boolean bl;
        int n2 = 0;
        do {
            int n3;
            if (bl = Character.isWhitespace((char)(n3 = pushbackReader.read()))) {
                ++n2;
                continue;
            }
            pushbackReader.unread(n3);
        } while (bl);
        return n2 >= n;
    }

    public Object next() {
        try {
            return this.anchors.get();
        }
        catch (QueueEmptyException queueEmptyException) {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            try {
                this.findNextAnchors();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return this.next();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public synchronized URLsCollection getURLs(URL uRL) throws IOException {
        if (this.urlsCollection == null) {
            this.urlsCollection = new URLsCollection(uRL, this);
        }
        if (uRL != this.urlsCollection.context) {
            throw new IllegalArgumentException("Invalid context: " + uRL + ". An URLsCollection has already been requested with a different context (" + this.urlsCollection.context + ")");
        }
        return this.urlsCollection;
    }

    public class URLsCollection {
        private URL[] valid;
        private Map invalid = new HashMap();
        private URL context;

        private URLsCollection(URL uRL, HTMLAnchorIterator hTMLAnchorIterator2) throws IOException {
            this.context = uRL;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (hTMLAnchorIterator2.hasNext()) {
                arrayList.add(hTMLAnchorIterator2.next());
            }
            ArrayList<URL> arrayList2 = new ArrayList<URL>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    if (uRL != null) {
                        arrayList2.add(new URL(uRL, string));
                        continue;
                    }
                    arrayList2.add(new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    this.invalid.put(string, malformedURLException);
                }
            }
            this.valid = new URL[arrayList2.size()];
            arrayList2.toArray(this.valid);
        }

        public int getSize() {
            return this.getValidCount() + this.getInvalidCount();
        }

        public int getValidCount() {
            return this.valid.length;
        }

        public int getInvalidCount() {
            return this.invalid.keySet().size();
        }

        public URL getContext() {
            return this.context;
        }

        public URL[] getValidURLs() {
            URL[] uRLArray = new URL[this.valid.length];
            System.arraycopy(this.valid, 0, uRLArray, 0, this.valid.length);
            return uRLArray;
        }

        public String[] getInvalidURLs() {
            String[] stringArray = new String[this.invalid.keySet().size()];
            this.invalid.keySet().toArray(stringArray);
            return stringArray;
        }

        public MalformedURLException getMalformedURLException(String string) {
            MalformedURLException malformedURLException = (MalformedURLException)this.invalid.get(string);
            if (malformedURLException == null) {
                throw new IllegalArgumentException("'" + string + "' is an unknown URL");
            }
            return malformedURLException;
        }
    }
}

