/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import com.deltax.util.DynamicClassFileFinder;
import com.deltax.util.DynamicJDK12ClassFileFinder;
import com.deltax.util.DynamicResourceFileFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public class DynamicClassLoader
extends ClassLoader {
    private DynamicClassFileFinder cff;
    private DynamicResourceFileFinder rff;
    private boolean forceDynamicLoading;
    private static final boolean debug = false;
    private static DynamicJDK12ClassFileFinder dynamicJDK12ClassFileFinder = new DynamicJDK12ClassFileFinder();

    public DynamicClassLoader(ClassLoader classLoader, DynamicClassFileFinder dynamicClassFileFinder, DynamicResourceFileFinder dynamicResourceFileFinder) {
        super(classLoader);
        this.cff = dynamicClassFileFinder;
        this.rff = dynamicResourceFileFinder;
    }

    public DynamicClassLoader(DynamicClassFileFinder dynamicClassFileFinder, DynamicResourceFileFinder dynamicResourceFileFinder) {
        this.cff = dynamicClassFileFinder;
        this.rff = dynamicResourceFileFinder;
    }

    public DynamicClassFileFinder getClassFileFinder() {
        return this.cff;
    }

    public DynamicResourceFileFinder getResourceFileFinder() {
        return this.rff;
    }

    public DynamicClassLoader(ClassLoader classLoader) {
        this(classLoader, dynamicJDK12ClassFileFinder, dynamicJDK12ClassFileFinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPathEntry(String string) {
        DynamicClassLoader dynamicClassLoader = this;
        synchronized (dynamicClassLoader) {
            this.cff.addClassPathEntry(string);
            this.rff.addClassPathEntry(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassPath(String string) {
        DynamicClassLoader dynamicClassLoader = this;
        synchronized (dynamicClassLoader) {
            this.cff.setClassPath(string);
            this.rff.setClassPath(string);
        }
    }

    public String getClassPath() {
        return this.cff.getClassPath();
    }

    public DynamicClassLoader() {
        this(dynamicJDK12ClassFileFinder, dynamicJDK12ClassFileFinder);
    }

    public static void main(String[] stringArray) {
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader();
        dynamicJDK12ClassFileFinder.addClassPathEntry("C:/mc4j/lib/core.jar");
        InputStream inputStream = dynamicClassLoader.getResourceAsStream("org/netbeans/core/resources/action.gif");
        System.out.println(inputStream);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            if (this.forceDynamicLoading) {
                throw new ClassNotFoundException();
            }
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                byte[] byArray = this.cff.getClassBytes(string);
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new ClassNotFoundException("IOException while reading definition for class " + string, iOException);
            }
        }
    }

    protected URL findResource(String string) {
        try {
            File file = this.rff.findResourceFile(string);
            if (file == null) {
                return null;
            }
            URL uRL = new URL("file", null, this.rff.findResourceFile(string).getCanonicalPath());
            if (file.equals(new File(string))) {
                return uRL;
            }
            String string2 = "jar:" + uRL + "!/" + string;
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    protected Enumeration findResources(String string) throws IOException {
        throw new RuntimeException("findResources is not implemented by this ClassLoader");
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = super.getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        try {
            return this.rff.openResource(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isForceDynamicLoading() {
        return this.forceDynamicLoading;
    }

    public void setForceDynamicLoading(boolean bl) {
        this.forceDynamicLoading = bl;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.forceDynamicLoading && !string.startsWith("java.")) {
            Class<?> clazz = super.findLoadedClass(string);
            if (clazz != null) {
                return clazz;
            }
            Class clazz2 = this.findClass(string);
            if (clazz2 != null && bl) {
                this.resolveClass(clazz2);
            }
            return clazz2;
        }
        return super.loadClass(string, bl);
    }

    protected String findLibrary(String string) {
        String string2 = this.rff.getClassPath();
        String[] stringArray = string2.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            if (stringArray[i].endsWith(".jar") || stringArray[i].endsWith("zip") || !(file = new File(stringArray[i])).isDirectory()) continue;
            File file2 = new File(file, string);
            if (file2.exists()) {
                return file2.getAbsolutePath();
            }
            file2 = new File(file, string + ".dll");
            if (file2.exists()) {
                return file2.getAbsolutePath();
            }
            file2 = new File(file, string + ".so");
            if (!file2.exists()) continue;
            return file2.getAbsolutePath();
        }
        return null;
    }
}

