/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.sadun.util.Cache;
import org.sadun.util.ListEnumeration;
import org.sadun.util.ObjectLister;
import org.sadun.util.pool.connection.ConfigurableDataSource;

public class DatabaseResourceBundle
extends ResourceBundle {
    public static final String RESOURCETABLE_DEFAULT_NAME = "APPLICATION_RESOURCES";
    public static final int DEFAULT_CACHE_SIZE = 100;
    private DataSource ds;
    private String defaultResourceTable;
    private Map tablesByPattern = new HashMap();
    private boolean preLoad = true;
    private boolean autoAdjustCache = false;
    private int cacheSize;
    private Cache keysCache;

    public DatabaseResourceBundle(DataSource dataSource, String string, int n) {
        this.ds = dataSource;
        this.defaultResourceTable = string;
        this.createCache(n);
    }

    public DatabaseResourceBundle(DataSource dataSource, String string) {
        this(dataSource, string, 100);
    }

    public DatabaseResourceBundle(DataSource dataSource, int n) {
        this(dataSource, RESOURCETABLE_DEFAULT_NAME, 100);
    }

    public DatabaseResourceBundle(DataSource dataSource) {
        this(dataSource, RESOURCETABLE_DEFAULT_NAME, 100);
    }

    public DatabaseResourceBundle(String string, String string2, int n) {
        this.ds = new ConfigurableDataSource(string);
        this.defaultResourceTable = string2;
        this.createCache(n);
    }

    public DatabaseResourceBundle(String string, String string2) {
        this(string, string2, 100);
    }

    public DatabaseResourceBundle(String string, int n) {
        this(string, RESOURCETABLE_DEFAULT_NAME, 100);
    }

    public DatabaseResourceBundle(String string) {
        this(string, RESOURCETABLE_DEFAULT_NAME, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        DatabaseResourceBundle databaseResourceBundle = this;
        synchronized (databaseResourceBundle) {
            this.keysCache = new Cache(this.cacheSize);
        }
    }

    private void createCache(int n) {
        this.cacheSize = n;
        this.keysCache = new Cache(n);
    }

    public void setResourceTable(String string, String string2) {
        this.setResourceTable(Pattern.compile(string), string2);
    }

    public void setResourceTable(Pattern pattern, String string) {
        this.tablesByPattern.put(pattern, string);
    }

    /*
     * Loose catch block
     */
    protected Object handleGetObject(String string) {
        Object object;
        block20: {
            Object object2;
            Object object3;
            Object object4;
            block19: {
                object = this.keysCache.get(string);
                if (object != null) {
                    return object;
                }
                String string2 = this.defaultResourceTable;
                object4 = this.tablesByPattern.keySet().iterator();
                while (object4.hasNext()) {
                    object3 = (Pattern)object4.next();
                    object2 = ((Pattern)object3).matcher(string);
                    if (!((Matcher)object2).matches()) continue;
                    string2 = (String)this.tablesByPattern.get(object3);
                    break;
                }
                object4 = null;
                object3 = null;
                object2 = null;
                object4 = this.ds.getConnection();
                object3 = object4.createStatement();
                if (this.autoAdjustCache) {
                    object2 = object3.executeQuery("select count(*) from " + string2 + " where locale = '" + Locale.getDefault().toString() + "'");
                    object2.next();
                    int n = Math.max(2, object2.getInt(1));
                    object2.close();
                    if (this.cacheSize != n) {
                        this.createCache(n);
                    }
                }
                if (this.preLoad) {
                    object2 = object3.executeQuery("select key_name, value from " + string2 + " where locale= '" + Locale.getDefault().toString() + "'");
                    while (object2.next()) {
                        String string3 = object2.getString(1);
                        String string4 = object2.getString(2);
                        this.keysCache.put(string3, string4);
                        if (!string3.equals(string)) continue;
                        object = string4;
                    }
                    break block19;
                }
                object2 = object3.executeQuery("select value from " + string2 + " where key_name='" + this.toSqlString(string) + "' and locale= '" + Locale.getDefault().toString() + "'");
                String string5 = object2.getString(1);
                this.keysCache.put(string, string5);
                object = string5;
            }
            Object var10_12 = null;
            try {
                if (object2 != null) {
                    object2.close();
                }
                if (object3 != null) {
                    object3.close();
                }
                if (object4 != null) {
                    object4.close();
                }
                break block20;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            break block20;
            {
                catch (SQLException sQLException) {
                    throw new MissingResourceException("Could not get value for key '" + string + "' due to an SQL exception: " + sQLException.getMessage(), this.getClass().getName(), string);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                    if (object3 != null) {
                        object3.close();
                    }
                    if (object4 != null) {
                        object4.close();
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                throw throwable;
            }
        }
        return object;
    }

    private String toSqlString(String string) {
        return string.replaceAll("'", "''");
    }

    public Enumeration getKeys() {
        LinkedList linkedList = new LinkedList();
        HashSet<String> hashSet = new HashSet<String>();
        this.addKeys(linkedList, this.defaultResourceTable);
        hashSet.add(this.defaultResourceTable.toLowerCase());
        Iterator iterator = this.tablesByPattern.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (hashSet.contains(string.toLowerCase())) continue;
            this.addKeys(linkedList, string);
        }
        return new ListEnumeration(linkedList);
    }

    /*
     * Loose catch block
     */
    private void addKeys(List list, String string) {
        block14: {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            connection = this.ds.getConnection();
            statement = connection.createStatement();
            String string2 = "select key_name from " + string + " where locale = '" + Locale.getDefault().toString() + "'";
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                list.add(resultSet.getString(1));
            }
            Object var8_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block14;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            break block14;
            {
                catch (SQLException sQLException) {
                    throw new RuntimeException("Could not read keys from resource table " + string, sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public boolean isAutoAdjustCache() {
        return this.autoAdjustCache;
    }

    public void setAutoAdjustCache(boolean bl) {
        if (bl != this.autoAdjustCache) {
            this.clearCache();
        }
        this.autoAdjustCache = bl;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        if (n != this.cacheSize) {
            this.setAutoAdjustCache(false);
            this.createCache(n);
        }
    }

    public String getJdbcUrl() {
        if (this.ds instanceof ConfigurableDataSource) {
            return ((ConfigurableDataSource)this.ds).getJdbcUrl();
        }
        throw new IllegalStateException("The bundle has been constructed using a data source");
    }

    public void setJdbcUrl(String string) {
        if (!(this.ds instanceof ConfigurableDataSource)) {
            throw new IllegalStateException("The bundle has been constructed using a data source");
        }
        if (((ConfigurableDataSource)this.ds).getJdbcUrl().equals(string)) {
            return;
        }
        this.clearCache();
        this.ds = new ConfigurableDataSource(string);
    }

    public boolean isPreLoad() {
        return this.preLoad;
    }

    public void setPreLoad(boolean bl) {
        this.preLoad = bl;
    }

    public static void main(String[] stringArray) {
        String string = "jdbc:microsoft:sqlserver://localhost:1433;User=sa;Password=;DatabaseName=ipm";
        DatabaseResourceBundle databaseResourceBundle = new DatabaseResourceBundle(string);
        ObjectLister.getInstance().println(((ResourceBundle)databaseResourceBundle).getKeys());
        System.out.println(databaseResourceBundle.getString("name"));
    }
}

