/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import [Ljava.lang.String;;
import com.deltax.util.JPanelPrintStream;
import com.deltax.util.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class CommandRunner
extends Thread {
    private String command;
    private Class cls;
    private String[] args;
    private Component parent;
    private boolean openWindowOnStartup = true;
    private boolean outputOnSystemOut = false;
    private boolean closeWindowOnTermination = false;
    private boolean captureOutput = false;
    private boolean outputElapsedTime = true;
    private String lastOutput;
    private JFrame jf;
    private Set listeners = new HashSet();
    private static final int STARTING = 0;
    private static final int FAILED = 1;
    private static final int STARTED = 2;
    private static final int TERMINATED = 3;
    static /* synthetic */ Class class$org$sadun$util$ListMapIterator;

    public CommandRunner(Component component, String string, String[] stringArray, boolean bl) {
        this.setDaemon(bl);
        this.parent = component;
        this.command = string;
        this.args = this.unquote(stringArray);
    }

    public CommandRunner(Component component, Class clazz, String[] stringArray, boolean bl) {
        this.setDaemon(bl);
        this.parent = component;
        this.cls = clazz;
        this.args = this.unquote(stringArray);
    }

    public CommandRunner(Class clazz, String[] stringArray, boolean bl) {
        this(null, clazz, stringArray, bl);
    }

    public CommandRunner(Component component, Class clazz, String[] stringArray) {
        this(component, clazz, stringArray, true);
    }

    public CommandRunner(Class clazz, String[] stringArray) {
        this(clazz, stringArray, true);
    }

    public CommandRunner(String string, String[] stringArray, boolean bl) {
        this(null, string, stringArray, bl);
    }

    public CommandRunner(Component component, String string, String[] stringArray) {
        this(component, string, stringArray, true);
    }

    public CommandRunner(String string, String[] stringArray) {
        this(string, stringArray, true);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private String[] unquote(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.unquote(stringArray[i]);
        }
        return stringArray;
    }

    private String unquote(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'' || string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private void notify(int n) {
        this.notify(n, null);
    }

    private void notify(int n, Object object) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            switch (n) {
                case 0: {
                    listener.starting();
                    break;
                }
                case 1: {
                    listener.failed((Exception)object);
                    break;
                }
                case 2: {
                    listener.started();
                    break;
                }
                case 3: {
                    Object[] objectArray = (Object[])object;
                    listener.terminated((Integer)objectArray[0], (Long)objectArray[1]);
                }
            }
        }
    }

    public synchronized void run() {
        String string = this.command != null ? this.command + " " + this.argsList(this.args) : this.cls + " " + this.argsList(this.args);
        this.closeWindow();
        JPanelPrintStream jPanelPrintStream = new JPanelPrintStream();
        JLabel jLabel = new JLabel(" Running " + string);
        if (this.openWindowOnStartup) {
            this.jf = new JFrame("Running \"" + this.command + "\"");
            this.jf.getContentPane().setLayout(new BorderLayout());
            this.jf.getContentPane().add((Component)jLabel, "North");
            this.jf.getContentPane().add((Component)jPanelPrintStream.getPanel(), "Center");
            this.jf.pack();
            this.jf.setSize(600, 400);
            if (this.parent == null) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                this.jf.setLocation((dimension.width - this.jf.getSize().width) / 2, (dimension.height - this.jf.getSize().height) / 2);
            } else {
                this.jf.setLocation(this.parent.getLocation().x + 30, this.parent.getLocation().y + 30);
            }
            this.jf.setVisible(true);
        }
        if (this.command != null) {
            this.executeCommand(string, jPanelPrintStream, jLabel);
        } else {
            this.executeClass(string, jPanelPrintStream, jLabel);
        }
        if (this.closeWindowOnTermination) {
            this.closeWindow();
        }
    }

    private void executeClass(String string, JPanelPrintStream jPanelPrintStream, JLabel jLabel) {
        PrintStream printStream;
        block10: {
            printStream = System.out;
            try {
                Method method = this.cls.getMethod("main", String;.class);
                if (this.openWindowOnStartup) {
                    System.setOut(jPanelPrintStream);
                }
                this.notify(0);
                long l = System.currentTimeMillis();
                long l2 = 0L;
                method.invoke(null, new Object[]{this.args});
                l2 = System.currentTimeMillis() - l;
                this.notify(2);
                Object[] objectArray = new Object[]{new Integer(0), new Long(l2)};
                if (this.openWindowOnStartup) {
                    System.setOut(printStream);
                    jPanelPrintStream.flush();
                }
                this.notify(3, objectArray);
                if (this.outputElapsedTime) {
                    String string2 = new TimeInterval(l2).toString();
                    if (this.openWindowOnStartup) {
                        this.jf.setTitle("Run \"" + this.cls + "\" in " + string2);
                        jLabel.setText(" " + this.cls + " - terminated");
                        jPanelPrintStream.flush();
                    }
                    if (this.outputOnSystemOut) {
                        System.out.println("Elapsed " + string2);
                    }
                } else if (this.openWindowOnStartup) {
                    this.jf.setTitle(" \"" + this.cls + "\" terminated");
                    jLabel.setText(" " + this.cls + " - terminated");
                    jPanelPrintStream.flush();
                }
            }
            catch (Exception exception) {
                this.notify(1, exception);
                if (this.openWindowOnStartup) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
                    printStream2.println("Exception occurred");
                    printStream2.println();
                    exception.printStackTrace(printStream2);
                    jPanelPrintStream.println(byteArrayOutputStream.toString());
                    jPanelPrintStream.flush();
                    JOptionPane.showMessageDialog(this.jf, byteArrayOutputStream.toString(), "Exception Occurred", 0);
                    this.jf.setTitle(" \"" + string + "\" failed");
                    jLabel.setText(" " + string + " - failed");
                }
                if (!this.outputOnSystemOut) break block10;
                exception.printStackTrace();
            }
        }
        System.setOut(printStream);
    }

    private void executeCommand(String string, JPanelPrintStream jPanelPrintStream, JLabel jLabel) {
        block14: {
            String[] stringArray = new String[this.args.length + 1];
            stringArray[0] = this.command;
            System.arraycopy(this.args, 0, stringArray, 1, this.args.length);
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(stringArray[i]);
                System.out.print(" ");
            }
            System.out.println();
            try {
                boolean bl;
                this.notify(0);
                long l = System.currentTimeMillis();
                long l2 = 0L;
                Process process = Runtime.getRuntime().exec(stringArray);
                this.notify(2);
                InputStream inputStream = process.getInputStream();
                do {
                    int n;
                    bl = false;
                    while ((n = inputStream.read()) != -1) {
                        if (this.openWindowOnStartup) {
                            jPanelPrintStream.write(n);
                        }
                        if (!this.outputOnSystemOut) continue;
                        System.out.write(n);
                    }
                    l2 = System.currentTimeMillis() - l;
                    try {
                        int n2 = process.exitValue();
                        jPanelPrintStream.flush();
                        Object[] objectArray = new Object[]{new Integer(n2), new Long(l2)};
                        this.notify(3, objectArray);
                        process.destroy();
                        if (!this.captureOutput) continue;
                        this.lastOutput = jPanelPrintStream.getContents();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        bl = true;
                    }
                } while (bl);
                if (this.outputElapsedTime) {
                    String string2 = new TimeInterval(l2).toString();
                    if (this.openWindowOnStartup) {
                        this.jf.setTitle("Run \"" + this.command + "\" in " + string2);
                        jLabel.setText(" " + string + " - terminated");
                    }
                    if (this.outputOnSystemOut) {
                        System.out.println("Elapsed " + string2);
                    }
                } else if (this.openWindowOnStartup) {
                    this.jf.setTitle(" \"" + string + "\" terminated");
                    jLabel.setText(" " + string + " - terminated");
                }
            }
            catch (IOException iOException) {
                this.notify(1, iOException);
                if (this.openWindowOnStartup) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(byteArrayOutputStream);
                    printStream.println("Exception occurred");
                    printStream.println();
                    iOException.printStackTrace(printStream);
                    JOptionPane.showMessageDialog(this.jf, byteArrayOutputStream.toString(), "Exception Occurred", 0);
                    this.jf.setTitle(" \"" + this.command + "\" failed");
                    jLabel.setText(" " + string + " - failed");
                }
                if (!this.outputOnSystemOut) break block14;
                iOException.printStackTrace();
            }
        }
    }

    private void closeWindow() {
        if (this.jf == null) {
            return;
        }
        this.jf.setVisible(false);
        this.jf.dispose();
        this.jf = null;
        this.lastOutput = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String argsList(String[] stringArray) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
    }

    public boolean isCloseWindowOnTermination() {
        return this.closeWindowOnTermination;
    }

    public boolean isOpenWindowOnStartup() {
        return this.openWindowOnStartup;
    }

    public boolean isOutputOnSystemOut() {
        return this.outputOnSystemOut;
    }

    public synchronized void setCloseWindowOnTermination(boolean bl) {
        this.closeWindowOnTermination = bl;
    }

    public synchronized void setOpenWindowOnStartup(boolean bl) {
        this.openWindowOnStartup = bl;
    }

    public synchronized void setOutputOnSystemOut(boolean bl) {
        this.outputOnSystemOut = bl;
    }

    public boolean isCaptureOutput() {
        return this.captureOutput;
    }

    public String getLastOutput() {
        return this.lastOutput;
    }

    public void setCaptureOutput(boolean bl) {
        this.captureOutput = bl;
    }

    public boolean isOutputElapsedTime() {
        return this.outputElapsedTime;
    }

    public void setOutputElapsedTime(boolean bl) {
        this.outputElapsedTime = bl;
    }

    public static void main(String[] stringArray) {
        new Thread(){

            public void run() {
                CommandRunner commandRunner = new CommandRunner(class$org$sadun$util$ListMapIterator == null ? (class$org$sadun$util$ListMapIterator = CommandRunner.class$("org.sadun.util.ListMapIterator")) : class$org$sadun$util$ListMapIterator, new String[]{"-X"}, false);
                commandRunner.start();
                while (true) {
                    System.out.println("busy");
                    Thread.yield();
                }
            }
        }.start();
    }

    public static class StdOutAdapter
    implements Listener {
        public void starting() {
            System.out.println("Starting");
        }

        public void failed(Exception exception) {
            exception.printStackTrace();
        }

        public void started() {
            System.out.println("Started");
        }

        public void terminated(int n, long l) {
            System.out.println("Terminated with exit value " + n + " in " + l + "ms");
        }
    }

    public static class Adapter
    implements Listener {
        public void starting() {
        }

        public void failed(Exception exception) {
        }

        public void started() {
        }

        public void terminated(int n, long l) {
        }
    }

    public static interface Listener {
        public void starting();

        public void failed(Exception var1);

        public void started();

        public void terminated(int var1, long var2);
    }
}

