/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sadun.util.ClassPathIterator;
import org.sadun.util.ObjectLister;

public class ClassPathChecker {
    private String classPath;
    private static final int MISSING = 0;
    private static final int EXISTING = 1;
    private static final ClassPathChecker checker;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassPathChecker(String string) {
        this.classPath = string;
    }

    public ClassPathChecker() {
        this(System.getProperty("java.class.path"));
    }

    public List findMissingSet() {
        return this.find(0);
    }

    public List findExistingSet() {
        return this.find(1);
    }

    public static ClassPathChecker getInstance() {
        return checker;
    }

    private List find(int n) {
        if (!$assertionsDisabled && n != 0 && n != 1) {
            throw new AssertionError();
        }
        ClassPathIterator classPathIterator = new ClassPathIterator(this.classPath);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (classPathIterator.hasNext()) {
            File file = classPathIterator.nextEntryFile();
            if ((n != 0 || file.exists()) && (n != 1 || !file.exists())) continue;
            try {
                arrayList.add(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                arrayList.add(file.getAbsolutePath());
            }
        }
        return arrayList;
    }

    public String listMissingEntries() {
        List list = this.findMissingSet();
        if (list.size() == 0) {
            return "(all entries in classpath exist)";
        }
        StringBuffer stringBuffer = new StringBuffer("The following entries cannot be opened:");
        stringBuffer.append(System.getProperty("line.separator"));
        ObjectLister objectLister = new ObjectLister(System.getProperty("line.separator"));
        stringBuffer.append(objectLister.list(list));
        return stringBuffer.toString();
    }

    public String listExistingEntries() {
        List list = this.findExistingSet();
        if (list.size() == 0) {
            return "(no entry in classpath exist)";
        }
        StringBuffer stringBuffer = new StringBuffer("The following entries can be opened:");
        stringBuffer.append(System.getProperty("line.separator"));
        ObjectLister objectLister = new ObjectLister(System.getProperty("line.separator"));
        stringBuffer.append(objectLister.list(list));
        return stringBuffer.toString();
    }

    public String getCheckResult() {
        StringBuffer stringBuffer = new StringBuffer("Classpath is " + this.classPath);
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(this.listMissingEntries());
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !ClassPathChecker.class.desiredAssertionStatus();
        checker = new ClassPathChecker();
    }
}

