/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AutoClassLoader
extends ClassLoader {
    private static String cpath = null;
    private static String pathSep = null;

    public AutoClassLoader() {
        if (pathSep == null) {
            pathSep = System.getProperty("path.separator");
        }
    }

    public AutoClassLoader(ClassLoader classLoader) {
        super(classLoader);
        if (pathSep == null) {
            pathSep = System.getProperty("path.separator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String expandClassPath() {
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, pathSep);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = !stringTokenizer.hasMoreTokens();
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            while (!bl) {
                String string2 = stringTokenizer.nextToken();
                stringBuffer.append(string + pathSep);
                File file = new File(string2);
                if (file.isDirectory() && file.exists()) {
                    stringBuffer.append(this.getJarsInDirectory(file, pathSep));
                } else {
                    stringBuffer.append(string2);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(pathSep);
                    continue;
                }
                bl = true;
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJarsInDirectory(File file, String string) {
        StringBuffer stringBuffer;
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        });
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(file.getAbsolutePath() + File.separator + stringArray[i]);
                if (i >= stringArray.length) continue;
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (cpath == null) {
            cpath = this.expandClassPath();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(cpath, pathSep);
        while (stringTokenizer.hasMoreTokens()) {
            Class clazz;
            String string2 = stringTokenizer.nextToken();
            if (!string2.endsWith(".jar") || (clazz = this.lookInJar(string, string2)) == null) continue;
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    private Class lookInJar(String string, String string2) throws ClassNotFoundException {
        try {
            JarFile jarFile = new JarFile(string2);
            String string3 = string.replace('.', '/') + ".class";
            JarEntry jarEntry = jarFile.getJarEntry(string3);
            if (jarEntry == null) {
                return null;
            }
            System.out.println(string + " found in " + string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (long i = 0L; i < jarEntry.getSize(); ++i) {
                byteArrayOutputStream.write(bufferedInputStream.read());
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Can't load " + string + " from " + string2, iOException);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.setProperty("java.class.path", "c:\\xtractor\\dev\\core\\lib;c:\\xtractor\\dev\\core\\lib\\3rd");
        AutoClassLoader autoClassLoader = new AutoClassLoader(ClassLoader.getSystemClassLoader());
        Class<?> clazz = autoClassLoader.loadClass("com.metamata.util.ZipPath");
    }
}

