/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.swt.widgets;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.sadun.swt.widgets.InputBox;

public class MapEditor
extends Composite {
    private static int TABLE_INSET_HORIZONTAL = 2;
    private static int TABLE_INSET_VERTICAL = 2;
    private Map map;
    private Group group;
    private Table table;
    private Menu rightMenu;
    private MenuItem deleteItem;
    private MenuItem addItem;
    private Color bgColor;
    private List tableItemChangeListeners = new ArrayList();
    private MouseAdapter rightMenuShowerMouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 3) {
                MapEditor.this.rightMenu.setVisible(true);
            }
        }
    };
    private EditableSelectionAdapter editableSelectionAdapter = new EditableSelectionAdapter(1);
    static /* synthetic */ Class class$java$lang$String;

    public MapEditor(Composite composite, String string, Map map, boolean bl, boolean bl2) {
        super(composite, 0);
        this.map = map;
        this.setupUI(string, composite);
        this.setValueEditable(bl);
        this.setListEditable(bl2);
        this.updatePropertiesTable(map);
    }

    public MapEditor(Composite composite, String string, Map map) {
        this(composite, string, map, true, true);
    }

    public MapEditor(Composite composite, String string) {
        this(composite, string, new HashMap(), true, true);
    }

    private void updatePropertiesTable(Map map) {
        this.table.removeAll();
        TableColumn tableColumn = new TableColumn(this.table, 16384, 0);
        tableColumn.setText("Name");
        TableColumn tableColumn2 = new TableColumn(this.table, 16384, 1);
        tableColumn2.setText("Value");
        TreeSet treeSet = new TreeSet(map.keySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = map.get(string).toString();
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, string);
            tableItem.setText(1, string2);
        }
    }

    private void setupUI(String string, Composite composite) {
        this.bgColor = new Color((Device)this.getDisplay(), 255, 255, 100);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        this.setLayout((Layout)fillLayout);
        this.group = new Group((Composite)this, 0);
        this.group.setText(string);
        FillLayout fillLayout2 = new FillLayout();
        fillLayout2.marginHeight = TABLE_INSET_HORIZONTAL;
        fillLayout2.marginWidth = TABLE_INSET_VERTICAL;
        this.group.setLayout((Layout)fillLayout2);
        this.table = new Table((Composite)this.group, 65540);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (MapEditor.this.table.getColumnCount() < 2) {
                    return;
                }
                int n = ((MapEditor)MapEditor.this).table.getBounds().width;
                int n2 = (int)((double)n * 0.3);
                int n3 = n - n2;
                MapEditor.this.table.getColumn(0).setWidth(n2);
                MapEditor.this.table.getColumn(1).setWidth(n3);
            }
        });
        this.rightMenu = new Menu((Control)this);
        this.deleteItem = new MenuItem(this.rightMenu, 64);
        this.deleteItem.setText("&Delete property");
        this.addItem = new MenuItem(this.rightMenu, 64);
        this.addItem.setText("&Add property");
        MenuItem menuItem = new MenuItem(this.rightMenu, 64);
        menuItem.setText("&Copy");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray;
                int n = ((MapEditor)MapEditor.this).table.getDisplay().getCursorLocation().x - MapEditor.this.getShell().getLocation().x;
                TableColumn[] tableColumnArray = MapEditor.this.table.getColumns();
                int n2 = 0;
                String string = "";
                for (int i = 0; i < tableColumnArray.length; ++i) {
                    if ((n2 += tableColumnArray[i].getWidth()) < n) continue;
                    tableItemArray = MapEditor.this.table.getSelection();
                    if (tableItemArray.length == 0) {
                        return;
                    }
                    string = tableItemArray[0].getText(i);
                    break;
                }
                tableItemArray = new Clipboard(MapEditor.this.getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                tableItemArray.setContents(new Object[]{string}, new Transfer[]{textTransfer});
                tableItemArray.dispose();
            }
        });
        this.deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = MapEditor.this.table.getSelection();
                for (int i = 0; i < tableItemArray.length; ++i) {
                    MapEditor.this.notifyTableItemDeletion(tableItemArray[i]);
                    tableItemArray[i].dispose();
                }
            }
        });
        this.addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = MapEditor.this.table.getSelection();
                String string = tableItemArray.length == 0 ? InputBox.prompt(MapEditor.this.getShell(), "New property name") : InputBox.prompt(MapEditor.this.getShell(), MapEditor.this.getShell().getBounds().x + tableItemArray[0].getBounds((int)0).x, MapEditor.this.getShell().getBounds().y + tableItemArray[0].getBounds((int)0).y, "New property name");
                if (string == null) {
                    return;
                }
                int n = MapEditor.this.findIndexForNewItem(string, 0);
                TableItem tableItem = new TableItem(MapEditor.this.table, 0, n);
                tableItem.setText(0, string);
                MapEditor.this.table.select(n);
                MapEditor.this.notifyTableItemAddition(tableItem);
            }
        });
        this.addTableItemChangeListener(new TableItemChangeListener(){

            public void tableItemChanged(TableItem tableItem, int n) throws TableItemChangeException {
                String string = tableItem.getText(0);
                String string2 = tableItem.getText(1);
                Object v = MapEditor.this.map.get(string);
                if (v == null || v instanceof String) {
                    MapEditor.this.map.put(string, string2);
                } else {
                    try {
                        Constructor<?> constructor = v.getClass().getConstructor(class$java$lang$String == null ? (class$java$lang$String = MapEditor.class$("java.lang.String")) : class$java$lang$String);
                    }
                    catch (SecurityException securityException) {
                        throw new TableItemChangeException(securityException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new TableItemChangeException(noSuchMethodException);
                    }
                }
            }

            public void tableItemDeleted(TableItem tableItem) {
                String string = tableItem.getText(0);
                MapEditor.this.map.remove(string);
            }

            public void tableItemAdded(TableItem tableItem) {
                String string = tableItem.getText(0);
                String string2 = tableItem.getText(1);
                MapEditor.this.map.put(string, string2);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                MapEditor.this.table.dispose();
                MapEditor.this.group.dispose();
                MapEditor.this.rightMenu.dispose();
                MapEditor.this.bgColor.dispose();
            }
        });
    }

    private int findIndexForNewItem(String string, int n) {
        TableItem[] tableItemArray = this.table.getItems();
        if (string == null) {
            return tableItemArray.length;
        }
        for (int i = 0; i < tableItemArray.length; ++i) {
            if (tableItemArray[i].getText(n).compareTo(string) <= 0) continue;
            return i;
        }
        return tableItemArray.length;
    }

    public void setValueEditable(boolean bl) {
        if (bl) {
            this.table.addSelectionListener((SelectionListener)this.editableSelectionAdapter);
        } else {
            this.table.removeSelectionListener((SelectionListener)this.editableSelectionAdapter);
        }
    }

    public void setListEditable(boolean bl) {
        if (bl) {
            this.table.addMouseListener((MouseListener)this.rightMenuShowerMouseListener);
        } else {
            this.table.removeMouseListener((MouseListener)this.rightMenuShowerMouseListener);
        }
    }

    public void addTableItemChangeListener(TableItemChangeListener tableItemChangeListener) {
        this.tableItemChangeListeners.add(tableItemChangeListener);
    }

    public void removeTableItemChangeListener(TableItemChangeListener tableItemChangeListener) {
        this.tableItemChangeListeners.remove(tableItemChangeListener);
    }

    private void notifyTableItemChange(TableItem tableItem, int n) throws TableItemChangeException {
        Iterator iterator = this.tableItemChangeListeners.iterator();
        while (iterator.hasNext()) {
            TableItemChangeListener tableItemChangeListener = (TableItemChangeListener)iterator.next();
            tableItemChangeListener.tableItemChanged(tableItem, n);
        }
    }

    private void notifyTableItemDeletion(TableItem tableItem) {
        Iterator iterator = this.tableItemChangeListeners.iterator();
        while (iterator.hasNext()) {
            TableItemChangeListener tableItemChangeListener = (TableItemChangeListener)iterator.next();
            tableItemChangeListener.tableItemDeleted(tableItem);
        }
    }

    private void notifyTableItemAddition(TableItem tableItem) {
        Iterator iterator = this.tableItemChangeListeners.iterator();
        while (iterator.hasNext()) {
            TableItemChangeListener tableItemChangeListener = (TableItemChangeListener)iterator.next();
            tableItemChangeListener.tableItemAdded(tableItem);
        }
    }

    public Map getMap() {
        return this.map;
    }

    public void setProperties(Properties properties) {
        this.map = properties;
        this.updatePropertiesTable(properties);
    }

    public static Properties open(Shell shell, int n, int n2, Properties properties) {
        return new PropertiesEditorDialog(shell, n, n2, properties).open();
    }

    public static Properties open(Shell shell, Properties properties) {
        return MapEditor.open(shell, shell.getLocation().x + 10, shell.getLocation().y + 10, properties);
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Test of MapEditor with System properties");
        Properties properties = MapEditor.open(shell, System.getProperties());
        properties.list(System.out);
    }

    static class PropertiesEditorDialog
    extends Dialog {
        private Properties properties;
        private int x;
        private int y;

        PropertiesEditorDialog(Shell shell, int n, int n2, Properties properties) {
            super(shell);
            this.properties = properties;
            this.x = n;
            this.y = n2;
        }

        public Properties open() {
            Shell shell = this.getParent();
            Shell shell2 = new Shell(shell, 67680);
            shell2.setLocation(this.x, this.y);
            shell2.setText(this.getText());
            shell2.setLayout((Layout)new FillLayout());
            MapEditor mapEditor = new MapEditor((Composite)shell2, "Properties", this.properties);
            shell2.open();
            Display display = shell.getDisplay();
            while (!shell2.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return this.properties;
        }
    }

    class EditableSelectionAdapter
    extends SelectionAdapter {
        private int column;

        EditableSelectionAdapter(int n) {
            this.column = n;
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            int n = MapEditor.this.table.getSelectionIndex();
            String string = MapEditor.this.table.getItem(n).getText(1);
            int n2 = MapEditor.this.table.getColumn(0).getWidth() - 4;
            int n3 = 2 + TABLE_INSET_VERTICAL + (n - MapEditor.this.table.getTopIndex()) * MapEditor.this.table.getItemHeight();
            int n4 = MapEditor.this.table.getColumn(1).getWidth();
            if (MapEditor.this.table.getVerticalBar() != null) {
                n4 -= ((MapEditor)MapEditor.this).table.getVerticalBar().getSize().x;
            }
            int n5 = MapEditor.this.table.getItemHeight();
            Shell shell = new Shell(MapEditor.this.table.getShell(), 8);
            TableItem tableItem = MapEditor.this.table.getItem(n);
            Point point = MapEditor.this.table.toDisplay(((MapEditor)MapEditor.this).table.getLocation().x, ((MapEditor)MapEditor.this).table.getLocation().y);
            shell.setBounds(point.x + n2, point.y + n3, n4, n5);
            Text text = new Text((Composite)shell, 16388);
            text.setBounds(0, 0, n4, n5);
            text.setBackground(MapEditor.this.bgColor);
            text.setText(string);
            text.setSelection(0, string.length());
            text.moveAbove(null);
            EditableListener editableListener = new EditableListener(shell, text, MapEditor.this.table.getItem(n));
            text.addFocusListener((FocusListener)editableListener);
            text.addSelectionListener((SelectionListener)editableListener);
            shell.open();
            text.forceFocus();
        }

        class EditableListener
        extends FocusAdapter
        implements SelectionListener {
            private Text text;
            private TableItem itemToUpdate;
            private Shell tempShell;

            EditableListener(Shell shell, Text text, TableItem tableItem) {
                this.text = text;
                this.itemToUpdate = tableItem;
                this.tempShell = shell;
            }

            public void focusLost(FocusEvent focusEvent) {
                this.updateMapElement();
                this.tempShell.dispose();
            }

            private void updateMapElement() {
                try {
                    this.itemToUpdate.setText(EditableSelectionAdapter.this.column, this.text.getText());
                    MapEditor.this.notifyTableItemChange(this.itemToUpdate, EditableSelectionAdapter.this.column);
                    this.text.dispose();
                    this.text = null;
                }
                catch (TableItemChangeException tableItemChangeException) {
                    MessageBox messageBox = new MessageBox(MapEditor.this.getShell(), 33);
                    messageBox.setMessage("It is not possible to create a new object based on the given string (" + tableItemChangeException.getCause().getMessage() + ")");
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.updateMapElement();
                this.tempShell.dispose();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        }
    }

    public static interface TableItemChangeListener {
        public void tableItemChanged(TableItem var1, int var2) throws TableItemChangeException;

        public void tableItemDeleted(TableItem var1);

        public void tableItemAdded(TableItem var1);
    }

    public static class TableItemChangeException
    extends Exception {
        public TableItemChangeException() {
        }

        public TableItemChangeException(String string) {
            super(string);
        }

        public TableItemChangeException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public TableItemChangeException(Throwable throwable) {
            super(throwable);
        }
    }
}

