/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util.listener;

import com.deltax.util.listener.ExceptionSignal;
import com.deltax.util.listener.Listener;
import com.deltax.util.listener.MsgSignal;
import com.deltax.util.listener.NamedSignal;
import com.deltax.util.listener.Signal;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class SimpleListener
implements Listener {
    private PrintWriter out;
    private boolean autoFlushing = true;

    public SimpleListener() {
        this(System.out);
    }

    public SimpleListener(OutputStream outputStream) {
        this.out = new PrintWriter(outputStream);
    }

    public SimpleListener(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void receive(Signal signal) {
        if (signal instanceof NamedSignal) {
            this.out.println(((NamedSignal)signal).getName() + " received");
        } else if (signal instanceof MsgSignal) {
            this.out.println(((MsgSignal)signal).getMsg());
        } else if (signal instanceof ExceptionSignal) {
            this.out.println("Exception signal raised by " + signal.getSource());
            ((ExceptionSignal)signal).getException().printStackTrace(this.out);
        } else {
            this.out.println("Signal by " + signal.getSource());
        }
        if (this.autoFlushing) {
            this.flush();
        }
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    public boolean isAutoFlushing() {
        return this.autoFlushing;
    }

    public void setAutoFlushing(boolean bl) {
        this.autoFlushing = bl;
    }
}

