/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util.listener;

import com.deltax.util.FIFOQueue;
import com.deltax.util.QueueEmptyException;
import com.deltax.util.listener.ExceptionListener;
import com.deltax.util.listener.ExceptionSignal;
import com.deltax.util.listener.Listener;
import com.deltax.util.listener.Signal;
import java.util.ArrayList;

class SignalQueue
extends Thread
implements Listener {
    private FIFOQueue queue = new FIFOQueue();
    private Listener listener;
    private boolean shutDown = false;
    public static final int SLEEPING_INTERVAL = 1000;

    public SignalQueue(Listener listener) {
        this.listener = listener;
        this.setDaemon(true);
    }

    public void doStop() {
        this.shutDown = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Signal signal) {
        FIFOQueue fIFOQueue = this.queue;
        synchronized (fIFOQueue) {
            this.queue.put(signal);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getQueueState() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.queue;
        synchronized (this.queue) {
            for (int i = 0; i < this.queue.size(); ++i) {
                arrayList.add(this.queue.peek(i).toString());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shutDown) {
            Object object;
            if (this.queue.isEmpty()) {
                object = this.queue;
                synchronized (object) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.shutDown) {
                            interruptedException.printStackTrace(System.err);
                        }
                        SignalQueue.interrupted();
                    }
                    continue;
                }
            }
            object = null;
            FIFOQueue fIFOQueue = this.queue;
            synchronized (fIFOQueue) {
                try {
                    object = (Signal)this.queue.get();
                }
                catch (QueueEmptyException queueEmptyException) {
                    continue;
                }
            }
            if (object instanceof ExceptionSignal && this.listener instanceof ExceptionListener) {
                ((ExceptionListener)this.listener).receiveException((ExceptionSignal)object);
                continue;
            }
            this.listener.receive((Signal)object);
        }
    }

    public Listener getListener() {
        return this.listener;
    }
}

