/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util.listener;

import com.deltax.util.listener.BlockedListenerException;
import com.deltax.util.listener.IListenerSupport;
import com.deltax.util.listener.Listener;
import com.deltax.util.listener.Signal;
import com.deltax.util.listener.SignalQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.sadun.util.tp.ThreadPool;

public class ListenerSupport
implements IListenerSupport {
    public static final long DEFAULT_RECEIVE_TIMEOUT = 10000L;
    protected Object lock = new Object();
    private HashMap queueTable = new HashMap();
    private long receiveTimeout = 10000L;
    private ThreadPool threadPool;

    public ListenerSupport(int n) {
        if (n > 0) {
            this.threadPool = new ThreadPool(n);
        }
    }

    public ListenerSupport() {
        this(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            SignalQueue signalQueue = new SignalQueue(listener);
            if (this.threadPool == null) {
                signalQueue.start();
            } else if (!this.threadPool.start(signalQueue)) {
                throw new RuntimeException("Could not start signal queue thread");
            }
            this.queueTable.put(listener, signalQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.queueTable.keySet().iterator();
            while (iterator.hasNext()) {
                ((SignalQueue)this.queueTable.get(iterator.next())).doStop();
            }
            this.queueTable.clear();
        }
    }

    public boolean isRegistered(Listener listener) {
        return this.queueTable.get(listener) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Signal signal) {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.queueTable.keySet().iterator();
            while (iterator.hasNext()) {
                ((SignalQueue)this.queueTable.get(iterator.next())).receive(signal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) throws BlockedListenerException {
        Object object = this.lock;
        synchronized (object) {
            SignalQueue signalQueue = (SignalQueue)this.queueTable.get(listener);
            if (signalQueue == null) {
                return;
            }
            signalQueue.doStop();
            try {
                signalQueue.join(this.receiveTimeout);
                if (signalQueue.isAlive()) {
                    throw new BlockedListenerException("The listener " + listener + " did not return from receive() in time and appears to be blocked");
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.queueTable.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SignalQueue[] getQueues() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            SignalQueue[] signalQueueArray = this.queueTable.keySet().iterator();
            while (signalQueueArray.hasNext()) {
                arrayList.add(this.queueTable.get(signalQueueArray.next()));
            }
            signalQueueArray = new SignalQueue[arrayList.size()];
            arrayList.toArray(signalQueueArray);
            return signalQueueArray;
        }
    }

    public int countListeners() {
        return this.queueTable.keySet().size();
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long l) {
        this.receiveTimeout = l;
    }
}

