/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util;

import com.deltax.util.TimeIntervalFormatException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class TimeInterval
implements Serializable {
    private static final long _MILLISECOND = 1L;
    private static final long _SECOND = 1000L;
    private static final long _MINUTE = 60000L;
    private static final long _HOUR = 3600000L;
    private static final long _DAY = 86400000L;
    private static final long _WEEK = 604800000L;
    private static final long[] values = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 604800000L};
    private static final int MILLISECOND_INDEX = 0;
    private static final int SECOND_INDEX = 1;
    private static final int MINUTE_INDEX = 2;
    private static final int HOUR_INDEX = 3;
    private static final int DAY_INDEX = 4;
    private static final int WEEK_INDEX = 5;
    private static final String[][] desc = new String[][]{{"millisecond", "msec", "ms"}, {"second", "sec", "ss"}, {"minute", "min", "m", "mm"}, {"hour", "hr", "h", "hh"}, {"day", "d", "dd"}, {"week", "wk", "ww"}};
    public static final long MILLISECOND = values[0];
    public static final long SECOND = values[1];
    public static final long MINUTE = values[2];
    public static final long HOUR = values[3];
    public static final long DAY = values[4];
    public static final long WEEK = values[5];
    public static final String[] MILLISECOND_STR = desc[0];
    public static final String[] SECOND_STR = desc[1];
    public static final String[] MINUTE_STR = desc[2];
    public static final String[] HOUR_STR = desc[3];
    public static final String[] DAY_STR = desc[4];
    public static final String[] WEEK_STR = desc[5];
    public long milliseconds;
    public long seconds;
    public long weeks;
    public long days;
    public long hours;
    public long minutes;

    public TimeInterval() {
        this(0L, 0L, 0L, 0L, 0L, 0L);
    }

    public TimeInterval(long l) {
        this.weeks = l / WEEK;
        this.days = l % WEEK / DAY;
        this.hours = l % WEEK % DAY / HOUR;
        this.minutes = l % WEEK % DAY % HOUR / MINUTE;
        this.seconds = l % WEEK % DAY % HOUR % MINUTE / SECOND;
        this.milliseconds = l % WEEK % DAY % HOUR % MINUTE % SECOND / MILLISECOND;
    }

    public TimeInterval(long l, long l2, long l3, long l4, long l5, long l6) {
        this.weeks = l;
        this.days = l2;
        this.hours = l3;
        this.minutes = l4;
        this.seconds = l5;
        this.milliseconds = l6;
    }

    public TimeInterval(String string) throws TimeIntervalFormatException {
        TimeInterval timeInterval = TimeInterval.parse(string);
        this.weeks = timeInterval.weeks;
        this.days = timeInterval.days;
        this.hours = timeInterval.hours;
        this.minutes = timeInterval.minutes;
        this.seconds = timeInterval.seconds;
        this.milliseconds = timeInterval.milliseconds;
    }

    private static long addElementValue(TimeInterval timeInterval, String string) throws TimeIntervalFormatException {
        string.toLowerCase();
        for (int i = 0; i < desc.length; ++i) {
            for (int j = 0; j < desc[i].length; ++j) {
                if (!string.endsWith(desc[i][j]) && !string.endsWith(desc[i][j] + "s")) continue;
                string = string.substring(0, string.lastIndexOf(desc[i][j]));
                try {
                    long l = Long.parseLong(string);
                    switch (i) {
                        case 0: {
                            timeInterval.milliseconds += l;
                            break;
                        }
                        case 1: {
                            timeInterval.seconds += l;
                            break;
                        }
                        case 2: {
                            timeInterval.minutes += l;
                            break;
                        }
                        case 3: {
                            timeInterval.hours += l;
                            break;
                        }
                        case 4: {
                            timeInterval.days += l;
                            break;
                        }
                        case 5: {
                            timeInterval.weeks += l;
                        }
                    }
                    return values[i] * l;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TimeIntervalFormatException();
                }
            }
        }
        throw new TimeIntervalFormatException(string);
    }

    public long getTime() {
        return WEEK * this.weeks + DAY * this.days + HOUR * this.hours + MINUTE * this.minutes + SECOND * this.seconds + MILLISECOND * this.milliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeDescr() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            if (this.weeks != 0L) {
                stringBuffer.append(this.weeks);
                stringBuffer.append(" week");
                if (this.weeks > 1L) {
                    stringBuffer.append("s");
                }
                if (this.days != 0L || this.hours != 0L || this.minutes != 0L) {
                    stringBuffer.append(",");
                }
            }
            if (this.days != 0L) {
                if (this.weeks != 0L) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.days);
                stringBuffer.append(" day");
                if (this.days > 1L) {
                    stringBuffer.append("s");
                }
                if (this.hours != 0L || this.minutes != 0L) {
                    stringBuffer.append(",");
                }
            }
            if (this.hours != 0L) {
                if (this.days != 0L) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.hours);
                stringBuffer.append(" hour");
                if (this.hours > 1L) {
                    stringBuffer.append("s");
                }
                if (this.minutes != 0L) {
                    stringBuffer.append(",");
                }
            }
            if (this.minutes != 0L) {
                if (this.hours != 0L) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.minutes);
                stringBuffer.append(" minute");
                if (this.minutes > 1L) {
                    stringBuffer.append("s");
                }
            }
            if (this.seconds != 0L) {
                if (this.minutes != 0L) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.seconds);
                stringBuffer.append(" second");
                if (this.seconds > 1L) {
                    stringBuffer.append("s");
                }
            }
            if (this.milliseconds != 0L) {
                if (this.seconds != 0L) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.milliseconds);
                stringBuffer.append(" millisecond");
                if (this.milliseconds > 1L) {
                    stringBuffer.append("s");
                }
            }
            if (stringBuffer.length() == 0) {
                return "0 milliseconds";
            }
            return stringBuffer.toString();
        }
    }

    public static TimeInterval parse(String string) throws TimeIntervalFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " +,");
        TimeInterval timeInterval = new TimeInterval();
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + stringTokenizer.nextToken();
            try {
                Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                TimeInterval.addElementValue(timeInterval, string2);
                string2 = "";
            }
        }
        return timeInterval;
    }

    public static String describe(long l) {
        return new TimeInterval(l).toString();
    }

    public boolean longer(TimeInterval timeInterval) {
        return this.getTime() > timeInterval.getTime();
    }

    public boolean shorter(TimeInterval timeInterval) {
        return this.getTime() < timeInterval.getTime();
    }

    public String toString() {
        return this.makeDescr();
    }

    public boolean equals(Object object) {
        if (object instanceof TimeInterval) {
            TimeInterval timeInterval = (TimeInterval)object;
            return this.getTime() == timeInterval.getTime();
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.getTime()).hashCode();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Please provide a timeinterval descriptor or a milliseconds value");
        } else {
            if (stringArray[0].endsWith("ms")) {
                stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 2);
            }
            try {
                System.out.println(stringArray[0] + "ms: \"" + new TimeInterval(Long.parseLong(stringArray[0])).toString() + "\"");
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(TimeInterval.parse(stringArray[0]).getTime() + "ms");
            }
        }
    }
}

