/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class SignatureAnalyzer {
    private String signature;
    private String returnTypeName;
    private String[] paramTypeNames;
    private int count;
    private boolean excludePrimitive;
    private boolean excludeArrays;

    public SignatureAnalyzer(String string, boolean bl, boolean bl2) {
        this.signature = string;
        this.excludePrimitive = bl;
        this.excludeArrays = bl2;
        ArrayList arrayList = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        this.parse(string, stringBuffer, arrayList);
        this.returnTypeName = stringBuffer.toString();
        if ("".equals(this.returnTypeName) && bl) {
            this.returnTypeName = null;
        }
        this.paramTypeNames = new String[arrayList.size()];
        arrayList.toArray(this.paramTypeNames);
        this.count = 0;
    }

    public SignatureAnalyzer(String string) {
        this(string, false, false);
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public int countParameters() {
        return this.count;
    }

    public boolean hasMoreParameters() {
        return this.count < this.paramTypeNames.length;
    }

    public String nextParameterTypeName() {
        if (!this.hasMoreParameters()) {
            throw new NoSuchElementException();
        }
        return this.paramTypeNames[this.count++];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String string, StringBuffer stringBuffer, List list) {
        int n;
        if (string == null) {
            throw new IllegalArgumentException(string + " is not a valid signature");
        }
        if ("".equals(string)) {
            throw new IllegalArgumentException(string + " is not a valid signature");
        }
        if (string.charAt(0) != '(') {
            throw new IllegalArgumentException(string + " is not a valid signature");
        }
        int n2 = string.indexOf(41);
        int n3 = 1;
        StringBuffer stringBuffer2 = new StringBuffer();
        CharSequence charSequence = stringBuffer2;
        synchronized (charSequence) {
            block7: while (n3 < n2) {
                n = string.charAt(n3);
                switch (n) {
                    case 91: {
                        ++n3;
                        if (this.excludeArrays) continue block7;
                        stringBuffer2.append("[");
                        continue block7;
                    }
                    case 76: {
                        int n4 = string.indexOf(59, n3);
                        if (n4 >= n2) {
                            throw new IllegalArgumentException(string + " is not a valid signature");
                        }
                        stringBuffer2.append(string.substring(n3, n4 + 1));
                        n3 = n4 + 1;
                        list.add(SignatureAnalyzer.getJavaTypeName(stringBuffer2.toString()));
                        stringBuffer2.delete(0, stringBuffer2.length());
                        continue block7;
                    }
                }
                stringBuffer2.append((char)n);
                if (!this.excludePrimitive) {
                    list.add(SignatureAnalyzer.getJavaTypeName(stringBuffer2.toString()));
                }
                stringBuffer2.delete(0, stringBuffer2.length());
                ++n3;
            }
        }
        charSequence = string.substring(n2 + 1);
        if (this.excludePrimitive || this.excludeArrays) {
            for (n = 0; n < ((String)charSequence).length() && ((String)charSequence).charAt(n) == '['; ++n) {
            }
            if (this.excludePrimitive && ((String)charSequence).length() - n == 1) {
                return;
            }
            if (this.excludeArrays && n > 0) {
                charSequence = ((String)charSequence).substring(n);
            }
        }
        stringBuffer.append(SignatureAnalyzer.getJavaTypeName((String)charSequence));
    }

    public static String getJavaPrimitiveTypeName(char c) {
        if ('B' == c) {
            return "byte";
        }
        if ('C' == c) {
            return "char";
        }
        if ('D' == c) {
            return "double";
        }
        if ('F' == c) {
            return "float";
        }
        if ('I' == c) {
            return "int";
        }
        if ('J' == c) {
            return "long";
        }
        if ('S' == c) {
            return "short";
        }
        if ('Z' == c) {
            return "boolean";
        }
        if ('V' == c) {
            return "void";
        }
        throw new IllegalArgumentException("Invalid primitive type descriptor \"" + c + "\"");
    }

    public static char getInternalPrimitiveTypeDescriptor(String string) {
        if ("byte".equals(string)) {
            return 'B';
        }
        if ("char".equals(string)) {
            return 'C';
        }
        if ("double".equals(string)) {
            return 'D';
        }
        if ("float".equals(string)) {
            return 'F';
        }
        if ("int".equals(string)) {
            return 'I';
        }
        if ("long".equals(string)) {
            return 'J';
        }
        if ("short".equals(string)) {
            return 'S';
        }
        if ("boolean".equals(string)) {
            return 'Z';
        }
        if ("void".equals(string)) {
            return 'V';
        }
        throw new IllegalArgumentException("Invalid primitive type name \"" + string + "\"");
    }

    public static String getJavaTypeName(String string) {
        if (string.length() == 1) {
            return SignatureAnalyzer.getJavaPrimitiveTypeName(string.charAt(0));
        }
        if (string.startsWith("L")) {
            int n = string.indexOf(59);
            if (n == -1) {
                throw new IllegalArgumentException("Invalid type descriptor \"" + string + "\"");
            }
            return string.substring(1, n).replace('/', '.');
        }
        if (string.startsWith("[")) {
            if (string.length() == 1) {
                throw new IllegalArgumentException("Invalid type descriptor \"" + string + "\"");
            }
            return SignatureAnalyzer.getJavaTypeName(string.substring(1)) + "[]";
        }
        throw new IllegalArgumentException("Invalid type descriptor \"" + string + "\"");
    }

    public static String getJavaTypeName(Class clazz) {
        if (clazz.isPrimitive()) {
            if (Byte.TYPE == clazz) {
                return "byte";
            }
            if (Character.TYPE == clazz) {
                return "char";
            }
            if (Boolean.TYPE == clazz) {
                return "boolean";
            }
            if (Short.TYPE == clazz) {
                return "short";
            }
            if (Integer.TYPE == clazz) {
                return "int";
            }
            if (Long.TYPE == clazz) {
                return "long";
            }
            if (Double.TYPE == clazz) {
                return "double";
            }
            if (Float.TYPE == clazz) {
                return "float";
            }
            if (Void.TYPE == clazz) {
                return "void";
            }
            throw new RuntimeException("Unexpected type " + clazz);
        }
        if (clazz.isArray()) {
            return SignatureAnalyzer.getJavaTypeName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static Class getTypeClass(String string) throws ClassNotFoundException {
        try {
            if (string.endsWith("[]")) {
                Class clazz = SignatureAnalyzer.getTypeClass(string.substring(0, string.length() - 2));
                return Array.newInstance(clazz, 0).getClass();
            }
            return SignatureAnalyzer.getPrimitiveTypeClass(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Class.forName(string);
        }
    }

    public static Class getPrimitiveTypeClass(String string) {
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        if ("char".equals(string)) {
            return Character.TYPE;
        }
        if ("double".equals(string)) {
            return Double.TYPE;
        }
        if ("float".equals(string)) {
            return Float.TYPE;
        }
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("long".equals(string)) {
            return Long.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("boolean".equals(string)) {
            return Boolean.TYPE;
        }
        if ("void".equals(string)) {
            return Void.TYPE;
        }
        throw new IllegalArgumentException("Invalid primitive type name \"" + string + "\"");
    }

    public static boolean isPrimitiveTypeName(String string) {
        if ("byte".equals(string)) {
            return true;
        }
        if ("char".equals(string)) {
            return true;
        }
        if ("double".equals(string)) {
            return true;
        }
        if ("float".equals(string)) {
            return true;
        }
        if ("int".equals(string)) {
            return true;
        }
        if ("long".equals(string)) {
            return true;
        }
        if ("short".equals(string)) {
            return true;
        }
        if ("boolean".equals(string)) {
            return true;
        }
        return "void".equals(string);
    }
}

