/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JPanelOutputStream
extends OutputStream {
    protected int maxLines;
    protected JPanel panel;
    protected JList list;
    protected StringBuffer sb = new StringBuffer();
    protected String lineSep = System.getProperty("line.separator");
    private JScrollPane listScrollPane;

    public JPanelOutputStream() {
        this(-1);
    }

    public JPanelOutputStream(int n) {
        this.panel = new JPanel();
        this.maxLines = n;
        this.panel.setLayout(new BorderLayout());
        this.list = new JList();
        this.list.setModel(new DefaultListModel());
        this.listScrollPane = new JScrollPane(this.list);
        this.panel.add("Center", this.listScrollPane);
        this.list.setForeground(Color.red);
        this.setFont(new Font("Monospaced", 0, 12));
    }

    public void setFont(Font font) {
        this.list.setFont(font);
    }

    public Font getFont() {
        return this.list.getFont();
    }

    public JPanelOutputStream(String[] stringArray) {
        this(-1);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultListModel.addElement(stringArray[i]);
        }
    }

    public void clear() {
        this.list.setSelectionInterval(0, this.list.getModel().getSize() - 1);
        this.list.clearSelection();
        this.list.updateUI();
    }

    public String getContents() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = this.list.getModel().getSize();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        for (int i = 0; i < n; ++i) {
            printWriter.println(defaultListModel.get(i));
        }
        return stringWriter.toString();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void write(int n) throws IOException {
        this.sb.append((char)n);
        if (this.sb.toString().endsWith(this.lineSep)) {
            String string = this.sb.toString();
            DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
            defaultListModel.addElement(string.substring(0, string.length() - this.lineSep.length()));
            this.sb.delete(0, this.sb.length());
        }
    }

    public void flush() {
        for (int i = 0; i < this.lineSep.length(); ++i) {
            try {
                this.write(this.lineSep.charAt(i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

