/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public class DebugInputStream
implements DataInput {
    private DataInputStream dis;
    protected long debug_readcount = 0L;

    public DebugInputStream(DataInputStream dataInputStream) {
        this.dis = dataInputStream;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.dis.readFully(byArray);
        this.debug_readcount += (long)byArray.length;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.dis.readFully(byArray, n, n2);
        this.debug_readcount += (long)n2;
    }

    public int skipBytes(int n) throws IOException {
        this.debug_readcount += (long)n;
        return this.dis.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        ++this.debug_readcount;
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        ++this.debug_readcount;
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        ++this.debug_readcount;
        return this.dis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        this.debug_readcount += 2L;
        return this.dis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        this.debug_readcount += 2L;
        return this.dis.readUnsignedShort();
    }

    public char readChar() throws IOException {
        this.debug_readcount += 2L;
        return this.dis.readChar();
    }

    public int readInt() throws IOException {
        this.debug_readcount += 4L;
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        this.debug_readcount += 8L;
        return this.dis.readLong();
    }

    public float readFloat() throws IOException {
        this.debug_readcount += 4L;
        return this.dis.readFloat();
    }

    public double readDouble() throws IOException {
        this.debug_readcount += 8L;
        return this.dis.readDouble();
    }

    public String readLine() throws IOException {
        throw new RuntimeException("readLine not supported in DebugInputStream");
    }

    public String readUTF() throws IOException {
        String string = this.dis.readUTF();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    break;
                }
                case 12: 
                case 13: {
                    n2 += 2;
                    break;
                }
                case 14: {
                    n2 += 3;
                }
            }
        }
        this.debug_readcount += (long)(n2 + 2);
        return string;
    }

    public void close() throws IOException {
        this.dis.close();
    }

    public DataInputStream getInputStream() {
        return this.dis;
    }

    public long getReadCount() {
        return this.debug_readcount;
    }
}

