/*
 * Decompiled with CFR 0.152.
 */
package com.deltax.util;

import com.deltax.util.ClassFileFinder;
import com.deltax.util.DebugInputStream;
import com.deltax.util.JDK12ClassFileFinder;
import com.deltax.util.SignatureAnalyzer;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Vector;

public class CPoolReader {
    private static final String lineSep = System.getProperties().getProperty("line.separator");
    private static boolean debug = false;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Unknown = 127;
    public static final String CONSTANT_Class_s = "CONSTANT_Class";
    public static final String CONSTANT_Fieldref_s = "CONSTANT_Fieldref";
    public static final String CONSTANT_Methodref_s = "CONSTANT_Methodref";
    public static final String CONSTANT_InterfaceMethodref_s = "CONSTANT_InterfaceMethodref";
    public static final String CONSTANT_String_s = "CONSTANT_String";
    public static final String CONSTANT_Integer_s = "CONSTANT_Integer";
    public static final String CONSTANT_Float_s = "CONSTANT_Float";
    public static final String CONSTANT_Long_s = "CONSTANT_Long";
    public static final String CONSTANT_Double_s = "CONSTANT_Double";
    public static final String CONSTANT_NamedType_s = "CONSTANT_NameAndType";
    public static final String CONSTANT_Utf8_s = "CONSTANT_Utf8";
    public static final String CONSTANT_Unknown_s = "unknown";
    static final String[] c_names = new String[]{"CONSTANT_Utf8", "unknown", "CONSTANT_Integer", "CONSTANT_Float", "CONSTANT_Long", "CONSTANT_Double", "CONSTANT_Class", "CONSTANT_String", "CONSTANT_Fieldref", "CONSTANT_Methodref", "CONSTANT_InterfaceMethodref", "CONSTANT_NameAndType"};
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_INTERFACE = 512;
    public static final String ACC_PUBLIC_s = "PUBLIC";
    public static final String ACC_PRIVATE_s = "PRIVATE";
    public static final String ACC_PROTECTED_s = "PROTECTED";
    public static final String ACC_STATIC_s = "STATIC";
    public static final String ACC_FINAL_s = "FINAL";
    public static final String ACC_VOLATILE_s = "VOLATILE";
    public static final String ACC_TRANSIENT_s = "TRANSIENT";
    public static final String ACC_SYNCHRONIZED_s = "SYNCHRONIZED";
    public static final String ACC_NATIVE_s = "NATIVE";
    public static final String ACC_ABSTRACT_s = "ABSTRACT";
    public static final String ACC_INTERFACE_s = "INTERFACE";
    protected ClassFileFinder cff;
    private classfile classfileCache;

    public static String getConstTag_s(short s) {
        if (s > c_names.length) {
            return CONSTANT_Unknown_s;
        }
        return c_names[s - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAcc_s(short s) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            if ((s & 1) != 0) {
                stringBuffer.append("PUBLIC  ");
            }
            if ((s & 2) != 0) {
                stringBuffer.append("PRIVATE  ");
            }
            if ((s & 4) != 0) {
                stringBuffer.append("PROTECTED  ");
            }
            if ((s & 8) != 0) {
                stringBuffer.append("STATIC  ");
            }
            if ((s & 0x10) != 0) {
                stringBuffer.append("FINAL  ");
            }
            if ((s & 0x40) != 0) {
                stringBuffer.append("VOLATILE  ");
            }
            if ((s & 0x80) != 0) {
                stringBuffer.append("TRANSIENT  ");
            }
            if ((s & 0x20) != 0) {
                stringBuffer.append("SYNCHRONIZED  ");
            }
            if ((s & 0x100) != 0) {
                stringBuffer.append("NATIVE  ");
            }
            if ((s & 0x400) != 0) {
                stringBuffer.append("ABSTRACT  ");
            }
            if ((s & 0x200) != 0) {
                stringBuffer.append("INTERFACE  ");
            }
        }
        return stringBuffer.toString().trim();
    }

    public CPoolReader() {
        this(new JDK12ClassFileFinder());
    }

    public CPoolReader(String string) {
        this(new JDK12ClassFileFinder(string));
    }

    public CPoolReader(ClassFileFinder classFileFinder) {
        this.cff = classFileFinder;
    }

    public classfile readClass(String string) throws IOException, ClassNotFoundException {
        if (this.classfileCache != null && this.classfileCache.getClassName().equals(string)) {
            return this.classfileCache;
        }
        this.classfileCache = new classfile(string, new DataInputStream(this.cff.openClass(string)));
        return this.classfileCache;
    }

    public classfile readClassData(String string, InputStream inputStream) throws IOException {
        return new classfile(string, new DataInputStream(inputStream));
    }

    public classfile readClassData(InputStream inputStream) throws IOException {
        return new classfile(new DataInputStream(inputStream));
    }

    public classfile readClassData(byte[] byArray) throws IOException {
        return new classfile(new DataInputStream(new ByteArrayInputStream(byArray)));
    }

    public String[] getUsedClasses(String string) throws IOException, ClassNotFoundException {
        classfile classfile2 = this.readClass(string);
        String[] stringArray = classfile2.getUsedClasses();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace('/', '.');
        }
        return stringArray;
    }

    public boolean forNameCalled(String string) throws IOException, ClassNotFoundException {
        return this.readClass(string).forNameCalled();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("CPoolReader [-debug] <class name>");
            System.exit(0);
        }
        int n = 0;
        if (stringArray.length > 1) {
            if ("-debug".equals(stringArray[0])) {
                debug = true;
            }
            ++n;
        }
        CPoolReader cPoolReader = new CPoolReader();
        classfile classfile2 = cPoolReader.readClass(stringArray[n]);
        if (!debug) {
            System.out.println(classfile2);
            System.out.println();
            System.out.println("Used classes: ");
            String[] stringArray2 = classfile2.getUsedClasses();
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println(stringArray2[i]);
            }
        }
    }

    public class classfile {
        String className;
        int magic;
        short minor_version;
        short major_version;
        cp_info[] constant_pool;
        short access_flags;
        short this_class;
        short super_class;
        short[] interfaces;
        field_info[] fields;
        method_info[] methods;
        attribute_info[] attributes;
        int n = 1;

        public classfile(String string, byte[] byArray) throws IOException, ClassFormatError {
            this(string, new DataInputStream(new ByteArrayInputStream(byArray, 0, byArray.length)));
        }

        public classfile(byte[] byArray) throws IOException, ClassFormatError {
            this(null, new DataInputStream(new ByteArrayInputStream(byArray, 0, byArray.length)));
            this.className = this.getCPClassName(true);
        }

        public classfile(InputStream inputStream) throws IOException, ClassFormatError {
            this(null, new DataInputStream(inputStream));
            this.className = this.getCPClassName(true);
        }

        public classfile(String string, DataInputStream dataInputStream) throws IOException, ClassFormatError {
            int n;
            int n2;
            int n3;
            int n4;
            this.className = string;
            DataInput dataInput = dataInputStream;
            if (debug) {
                dataInput = new DebugInputStream(dataInputStream);
            }
            this.magic = dataInput.readInt();
            this.minor_version = dataInput.readShort();
            this.major_version = dataInput.readShort();
            int n5 = dataInput.readShort();
            if (debug) {
                System.out.println("magic = " + this.magic + System.getProperties().getProperty("line.separator") + "minor_version = " + this.minor_version + System.getProperties().getProperty("line.separator") + "major_version = " + this.major_version + System.getProperties().getProperty("line.separator") + "constant_pool_count = " + n5);
            }
            this.constant_pool = new cp_info[n5];
            for (n4 = 1; n4 < n5; ++n4) {
                this.constant_pool[n4] = this.get_cp_info(dataInput);
                if (!(this.constant_pool[n4] instanceof C_Long) && !(this.constant_pool[n4] instanceof C_Double)) continue;
                ++n4;
            }
            this.access_flags = dataInput.readShort();
            this.this_class = dataInput.readShort();
            this.super_class = dataInput.readShort();
            if (debug) {
                System.out.println("access_flags = " + this.access_flags + System.getProperties().getProperty("line.separator") + "this_class = " + this.this_class + System.getProperties().getProperty("line.separator") + "super_class = " + this.super_class);
            }
            n4 = dataInput.readShort();
            this.interfaces = new short[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.interfaces[n3] = dataInput.readShort();
            }
            n3 = dataInput.readShort();
            this.fields = new field_info[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.fields[n2] = new field_info(dataInput);
            }
            n2 = dataInput.readShort();
            this.methods = new method_info[n2];
            for (n = 0; n < n2; ++n) {
                this.methods[n] = new method_info(dataInput);
            }
            n = dataInput.readShort();
            this.attributes = new attribute_info[n];
            for (int i = 0; i < n; ++i) {
                this.attributes[i] = new attribute_info(dataInput);
            }
            if (dataInput instanceof InputStream) {
                ((InputStream)((Object)dataInput)).close();
            } else {
                ((DebugInputStream)dataInput).close();
            }
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isInterface() {
            return (this.access_flags & 0x200) > 0;
        }

        public String getCPClassName(boolean bl) {
            String string = ((C_Utf8)this.constant_pool[((C_Class)this.constant_pool[this.this_class]).name_index]).getBytesAsString();
            if (bl) {
                string = string.replace('/', '.');
            }
            return string;
        }

        public String getCPClassName() {
            return this.getCPClassName(false);
        }

        public String getSuperClass(boolean bl) {
            String string = ((C_Utf8)this.constant_pool[((C_Class)this.constant_pool[this.super_class]).name_index]).getBytesAsString();
            if (bl) {
                string = string.replace('/', '.');
            }
            return string;
        }

        public String getSuperClass() {
            return this.getSuperClass(false);
        }

        public String[] getInterfaces() {
            String[] stringArray = new String[this.interfaces.length];
            for (int i = 0; i < this.interfaces.length; ++i) {
                String string;
                stringArray[i] = string = ((C_Utf8)this.constant_pool[((C_Class)this.constant_pool[this.interfaces[i]]).name_index]).getBytesAsString();
            }
            return stringArray;
        }

        private cp_info[] getConstByTag(short s) {
            Vector<cp_info> vector = new Vector<cp_info>();
            for (int i = 1; i < this.constant_pool.length; ++i) {
                if (this.constant_pool[i].tag == s) {
                    vector.addElement(this.constant_pool[i]);
                }
                if (!(this.constant_pool[i] instanceof C_Long) && !(this.constant_pool[i] instanceof C_Double)) continue;
                ++i;
            }
            Object[] objectArray = new cp_info[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public boolean forNameCalled() {
            cp_info[] cp_infoArray = this.getConstByTag((short)7);
            int n = -1;
            for (int i = 0; i < cp_infoArray.length; ++i) {
                String string = ((C_Utf8)this.constant_pool[((C_Class)cp_infoArray[i]).name_index]).getBytesAsString();
                if (!"java/lang/Class".equals(string)) continue;
                for (int j = 0; j < this.constant_pool.length; ++j) {
                    if (!(this.constant_pool[j] instanceof C_Class) || ((C_Class)this.constant_pool[j]).name_index != ((C_Class)cp_infoArray[i]).name_index) continue;
                    n = j;
                }
            }
            if (n != -1) {
                cp_info[] cp_infoArray2 = this.getConstByTag((short)10);
                for (int i = 0; i < cp_infoArray2.length; ++i) {
                    if (((C_Methodref)cp_infoArray2[i]).class_index != n || !"forName".equals(((C_Utf8)this.constant_pool[((C_NameAndType)this.constant_pool[((C_Methodref)cp_infoArray2[i]).name_and_type_index]).name_index]).getBytesAsString()) || !"(Ljava/lang/String;)Ljava/lang/Class;".equals(((C_Utf8)this.constant_pool[((C_NameAndType)this.constant_pool[((C_Methodref)cp_infoArray2[i]).name_and_type_index]).descriptor_index]).getBytesAsString())) continue;
                    return true;
                }
            }
            return false;
        }

        public String[] getUsedClasses() {
            int n;
            HashSet<String> hashSet = new HashSet<String>();
            cp_info[] cp_infoArray = this.getConstByTag((short)7);
            for (n = 0; n < cp_infoArray.length; ++n) {
                hashSet.add(((C_Utf8)this.constant_pool[((C_Class)cp_infoArray[n]).name_index]).getBytesAsString());
            }
            for (n = 0; n < this.methods.length; ++n) {
                String string = ((C_Utf8)this.constant_pool[this.methods[n].descriptor_index]).getBytesAsString();
                SignatureAnalyzer signatureAnalyzer = new SignatureAnalyzer(string, true, true);
                while (signatureAnalyzer.hasMoreParameters()) {
                    hashSet.add(signatureAnalyzer.nextParameterTypeName());
                }
                if (signatureAnalyzer.getReturnTypeName() == null) continue;
                hashSet.add(signatureAnalyzer.getReturnTypeName());
            }
            String[] stringArray = new String[hashSet.size()];
            hashSet.toArray(stringArray);
            return stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
            synchronized (stringBuffer2) {
                int n;
                stringBuffer.append("magic = " + this.magic + lineSep + "minor_version = " + this.minor_version + lineSep + "major_version = " + this.major_version + lineSep);
                for (n = 1; n < this.constant_pool.length; ++n) {
                    stringBuffer.append("constant_pool[" + n + "] = " + this.constant_pool[n].toString());
                    stringBuffer.append(lineSep);
                    if (!(this.constant_pool[n] instanceof C_Long) && !(this.constant_pool[n] instanceof C_Double)) continue;
                    ++n;
                }
                stringBuffer.append("access_flags = " + this.access_flags + lineSep + "this_class = " + this.this_class + lineSep + "super_class = " + this.super_class + lineSep);
                stringBuffer.append(this.interfaces.length + " interface(s)");
                stringBuffer.append(lineSep);
                for (n = 0; n < this.interfaces.length; ++n) {
                    stringBuffer.append("interfaces[" + n + "] = " + this.interfaces[n]);
                    stringBuffer.append(lineSep);
                }
                stringBuffer.append(this.fields.length + " field(s)");
                stringBuffer.append(lineSep);
                for (n = 0; n < this.fields.length; ++n) {
                    stringBuffer.append("fields[" + n + "] = " + this.fields[n]);
                    stringBuffer.append(lineSep);
                }
                stringBuffer.append(this.methods.length + " method(s)");
                stringBuffer.append(lineSep);
                for (n = 0; n < this.methods.length; ++n) {
                    stringBuffer.append("methods[" + n + "] = " + this.methods[n]);
                    stringBuffer.append(lineSep);
                }
                stringBuffer.append(this.attributes.length + " attribute(s)");
                stringBuffer.append(lineSep);
                for (n = 0; n < this.attributes.length; ++n) {
                    stringBuffer.append("attributes[" + n + "] = " + this.attributes[n]);
                    stringBuffer.append(lineSep);
                }
                return stringBuffer.toString();
            }
        }

        private cp_info get_cp_info(DataInput dataInput) throws IOException, ClassFormatError {
            int n = dataInput.readUnsignedByte();
            if (debug) {
                System.out.print(this.n++ + " Tag: " + n + " -> ");
            }
            if (n == 0) {
                System.out.println(" next = " + dataInput.readUnsignedByte());
            }
            cp_info cp_info2 = null;
            switch (n) {
                case 7: {
                    cp_info2 = new C_Class(dataInput);
                    break;
                }
                case 9: {
                    cp_info2 = new C_Fieldref(dataInput);
                    break;
                }
                case 10: {
                    cp_info2 = new C_Methodref(dataInput);
                    break;
                }
                case 11: {
                    cp_info2 = new C_InterfaceMethodref(dataInput);
                    break;
                }
                case 8: {
                    cp_info2 = new C_String(dataInput);
                    break;
                }
                case 3: {
                    cp_info2 = new C_Integer(dataInput);
                    break;
                }
                case 4: {
                    cp_info2 = new C_Float(dataInput);
                    break;
                }
                case 5: {
                    cp_info2 = new C_Long(dataInput);
                    break;
                }
                case 6: {
                    cp_info2 = new C_Double(dataInput);
                    break;
                }
                case 12: {
                    cp_info2 = new C_NameAndType(dataInput);
                    break;
                }
                case 1: {
                    cp_info2 = new C_Utf8(dataInput);
                    break;
                }
                default: {
                    System.out.println("\nConstant Pool tag unknown found in class " + this.className + "!! (apparent value: " + n + (debug ? ", read count : " + ((DebugInputStream)dataInput).getReadCount() : "") + ")");
                    throw new ClassFormatError();
                }
            }
            if (debug) {
                System.out.println(cp_info2);
            }
            return cp_info2;
        }
    }

    public class attribute_info {
        short attribute_name_index;
        byte[] info;

        attribute_info(DataInput dataInput) throws IOException {
            this.attribute_name_index = dataInput.readShort();
            int n = dataInput.readInt();
            this.info = new byte[n];
            if (debug) {
                ((DebugInputStream)dataInput).getInputStream().read(this.info);
            } else {
                ((DataInputStream)dataInput).read(this.info);
            }
        }

        public String toString() {
            return "attribute_name_index = " + this.attribute_name_index + ", info = " + this.info;
        }
    }

    public class method_info
    extends MF_info {
        method_info(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        public String toString() {
            return "mehtod_info : [" + lineSep + super.toString() + lineSep + "]";
        }
    }

    public class field_info
    extends MF_info {
        field_info(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        public String toString() {
            return "field_info : [" + lineSep + super.toString() + lineSep + "]";
        }
    }

    public abstract class MF_info {
        short access_flags;
        short name_index;
        short descriptor_index;
        attribute_info[] attributes;

        MF_info(DataInput dataInput) throws IOException {
            this.access_flags = dataInput.readShort();
            this.name_index = dataInput.readShort();
            this.descriptor_index = dataInput.readShort();
            if (debug) {
                System.out.println("access_flags = (" + CPoolReader.getAcc_s(this.access_flags) + ")," + lineSep + "name_index = " + this.name_index + "," + lineSep + "descriptor_index = " + this.descriptor_index);
            }
            int n = dataInput.readShort();
            this.attributes = new attribute_info[n];
            for (int i = 0; i < n; ++i) {
                this.attributes[i] = new attribute_info(dataInput);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("access_flags = (" + CPoolReader.getAcc_s(this.access_flags) + ")," + lineSep + "name_index = " + this.name_index + "," + lineSep + "descriptor_index = " + this.descriptor_index);
            for (int i = 0; i < this.attributes.length; ++i) {
                stringBuffer.append(lineSep);
                stringBuffer.append("attribute[" + i + "] = ");
                stringBuffer.append(this.attributes[i].toString());
            }
            return stringBuffer.toString();
        }
    }

    public class C_Utf8
    extends cp_info {
        String utf;

        C_Utf8(DataInput dataInput) throws IOException {
            super((byte)1);
            this.utf = dataInput.readUTF();
        }

        public String toString() {
            return super.toString() + ", utf = \"" + this.utf + "\"]";
        }

        public String getBytesAsString() {
            return this.utf;
        }
    }

    public class C_NameAndType
    extends cp_info {
        short name_index;
        short descriptor_index;

        C_NameAndType(DataInput dataInput) throws IOException {
            super((byte)12);
            this.name_index = dataInput.readShort();
            this.descriptor_index = dataInput.readShort();
        }

        public String toString() {
            return super.toString() + ", name_index = " + this.name_index + ", descriptor_index = " + this.descriptor_index + "]";
        }
    }

    public class C_Double
    extends C_LDBase {
        C_Double(DataInput dataInput) throws IOException {
            super((byte)6, dataInput);
        }
    }

    public class C_Long
    extends C_LDBase {
        C_Long(DataInput dataInput) throws IOException {
            super((byte)5, dataInput);
        }
    }

    public abstract class C_LDBase
    extends cp_info {
        int high_bytes;
        int low_bytes;

        C_LDBase(byte by, DataInput dataInput) throws IOException {
            super(by);
            this.high_bytes = dataInput.readInt();
            this.low_bytes = dataInput.readInt();
        }

        public String toString() {
            return super.toString() + ", high_bytes = " + this.high_bytes + ", low_bytes = " + this.low_bytes + "]";
        }
    }

    public class C_Float
    extends C_IFBase {
        C_Float(DataInput dataInput) throws IOException {
            super((byte)4, dataInput);
        }
    }

    public class C_Integer
    extends C_IFBase {
        C_Integer(DataInput dataInput) throws IOException {
            super((byte)3, dataInput);
        }
    }

    public abstract class C_IFBase
    extends cp_info {
        int bytes;

        C_IFBase(byte by, DataInput dataInput) throws IOException {
            super(by);
            this.bytes = dataInput.readInt();
        }

        public String toString() {
            return super.toString() + ", bytes = " + this.bytes + "]";
        }
    }

    public class C_String
    extends cp_info {
        short string_index;

        C_String(DataInput dataInput) throws IOException {
            super((byte)8);
            this.string_index = dataInput.readShort();
        }

        public String toString() {
            return super.toString() + ", string_index = " + this.string_index + "]";
        }
    }

    public class C_InterfaceMethodref
    extends C_FMIRefBase {
        C_InterfaceMethodref(DataInput dataInput) throws IOException {
            super((byte)11, dataInput);
        }
    }

    public class C_Methodref
    extends C_FMIRefBase {
        C_Methodref(DataInput dataInput) throws IOException {
            super((byte)10, dataInput);
        }
    }

    public class C_Fieldref
    extends C_FMIRefBase {
        C_Fieldref(DataInput dataInput) throws IOException {
            super((byte)9, dataInput);
        }
    }

    public abstract class C_FMIRefBase
    extends cp_info {
        short class_index;
        short name_and_type_index;

        C_FMIRefBase(byte by, DataInput dataInput) throws IOException {
            super(by);
            this.class_index = dataInput.readShort();
            this.name_and_type_index = dataInput.readShort();
        }

        public String toString() {
            return super.toString() + ", class_index = " + this.class_index + ", name_and_type_index = " + this.name_and_type_index + "]";
        }
    }

    public class C_Class
    extends cp_info {
        short name_index;

        C_Class(DataInput dataInput) throws IOException {
            super((byte)7);
            this.name_index = dataInput.readShort();
        }

        public String toString() {
            return super.toString() + ", name_index = " + this.name_index + "]";
        }
    }

    public class unknown_cp_info
    extends cp_info {
        unknown_cp_info() {
            super((byte)127);
        }

        public String toString() {
            return super.toString() + " (UNKNOWN)]";
        }
    }

    public abstract class cp_info {
        byte tag;

        cp_info(byte by) {
            this.tag = by;
        }

        public short getTag() {
            return this.tag;
        }

        public String getTagName() {
            return CPoolReader.getConstTag_s(this.tag);
        }

        public String toString() {
            return "[Tag = " + this.tag + " " + CPoolReader.getConstTag_s(this.tag);
        }
    }
}

