/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.IOException;
import javax.faces.event.PhaseId;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.web.AbstractFilter;

@Startup
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.servlet.contextFilter")
@Install(value=false, precedence=0)
@Intercept(value=InterceptionType.NEVER)
public class ContextFilter
extends AbstractFilter {
    private static final LogProvider log = Logging.getLogProvider(ContextFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("beginning request");
        HttpSession session = ((HttpServletRequest)request).getSession(true);
        Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
        Lifecycle.setServletRequest(request);
        Lifecycle.beginRequest(this.getServletContext(), session, request);
        Manager.instance().restoreConversation(request.getParameterMap());
        Lifecycle.resumeConversation(session);
        Manager.instance().handleConversationPropagation(request.getParameterMap());
        try {
            chain.doFilter(request, response);
            Manager.instance().endRequest(ContextAdaptor.getSession(session));
            Lifecycle.endRequest(session);
        }
        catch (Exception e) {
            Lifecycle.endRequest();
            log.error("ended request due to exception", e);
            throw new ServletException((Throwable)e);
        }
        finally {
            Lifecycle.setServletRequest(null);
            Lifecycle.setPhaseId(null);
            log.debug("ended request");
        }
    }
}

