/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.seam.log.LogProvider;

public class JDKProvider
implements LogProvider {
    private final Logger logger;
    private final boolean isWrapped;

    JDKProvider(String category, boolean wrapped) {
        this.logger = Logger.getLogger(category);
        this.isWrapped = wrapped;
    }

    private void log(Level level, Object object, Throwable ex) {
        if (this.logger.isLoggable(level)) {
            int depth;
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String className = "unknown";
            String methodName = "unknown";
            int n = depth = this.isWrapped ? 3 : 2;
            if (locations != null && locations.length > depth) {
                StackTraceElement caller = locations[depth];
                className = caller.getClassName();
                methodName = caller.getMethodName();
            }
            if (ex == null) {
                this.logger.logp(level, className, methodName, String.valueOf(object));
            } else {
                this.logger.logp(level, className, methodName, String.valueOf(object), ex);
            }
        }
    }

    public void debug(Object object, Throwable t) {
        this.log(Level.FINE, object, t);
    }

    public void debug(Object object) {
        this.log(Level.FINE, object, null);
    }

    public void error(Object object, Throwable t) {
        this.log(Level.SEVERE, object, t);
    }

    public void error(Object object) {
        this.log(Level.SEVERE, object, null);
    }

    public void fatal(Object object, Throwable t) {
        this.log(Level.SEVERE, object, t);
    }

    public void fatal(Object object) {
        this.log(Level.SEVERE, object, null);
    }

    public void info(Object object, Throwable t) {
        this.log(Level.INFO, object, t);
    }

    public void info(Object object) {
        this.log(Level.INFO, object, null);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void trace(Object object, Throwable t) {
        this.log(Level.FINER, object, t);
    }

    public void trace(Object object) {
        this.log(Level.FINER, object, null);
    }

    public void warn(Object object, Throwable t) {
        this.log(Level.WARNING, object, t);
    }

    public void warn(Object object) {
        this.log(Level.WARNING, object, null);
    }
}

