/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.core.AbstractMutable;

public abstract class Selector
extends AbstractMutable
implements Serializable {
    private boolean cookieEnabled;
    private int cookieMaxAge = 31536000;

    public boolean isCookieEnabled() {
        return this.cookieEnabled;
    }

    public void setCookieEnabled(boolean cookieEnabled) {
        this.setDirty(this.cookieEnabled, cookieEnabled);
        this.cookieEnabled = cookieEnabled;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    protected abstract String getCookieName();

    protected String getCookieValue() {
        FacesContext ctx;
        Cookie cookie = null;
        if (this.isCookieEnabled() && (ctx = FacesContext.getCurrentInstance()) != null) {
            cookie = (Cookie)ctx.getExternalContext().getRequestCookieMap().get(this.getCookieName());
        }
        return cookie == null ? null : cookie.getValue();
    }

    protected void setCookieValue(String value) {
        if (this.isCookieEnabled()) {
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            Cookie cookie = new Cookie(this.getCookieName(), value);
            cookie.setMaxAge(this.getCookieMaxAge());
            response.addCookie(cookie);
        }
    }
}

