/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.event.PhaseId;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.BusinessProcessContext;
import org.jboss.seam.contexts.ClientConversationContext;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesApplicationContext;
import org.jboss.seam.contexts.MapContext;
import org.jboss.seam.contexts.PageContext;
import org.jboss.seam.contexts.ServerConversationContext;
import org.jboss.seam.contexts.WebApplicationContext;
import org.jboss.seam.contexts.WebRequestContext;
import org.jboss.seam.contexts.WebSessionContext;
import org.jboss.seam.core.BusinessProcess;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class Lifecycle {
    private static final LogProvider log = Logging.getLogProvider(Lifecycle.class);
    private static ThreadLocal<PhaseId> phaseId = new ThreadLocal();
    private static ThreadLocal<ServletRequest> servletRequest = new ThreadLocal();
    private static ServletContext servletContext;
    private static ThreadLocal<Boolean> destroying;

    public static void beginRequest(ExternalContext externalContext) {
        log.debug(">>> Begin web request");
        Contexts.eventContext.set(new WebRequestContext(ContextAdaptor.getRequest(externalContext)));
        Contexts.sessionContext.set(new WebSessionContext(ContextAdaptor.getSession(externalContext)));
        Contexts.applicationContext.set(new FacesApplicationContext(externalContext));
        Contexts.conversationContext.set(null);
    }

    public static void beginRequest(ServletContext servletContext, HttpSession session, ServletRequest request) {
        log.debug(">>> Begin web request");
        Contexts.eventContext.set(new WebRequestContext(ContextAdaptor.getRequest(request)));
        Contexts.sessionContext.set(new WebSessionContext(ContextAdaptor.getSession(session)));
        Contexts.applicationContext.set(new WebApplicationContext(servletContext));
        Contexts.conversationContext.set(null);
    }

    public static void beginCall() {
        log.debug(">>> Begin call");
        Contexts.eventContext.set(new MapContext(ScopeType.EVENT));
        Contexts.sessionContext.set(new MapContext(ScopeType.SESSION));
        Contexts.conversationContext.set(new MapContext(ScopeType.CONVERSATION));
        Contexts.businessProcessContext.set(new BusinessProcessContext());
        Contexts.applicationContext.set(new WebApplicationContext(Lifecycle.getServletContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endCall() {
        try {
            Contexts.destroy(Contexts.getSessionContext());
            Lifecycle.flushAndDestroyContexts();
            if (Manager.instance().isLongRunningConversation()) {
                throw new IllegalStateException("Do not start long-running conversations in direct calls to EJBs");
            }
        }
        finally {
            Lifecycle.clearThreadlocals();
            log.debug("<<< End call");
        }
    }

    public static void mockApplication() {
        Contexts.applicationContext.set(new WebApplicationContext(Lifecycle.getServletContext()));
    }

    public static void unmockApplication() {
        Contexts.applicationContext.set(null);
    }

    public static Context beginMethod() {
        Context result = Contexts.methodContext.get();
        Contexts.methodContext.set(new MapContext(ScopeType.METHOD));
        return result;
    }

    public static void endMethod(Context context) {
        Contexts.methodContext.set(context);
    }

    public static void beginInitialization(ServletContext servletContext) {
        Contexts.applicationContext.set(new WebApplicationContext(servletContext));
        Contexts.eventContext.set(new MapContext(ScopeType.EVENT));
        Contexts.conversationContext.set(new MapContext(ScopeType.CONVERSATION));
    }

    public static void beginExceptionRecovery(ExternalContext externalContext) {
        Contexts.applicationContext.set(new FacesApplicationContext(externalContext));
        Contexts.eventContext.set(new WebRequestContext(ContextAdaptor.getRequest(externalContext)));
        Contexts.sessionContext.set(new WebSessionContext(ContextAdaptor.getSession(externalContext)));
        Contexts.conversationContext.set(new ServerConversationContext(ContextAdaptor.getSession(externalContext)));
        Contexts.pageContext.set(null);
        Contexts.businessProcessContext.set(null);
    }

    public static void endInitialization() {
        Context context = Contexts.getApplicationContext();
        for (String name : context.getNames()) {
            Component component;
            Object object = context.get(name);
            if (object == null || !(object instanceof Component) || !(component = (Component)object).isStartup() || component.getScope() != ScopeType.APPLICATION) continue;
            Lifecycle.startup(component);
        }
        Contexts.destroy(Contexts.getConversationContext());
        Contexts.conversationContext.set(null);
        Contexts.destroy(Contexts.getEventContext());
        Contexts.eventContext.set(null);
        Contexts.applicationContext.set(null);
    }

    private static void startup(Component component) {
        if (component.isStartup()) {
            for (String dependency : component.getDependencies()) {
                Component dependentComponent = Component.forName(dependency);
                if (dependentComponent == null) continue;
                Lifecycle.startup(dependentComponent);
            }
        }
        if (!component.getScope().getContext().isSet(component.getName())) {
            log.info("starting up: " + component.getName());
            component.newInstance();
        }
    }

    public static void endApplication(ServletContext servletContext) {
        log.debug("Undeploying, destroying application context");
        WebApplicationContext tempApplicationContext = new WebApplicationContext(servletContext);
        Contexts.applicationContext.set(tempApplicationContext);
        Contexts.destroy(tempApplicationContext);
        Contexts.applicationContext.set(null);
        Contexts.eventContext.set(null);
        Contexts.sessionContext.set(null);
        Contexts.conversationContext.set(null);
    }

    public static void beginSession(ServletContext servletContext, ContextAdaptor session) {
        log.debug("Session started");
        boolean applicationContextActive = Contexts.isApplicationContextActive();
        boolean eventContextActive = Contexts.isEventContextActive();
        boolean conversationContextActive = Contexts.isConversationContextActive();
        if (!applicationContextActive) {
            WebApplicationContext tempApplicationContext = new WebApplicationContext(servletContext);
            Contexts.applicationContext.set(tempApplicationContext);
        }
        MapContext tempEventContext = null;
        if (!eventContextActive) {
            tempEventContext = new MapContext(ScopeType.EVENT);
            Contexts.eventContext.set(tempEventContext);
        }
        MapContext tempConversationContext = null;
        if (!conversationContextActive) {
            tempConversationContext = new MapContext(ScopeType.CONVERSATION);
            Contexts.conversationContext.set(tempConversationContext);
        }
        WebSessionContext tempSessionContext = new WebSessionContext(session);
        Contexts.sessionContext.set(tempSessionContext);
        for (String name : Contexts.getApplicationContext().getNames()) {
            Component component;
            Object object = Contexts.getApplicationContext().get(name);
            if (object == null || !(object instanceof Component) || !(component = (Component)object).isStartup() || component.getScope() != ScopeType.SESSION) continue;
            Lifecycle.startup(component);
        }
        Contexts.sessionContext.set(null);
        if (!conversationContextActive) {
            Contexts.destroy(tempConversationContext);
            Contexts.conversationContext.set(null);
        }
        if (!eventContextActive) {
            Contexts.destroy(tempEventContext);
            Contexts.eventContext.set(null);
        }
        if (!applicationContextActive) {
            Contexts.applicationContext.set(null);
        }
    }

    public static void endSession(ServletContext servletContext, ContextAdaptor session) {
        log.debug("End of session, destroying contexts");
        if (Contexts.isEventContextActive() || Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("Please end the HttpSession via Seam.invalidateSession()");
        }
        WebApplicationContext tempApplicationContext = new WebApplicationContext(servletContext);
        Contexts.applicationContext.set(tempApplicationContext);
        MapContext tempEventContext = new MapContext(ScopeType.EVENT);
        Contexts.eventContext.set(tempEventContext);
        WebSessionContext tempSessionContext = new WebSessionContext(session);
        Contexts.sessionContext.set(tempSessionContext);
        Set<String> conversationIds = ConversationEntries.instance().getConversationIds();
        log.debug("destroying conversation contexts: " + conversationIds);
        for (String conversationId : conversationIds) {
            Lifecycle.destroyConversationContext(session, conversationId);
        }
        MapContext tempConversationContext = new MapContext(ScopeType.CONVERSATION);
        Contexts.conversationContext.set(tempConversationContext);
        log.debug("destroying session context");
        Contexts.destroy(tempSessionContext);
        Contexts.sessionContext.set(null);
        Contexts.destroy(tempConversationContext);
        Contexts.conversationContext.set(null);
        Contexts.destroy(tempEventContext);
        Contexts.eventContext.set(null);
        Contexts.applicationContext.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest(ExternalContext externalContext) {
        log.debug("After render response, destroying contexts");
        try {
            Lifecycle.flushAndDestroyContexts();
            if (Seam.isSessionInvalid()) {
                Lifecycle.clearThreadlocals();
                Lifecycle.setPhaseId(null);
                ContextAdaptor.getSession(externalContext).invalidate();
            }
        }
        finally {
            Lifecycle.clearThreadlocals();
        }
        log.debug("<<< End web request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest() {
        log.debug("After request, destroying contexts");
        try {
            Lifecycle.flushAndDestroyContexts();
        }
        finally {
            Lifecycle.clearThreadlocals();
        }
        log.debug("<<< End web request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest(HttpSession session) {
        log.debug("After request, destroying contexts");
        try {
            Lifecycle.flushAndDestroyContexts();
            if (Seam.isSessionInvalid()) {
                Lifecycle.clearThreadlocals();
                ContextAdaptor.getSession(session).invalidate();
            }
        }
        finally {
            Lifecycle.clearThreadlocals();
        }
        log.debug("<<< End web request");
    }

    private static void clearThreadlocals() {
        Contexts.eventContext.set(null);
        Contexts.pageContext.set(null);
        Contexts.sessionContext.set(null);
        Contexts.conversationContext.set(null);
        Contexts.businessProcessContext.set(null);
        Contexts.applicationContext.set(null);
    }

    private static void flushAndDestroyContexts() {
        if (Contexts.isConversationContextActive()) {
            if (Contexts.isBusinessProcessContextActive()) {
                boolean destroyBusinessProcessContext;
                boolean bl = destroyBusinessProcessContext = !Init.instance().isJbpmInstalled() || !BusinessProcess.instance().hasActiveProcess();
                if (destroyBusinessProcessContext) {
                    log.debug("destroying business process context");
                    Contexts.destroy(Contexts.getBusinessProcessContext());
                }
            }
            if (!Manager.instance().isLongRunningConversation()) {
                log.debug("destroying conversation context");
                Contexts.destroy(Contexts.getConversationContext());
            }
            if (!Init.instance().isClientSideConversations()) {
                log.debug("flushing server-side conversation context");
                Contexts.getConversationContext().flush();
            }
        }
        Manager.instance().unlockConversation();
        if (Contexts.isSessionContextActive()) {
            log.debug("flushing session context");
            Contexts.getSessionContext().flush();
        }
        if (Contexts.isEventContextActive()) {
            log.debug("destroying event context");
            Contexts.destroy(Contexts.getEventContext());
        }
    }

    public static void resumePage() {
        Contexts.pageContext.set(new PageContext());
    }

    public static void resumeConversation(ExternalContext externalContext) {
        Init init = Init.instance();
        Context conversationContext = init.isClientSideConversations() ? new ClientConversationContext() : new ServerConversationContext(ContextAdaptor.getSession(externalContext));
        Contexts.conversationContext.set(conversationContext);
        Contexts.businessProcessContext.set(new BusinessProcessContext());
    }

    public static void resumeConversation(HttpSession session) {
        ServerConversationContext conversationContext = new ServerConversationContext(ContextAdaptor.getSession(session));
        Contexts.conversationContext.set(conversationContext);
        Contexts.businessProcessContext.set(new BusinessProcessContext());
    }

    public static PhaseId getPhaseId() {
        return phaseId.get();
    }

    public static void setPhaseId(PhaseId phase) {
        phaseId.set(phase);
    }

    public static ServletContext getServletContext() {
        if (servletContext == null) {
            throw new IllegalStateException("Attempted to invoke a Seam component outside the context of a web application");
        }
        return servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        Lifecycle.servletContext = servletContext;
    }

    public static ServletRequest getServletRequest() {
        return servletRequest.get();
    }

    public static void setServletRequest(ServletRequest servletRequest) {
        Lifecycle.servletRequest.set(servletRequest);
    }

    public static void startDestroying() {
        destroying.set(true);
    }

    public static void stopDestroying() {
        destroying.set(false);
    }

    public static boolean isDestroying() {
        Boolean value = destroying.get();
        return value != null && value != false;
    }

    public static boolean isAttributeDirty(Object attribute) {
        return attribute instanceof Mutable && ((Mutable)attribute).clearDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyConversationContext(ContextAdaptor session, String conversationId) {
        ServerConversationContext conversationContext = new ServerConversationContext(session, conversationId);
        Context old = Contexts.getConversationContext();
        Contexts.conversationContext.set(conversationContext);
        try {
            Contexts.destroy(conversationContext);
            if (!Seam.isSessionInvalid()) {
                conversationContext.clear();
                conversationContext.flush();
            }
        }
        finally {
            Contexts.conversationContext.set(old);
        }
    }

    static {
        destroying = new ThreadLocal();
    }
}

