/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.actionparam;

import java.lang.reflect.Method;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.jboss.seam.actionparam.MethodExpressionParser;

class ActionParamBindingHelper {
    private Application application;
    private String expWithParams;
    private MethodExpressionParser parser;

    ActionParamBindingHelper(Application application, String expWithParams) {
        this.application = application;
        this.expWithParams = expWithParams;
        this.parser = new MethodExpressionParser(expWithParams);
    }

    Object invokeTheExpression(FacesContext facesContext) {
        MethodBinding mb = this.makeMethodBinding(this.findParamTypes(facesContext));
        Object[] evaluatedParams = this.evaluateParams(facesContext);
        return mb.invoke(facesContext, evaluatedParams);
    }

    private Object[] evaluateParams(FacesContext facesContext) {
        String[] params = this.parser.getParams();
        Object[] results = new Object[params.length];
        for (int i = 0; i < results.length; ++i) {
            String param = params[i].trim();
            if (MethodExpressionParser.isQuotedString(param)) {
                results[i] = param.substring(1, param.length() - 1);
                continue;
            }
            ValueBinding vb = this.application.createValueBinding("#{" + param + "}");
            results[i] = vb.getValue(facesContext);
        }
        return results;
    }

    private Class[] findParamTypes(FacesContext facesContext) {
        if (this.parser.getParams().length == 0) {
            return new Class[0];
        }
        String expression = "#{" + this.parser.getBaseExpression() + "}";
        ValueBinding vb = this.application.createValueBinding(expression);
        Object obj = vb.getValue(facesContext);
        Method[] publicMethods = obj.getClass().getMethods();
        Method methodMatch = null;
        for (int i = 0; i < publicMethods.length; ++i) {
            if (!this.methodMatches(publicMethods[i])) continue;
            if (methodMatch != null) {
                throw new EvaluationException("More than one method matched " + this.expWithParams + ". Method name or number of params must be unique.");
            }
            methodMatch = publicMethods[i];
        }
        if (methodMatch == null) {
            throw new EvaluationException("No method found for expression " + this.expWithParams + ".  Method name and number of params must match.");
        }
        return methodMatch.getParameterTypes();
    }

    private boolean methodMatches(Method method) {
        return method.getName().equals(this.parser.getMethodName()) && method.getParameterTypes().length == this.parser.getParams().length;
    }

    private MethodBinding makeMethodBinding(Class[] paramTypes) {
        return this.application.createMethodBinding(this.parser.getCombinedExpression(), paramTypes);
    }
}

